/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.builder;

import java.util.Properties;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.jbc.builder.SharedCacheInstanceManager;
import org.hibernate.cfg.Settings;
import org.hibernate.util.NamingHelper;
import org.hibernate.util.PropertiesHelper;
import org.jboss.cache.Cache;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JndiSharedCacheInstanceManager
extends SharedCacheInstanceManager {
    private static final Logger log = LoggerFactory.getLogger(JndiSharedCacheInstanceManager.class);
    public static final String CACHE_RESOURCE_PROP = "hibernate.cache.region.jbc2.cfg.shared";

    protected Cache createSharedCache(Settings settings, Properties properties) {
        String name = PropertiesHelper.getString((String)CACHE_RESOURCE_PROP, (Properties)properties, null);
        if (name == null) {
            throw new CacheException("Configuration property hibernate.cache.region.jbc2.cfg.shared not set");
        }
        return this.locateCache(name, NamingHelper.getJndiProperties((Properties)properties));
    }

    protected void stopSharedCache(Cache cache) {
    }

    private Cache locateCache(String jndiNamespace, Properties jndiProperties) {
        InitialContext ctx = null;
        try {
            ctx = new InitialContext(jndiProperties);
            Cache cache = (Cache)ctx.lookup(jndiNamespace);
            return cache;
        }
        catch (NamingException ne) {
            String msg = "Unable to retreive Cache from JNDI [" + jndiNamespace + "]";
            log.info(msg, (Throwable)ne);
            throw new CacheException(msg);
        }
        finally {
            if (ctx != null) {
                try {
                    ctx.close();
                }
                catch (NamingException ne) {
                    log.info("Unable to release initial context", (Throwable)ne);
                }
            }
        }
    }
}

