/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.jbc.collection;

import org.hibernate.cache.CacheDataDescription;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.CollectionRegion;
import org.hibernate.cache.access.AccessType;
import org.hibernate.cache.access.CollectionRegionAccessStrategy;
import org.hibernate.cache.jbc.TransactionalDataRegionAdapter;
import org.hibernate.cache.jbc.access.PutFromLoadValidator;
import org.hibernate.cache.jbc.collection.OptimisticReadOnlyAccess;
import org.hibernate.cache.jbc.collection.OptimisticTransactionalAccess;
import org.hibernate.cache.jbc.collection.ReadOnlyAccess;
import org.hibernate.cache.jbc.collection.TransactionalAccess;
import org.jboss.cache.Cache;
import org.jboss.cache.Fqn;
import org.jboss.cache.config.Configuration;
import org.jboss.cache.notifications.annotation.CacheListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@CacheListener
public class CollectionRegionImpl
extends TransactionalDataRegionAdapter
implements CollectionRegion {
    public static final String TYPE = "COLL";
    private boolean optimistic;

    public CollectionRegionImpl(Cache jbcCache, String regionName, String regionPrefix, CacheDataDescription metadata) {
        super(jbcCache, regionName, regionPrefix, metadata);
        this.optimistic = jbcCache.getConfiguration().getNodeLockingScheme() == Configuration.NodeLockingScheme.OPTIMISTIC;
    }

    public CollectionRegionAccessStrategy buildAccessStrategy(AccessType accessType) throws CacheException {
        if (AccessType.READ_ONLY.equals(accessType)) {
            return this.optimistic ? new OptimisticReadOnlyAccess(this) : new ReadOnlyAccess(this);
        }
        if (AccessType.TRANSACTIONAL.equals(accessType)) {
            return this.optimistic ? new OptimisticTransactionalAccess(this) : new TransactionalAccess(this);
        }
        throw new CacheException("unsupported access type [" + accessType.getName() + "]");
    }

    @Override
    protected Fqn<String> createRegionFqn(String regionName, String regionPrefix) {
        return CollectionRegionImpl.getTypeLastRegionFqn(regionName, regionPrefix, TYPE);
    }

    public PutFromLoadValidator getPutFromLoadValidator() {
        return new PutFromLoadValidator(this.transactionManager);
    }
}

