/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.metamodel;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.IdentifiableType;
import javax.persistence.metamodel.MappedSuperclassType;
import javax.persistence.metamodel.SingularAttribute;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.metamodel.AbstractIdentifiableType;
import org.hibernate.jpa.internal.metamodel.AbstractManagedType;
import org.hibernate.jpa.internal.metamodel.AttributeFactory;
import org.hibernate.jpa.internal.metamodel.AttributeImplementor;
import org.hibernate.jpa.internal.metamodel.EmbeddableTypeImpl;
import org.hibernate.jpa.internal.metamodel.EntityTypeImpl;
import org.hibernate.jpa.internal.metamodel.MappedSuperclassTypeImpl;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.MappedSuperclass;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.jboss.logging.Logger;

class MetadataContext {
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)MetadataContext.class.getName());
    private final SessionFactoryImplementor sessionFactory;
    private Set<MappedSuperclass> knownMappedSuperclasses;
    private final boolean ignoreUnsupported;
    private final AttributeFactory attributeFactory = new AttributeFactory(this);
    private Map<Class<?>, EntityTypeImpl<?>> entityTypes = new HashMap();
    private Map<String, EntityTypeImpl<?>> entityTypesByEntityName = new HashMap();
    private Map<PersistentClass, EntityTypeImpl<?>> entityTypesByPersistentClass = new HashMap();
    private Map<Class<?>, EmbeddableTypeImpl<?>> embeddables = new HashMap();
    private Map<MappedSuperclass, MappedSuperclassTypeImpl<?>> mappedSuperclassByMappedSuperclassMapping = new HashMap();
    private List<Object> orderedMappings = new ArrayList<Object>();
    private List<PersistentClass> stackOfPersistentClassesBeingProcessed = new ArrayList<PersistentClass>();
    private Map<MappedSuperclassTypeImpl<?>, PersistentClass> mappedSuperClassTypeToPersistentClass = new HashMap();
    private final Set<Class> processedMetamodelClasses = new HashSet<Class>();

    public MetadataContext(SessionFactoryImplementor sessionFactory, Set<MappedSuperclass> mappedSuperclasses, boolean ignoreUnsupported) {
        this.sessionFactory = sessionFactory;
        this.knownMappedSuperclasses = mappedSuperclasses;
        this.ignoreUnsupported = ignoreUnsupported;
    }

    SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    boolean isIgnoreUnsupported() {
        return this.ignoreUnsupported;
    }

    public Map<Class<?>, EntityTypeImpl<?>> getEntityTypeMap() {
        return Collections.unmodifiableMap(this.entityTypes);
    }

    public Map<Class<?>, EmbeddableTypeImpl<?>> getEmbeddableTypeMap() {
        return Collections.unmodifiableMap(this.embeddables);
    }

    public Map<Class<?>, MappedSuperclassType<?>> getMappedSuperclassTypeMap() {
        Map mappedSuperClassTypeMap = CollectionHelper.mapOfSize((int)this.mappedSuperclassByMappedSuperclassMapping.size());
        for (MappedSuperclassTypeImpl<?> mappedSuperclassType : this.mappedSuperclassByMappedSuperclassMapping.values()) {
            mappedSuperClassTypeMap.put(mappedSuperclassType.getJavaType(), mappedSuperclassType);
        }
        return mappedSuperClassTypeMap;
    }

    void registerEntityType(PersistentClass persistentClass, EntityTypeImpl<?> entityType) {
        this.entityTypes.put(entityType.getBindableJavaType(), entityType);
        this.entityTypesByEntityName.put(persistentClass.getEntityName(), entityType);
        this.entityTypesByPersistentClass.put(persistentClass, entityType);
        this.orderedMappings.add(persistentClass);
    }

    void registerEmbeddedableType(EmbeddableTypeImpl<?> embeddableType) {
        this.embeddables.put(embeddableType.getJavaType(), embeddableType);
    }

    void registerMappedSuperclassType(MappedSuperclass mappedSuperclass, MappedSuperclassTypeImpl<?> mappedSuperclassType) {
        this.mappedSuperclassByMappedSuperclassMapping.put(mappedSuperclass, mappedSuperclassType);
        this.orderedMappings.add(mappedSuperclass);
        this.mappedSuperClassTypeToPersistentClass.put(mappedSuperclassType, this.getEntityWorkedOn());
        this.knownMappedSuperclasses.remove(mappedSuperclass);
    }

    public EntityTypeImpl<?> locateEntityType(PersistentClass persistentClass) {
        return this.entityTypesByPersistentClass.get(persistentClass);
    }

    public EntityTypeImpl<?> locateEntityType(Class<?> javaType) {
        return this.entityTypes.get(javaType);
    }

    public EntityTypeImpl<?> locateEntityType(String entityName) {
        return this.entityTypesByEntityName.get(entityName);
    }

    public Map<String, EntityTypeImpl<?>> getEntityTypesByEntityName() {
        return Collections.unmodifiableMap(this.entityTypesByEntityName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wrapUp() {
        LOG.trace("Wrapping up metadata context...");
        for (Object object : this.orderedMappings) {
            AttributeImplementor attribute;
            Property property;
            Iterator properties;
            AbstractIdentifiableType jpa2Mapping;
            PersistentClass safeMapping;
            if (PersistentClass.class.isAssignableFrom(object.getClass())) {
                safeMapping = (PersistentClass)object;
                LOG.trace("Starting entity [" + safeMapping.getEntityName() + "]");
                try {
                    jpa2Mapping = this.entityTypesByPersistentClass.get(safeMapping);
                    this.applyIdMetadata(safeMapping, (EntityTypeImpl)jpa2Mapping);
                    this.applyVersionAttribute(safeMapping, (EntityTypeImpl)jpa2Mapping);
                    properties = safeMapping.getDeclaredPropertyIterator();
                    while (properties.hasNext()) {
                        property = (Property)properties.next();
                        if (property.getValue() == safeMapping.getIdentifierMapper() || safeMapping.isVersioned() && property == safeMapping.getVersion() || (attribute = this.attributeFactory.buildAttribute(jpa2Mapping, property)) == null) continue;
                        jpa2Mapping.getBuilder().addAttribute(attribute);
                    }
                    jpa2Mapping.lock();
                    this.populateStaticMetamodel(jpa2Mapping);
                    continue;
                }
                finally {
                    LOG.trace("Completed entity [" + safeMapping.getEntityName() + "]");
                    continue;
                }
            }
            if (MappedSuperclass.class.isAssignableFrom(object.getClass())) {
                safeMapping = (MappedSuperclass)object;
                LOG.trace("Starting mapped superclass [" + safeMapping.getMappedClass().getName() + "]");
                try {
                    jpa2Mapping = this.mappedSuperclassByMappedSuperclassMapping.get(safeMapping);
                    this.applyIdMetadata((MappedSuperclass)safeMapping, (MappedSuperclassTypeImpl)jpa2Mapping);
                    this.applyVersionAttribute((MappedSuperclass)safeMapping, (MappedSuperclassTypeImpl)jpa2Mapping);
                    properties = safeMapping.getDeclaredPropertyIterator();
                    while (properties.hasNext()) {
                        property = (Property)properties.next();
                        if (safeMapping.isVersioned() && property == safeMapping.getVersion() || (attribute = this.attributeFactory.buildAttribute(jpa2Mapping, property)) == null) continue;
                        jpa2Mapping.getBuilder().addAttribute(attribute);
                    }
                    jpa2Mapping.lock();
                    this.populateStaticMetamodel(jpa2Mapping);
                    continue;
                }
                finally {
                    LOG.trace("Completed mapped superclass [" + safeMapping.getMappedClass().getName() + "]");
                    continue;
                }
            }
            throw new AssertionFailure("Unexpected mapping type: " + object.getClass());
        }
        for (EmbeddableTypeImpl embeddableTypeImpl : this.embeddables.values()) {
            this.populateStaticMetamodel(embeddableTypeImpl);
        }
    }

    private <X> void applyIdMetadata(PersistentClass persistentClass, EntityTypeImpl<X> jpaEntityType) {
        if (persistentClass.hasIdentifierProperty()) {
            Property declaredIdentifierProperty = persistentClass.getDeclaredIdentifierProperty();
            if (declaredIdentifierProperty != null) {
                jpaEntityType.getBuilder().applyIdAttribute(this.attributeFactory.buildIdAttribute(jpaEntityType, declaredIdentifierProperty));
            }
        } else if (persistentClass.hasIdentifierMapper()) {
            Iterator propertyIterator = persistentClass.getIdentifierMapper().getPropertyIterator();
            Set attributes = this.buildIdClassAttributes(jpaEntityType, propertyIterator);
            jpaEntityType.getBuilder().applyIdClassAttributes(attributes);
        } else {
            Component component;
            KeyValue value = persistentClass.getIdentifier();
            if (value instanceof Component && (component = (Component)value).getPropertySpan() <= 1) {
                jpaEntityType.getBuilder().applyIdAttribute(this.attributeFactory.buildIdAttribute(jpaEntityType, (Property)component.getPropertyIterator().next()));
            }
        }
    }

    private <X> void applyIdMetadata(MappedSuperclass mappingType, MappedSuperclassTypeImpl<X> jpaMappingType) {
        if (mappingType.hasIdentifierProperty()) {
            Property declaredIdentifierProperty = mappingType.getDeclaredIdentifierProperty();
            if (declaredIdentifierProperty != null) {
                jpaMappingType.getBuilder().applyIdAttribute(this.attributeFactory.buildIdAttribute(jpaMappingType, declaredIdentifierProperty));
            }
        } else if (mappingType.getIdentifierMapper() != null) {
            Iterator propertyIterator = mappingType.getIdentifierMapper().getPropertyIterator();
            Set attributes = this.buildIdClassAttributes(jpaMappingType, propertyIterator);
            jpaMappingType.getBuilder().applyIdClassAttributes(attributes);
        }
    }

    private <X> void applyVersionAttribute(PersistentClass persistentClass, EntityTypeImpl<X> jpaEntityType) {
        Property declaredVersion = persistentClass.getDeclaredVersion();
        if (declaredVersion != null) {
            jpaEntityType.getBuilder().applyVersionAttribute(this.attributeFactory.buildVersionAttribute(jpaEntityType, declaredVersion));
        }
    }

    private <X> void applyVersionAttribute(MappedSuperclass mappingType, MappedSuperclassTypeImpl<X> jpaMappingType) {
        Property declaredVersion = mappingType.getDeclaredVersion();
        if (declaredVersion != null) {
            jpaMappingType.getBuilder().applyVersionAttribute(this.attributeFactory.buildVersionAttribute(jpaMappingType, declaredVersion));
        }
    }

    private <X> Set<SingularAttribute<? super X, ?>> buildIdClassAttributes(AbstractIdentifiableType<X> ownerType, Iterator<Property> propertyIterator) {
        LOG.trace("Building old-school composite identifier [" + ownerType.getJavaType().getName() + "]");
        HashSet attributes = new HashSet();
        while (propertyIterator.hasNext()) {
            attributes.add(this.attributeFactory.buildIdAttribute(ownerType, propertyIterator.next()));
        }
        return attributes;
    }

    private <X> void populateStaticMetamodel(AbstractManagedType<X> managedType) {
        Class managedTypeClass = managedType.getJavaType();
        if (managedTypeClass == null) {
            return;
        }
        String metamodelClassName = managedTypeClass.getName() + "_";
        try {
            Class<?> metamodelClass = Class.forName(metamodelClassName, true, managedTypeClass.getClassLoader());
            this.registerAttributes(metamodelClass, managedType);
        }
        catch (ClassNotFoundException ignore) {
            // empty catch block
        }
        AbstractManagedType<X> superType = managedType.getSupertype();
        if (superType != null) {
            this.populateStaticMetamodel(superType);
        }
    }

    private <X> void registerAttributes(Class metamodelClass, AbstractManagedType<X> managedType) {
        if (!this.processedMetamodelClasses.add(metamodelClass)) {
            return;
        }
        for (Attribute<X, ?> attribute : managedType.getDeclaredAttributes()) {
            this.registerAttribute(metamodelClass, attribute);
        }
        if (IdentifiableType.class.isInstance(managedType)) {
            Set attributes;
            AbstractIdentifiableType entityType = (AbstractIdentifiableType)managedType;
            if (entityType.hasDeclaredVersionAttribute()) {
                this.registerAttribute(metamodelClass, (Attribute<X, ?>)entityType.getDeclaredVersion());
            }
            if (entityType.hasIdClass() && (attributes = entityType.getIdClassAttributesSafely()) != null) {
                for (SingularAttribute attribute : attributes) {
                    this.registerAttribute(metamodelClass, (Attribute<X, ?>)attribute);
                }
            }
        }
    }

    private <X> void registerAttribute(Class metamodelClass, Attribute<X, ?> attribute) {
        String name = attribute.getName();
        try {
            Field field = attribute.getPersistentAttributeType() == Attribute.PersistentAttributeType.EMBEDDED ? metamodelClass.getField(name) : metamodelClass.getDeclaredField(name);
            try {
                if (!field.isAccessible()) {
                    field.setAccessible(true);
                }
                field.set(null, attribute);
            }
            catch (IllegalAccessException e) {
                throw new AssertionFailure("Unable to inject static metamodel attribute : " + metamodelClass.getName() + '#' + name, (Throwable)e);
            }
            catch (IllegalArgumentException e) {
                LOG.illegalArgumentOnStaticMetamodelFieldInjection(metamodelClass.getName(), name, attribute.getClass().getName(), field.getType().getName());
            }
        }
        catch (NoSuchFieldException e) {
            LOG.unableToLocateStaticMetamodelField(metamodelClass.getName(), name);
        }
    }

    public MappedSuperclassTypeImpl<?> locateMappedSuperclassType(MappedSuperclass mappedSuperclass) {
        return this.mappedSuperclassByMappedSuperclassMapping.get(mappedSuperclass);
    }

    public void pushEntityWorkedOn(PersistentClass persistentClass) {
        this.stackOfPersistentClassesBeingProcessed.add(persistentClass);
    }

    public void popEntityWorkedOn(PersistentClass persistentClass) {
        PersistentClass stackTop = this.stackOfPersistentClassesBeingProcessed.remove(this.stackOfPersistentClassesBeingProcessed.size() - 1);
        if (stackTop != persistentClass) {
            throw new AssertionFailure("Inconsistent popping: " + persistentClass.getEntityName() + " instead of " + stackTop.getEntityName());
        }
    }

    private PersistentClass getEntityWorkedOn() {
        return this.stackOfPersistentClassesBeingProcessed.get(this.stackOfPersistentClassesBeingProcessed.size() - 1);
    }

    public PersistentClass getPersistentClassHostingProperties(MappedSuperclassTypeImpl<?> mappedSuperclassType) {
        PersistentClass persistentClass = this.mappedSuperClassTypeToPersistentClass.get(mappedSuperclassType);
        if (persistentClass == null) {
            throw new AssertionFailure("Could not find PersistentClass for MappedSuperclassType: " + mappedSuperclassType.getJavaType());
        }
        return persistentClass;
    }

    public Set<MappedSuperclass> getUnusedMappedSuperclasses() {
        return new HashSet<MappedSuperclass>(this.knownMappedSuperclasses);
    }
}

