/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.internal.metamodel;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.TypeVariable;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.persistence.ManyToMany;
import javax.persistence.OneToOne;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.PluralAttribute;
import javax.persistence.metamodel.Type;
import org.hibernate.annotations.common.AssertionFailure;
import org.hibernate.jpa.internal.EntityManagerMessageLogger;
import org.hibernate.jpa.internal.metamodel.AbstractIdentifiableType;
import org.hibernate.jpa.internal.metamodel.AbstractManagedType;
import org.hibernate.jpa.internal.metamodel.AttributeImplementor;
import org.hibernate.jpa.internal.metamodel.BasicTypeImpl;
import org.hibernate.jpa.internal.metamodel.EmbeddableTypeImpl;
import org.hibernate.jpa.internal.metamodel.MapMember;
import org.hibernate.jpa.internal.metamodel.MappedSuperclassTypeImpl;
import org.hibernate.jpa.internal.metamodel.MetadataContext;
import org.hibernate.jpa.internal.metamodel.PluralAttributeImpl;
import org.hibernate.jpa.internal.metamodel.SingularAttributeImpl;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.Value;
import org.hibernate.property.Getter;
import org.hibernate.property.MapAccessor;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.type.ComponentType;
import org.hibernate.type.EmbeddedComponentType;
import org.hibernate.type.EntityType;
import org.hibernate.type.Type;
import org.jboss.logging.Logger;

public class AttributeFactory {
    private static final EntityManagerMessageLogger LOG = (EntityManagerMessageLogger)Logger.getMessageLogger(EntityManagerMessageLogger.class, (String)AttributeFactory.class.getName());
    private final MetadataContext context;
    private final MemberResolver EMBEDDED_MEMBER_RESOLVER = new MemberResolver(){

        @Override
        public Member resolveMember(AttributeContext attributeContext) {
            EmbeddableTypeImpl embeddableType = (EmbeddableTypeImpl)attributeContext.getOwnerType();
            String attributeName = attributeContext.getPropertyMapping().getName();
            Getter getter = embeddableType.getHibernateType().getComponentTuplizer().getGetter(embeddableType.getHibernateType().getPropertyIndex(attributeName));
            return MapAccessor.MapGetter.class.isInstance(getter) ? new MapMember(attributeName, attributeContext.getPropertyMapping().getType().getReturnedClass()) : getter.getMember();
        }
    };
    private final MemberResolver VIRTUAL_IDENTIFIER_MEMBER_RESOLVER = new MemberResolver(){

        @Override
        public Member resolveMember(AttributeContext attributeContext) {
            AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
            EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
            if (!entityMetamodel.getIdentifierProperty().isVirtual()) {
                throw new IllegalArgumentException("expecting IdClass mapping");
            }
            Type type = entityMetamodel.getIdentifierProperty().getType();
            if (!EmbeddedComponentType.class.isInstance(type)) {
                throw new IllegalArgumentException("expecting IdClass mapping");
            }
            EmbeddedComponentType componentType = (EmbeddedComponentType)type;
            String attributeName = attributeContext.getPropertyMapping().getName();
            Getter getter = componentType.getComponentTuplizer().getGetter(componentType.getPropertyIndex(attributeName));
            return MapAccessor.MapGetter.class.isInstance(getter) ? new MapMember(attributeName, attributeContext.getPropertyMapping().getType().getReturnedClass()) : getter.getMember();
        }
    };
    private final MemberResolver NORMAL_MEMBER_RESOLVER = new MemberResolver(){

        @Override
        public Member resolveMember(AttributeContext attributeContext) {
            AbstractManagedType ownerType = attributeContext.getOwnerType();
            Property property = attributeContext.getPropertyMapping();
            Type.PersistenceType persistenceType = ownerType.getPersistenceType();
            if (Type.PersistenceType.EMBEDDABLE == persistenceType) {
                return AttributeFactory.this.EMBEDDED_MEMBER_RESOLVER.resolveMember(attributeContext);
            }
            if (Type.PersistenceType.ENTITY == persistenceType || Type.PersistenceType.MAPPED_SUPERCLASS == persistenceType) {
                String propertyName;
                AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)ownerType;
                EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
                Integer index = entityMetamodel.getPropertyIndexOrNull(propertyName = property.getName());
                if (index == null) {
                    return AttributeFactory.this.VIRTUAL_IDENTIFIER_MEMBER_RESOLVER.resolveMember(attributeContext);
                }
                Getter getter = entityMetamodel.getTuplizer().getGetter(index.intValue());
                return MapAccessor.MapGetter.class.isInstance(getter) ? new MapMember(propertyName, property.getType().getReturnedClass()) : getter.getMember();
            }
            throw new IllegalArgumentException("Unexpected owner type : " + persistenceType);
        }
    };
    private final MemberResolver IDENTIFIER_MEMBER_RESOLVER = new MemberResolver(){

        @Override
        public Member resolveMember(AttributeContext attributeContext) {
            AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
            EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
            if (!attributeContext.getPropertyMapping().getName().equals(entityMetamodel.getIdentifierProperty().getName())) {
                return AttributeFactory.this.VIRTUAL_IDENTIFIER_MEMBER_RESOLVER.resolveMember(attributeContext);
            }
            Getter getter = entityMetamodel.getTuplizer().getIdentifierGetter();
            return MapAccessor.MapGetter.class.isInstance(getter) ? new MapMember(entityMetamodel.getIdentifierProperty().getName(), entityMetamodel.getIdentifierProperty().getType().getReturnedClass()) : getter.getMember();
        }
    };
    private final MemberResolver VERSION_MEMBER_RESOLVER = new MemberResolver(){

        @Override
        public Member resolveMember(AttributeContext attributeContext) {
            AbstractIdentifiableType identifiableType = (AbstractIdentifiableType)attributeContext.getOwnerType();
            EntityMetamodel entityMetamodel = AttributeFactory.this.getDeclarerEntityMetamodel(identifiableType);
            String versionPropertyName = attributeContext.getPropertyMapping().getName();
            if (!versionPropertyName.equals(entityMetamodel.getVersionProperty().getName())) {
                throw new IllegalArgumentException("Given property did not match declared version property");
            }
            Getter getter = entityMetamodel.getTuplizer().getVersionGetter();
            return MapAccessor.MapGetter.class.isInstance(getter) ? new MapMember(versionPropertyName, attributeContext.getPropertyMapping().getType().getReturnedClass()) : getter.getMember();
        }
    };

    public AttributeFactory(MetadataContext context) {
        this.context = context;
    }

    public <X, Y> AttributeImplementor<X, Y> buildAttribute(AbstractManagedType<X> ownerType, Property property) {
        if (property.isSynthetic()) {
            LOG.tracef("Skipping synthetic property %s(%s)", ownerType.getTypeName(), property.getName());
            return null;
        }
        LOG.trace("Building attribute [" + ownerType.getTypeName() + "." + property.getName() + "]");
        AttributeContext<X> attributeContext = this.wrap(ownerType, property);
        AttributeMetadata<X, Y> attributeMetadata = this.determineAttributeMetadata(attributeContext, this.NORMAL_MEMBER_RESOLVER);
        if (attributeMetadata == null) {
            return null;
        }
        if (attributeMetadata.isPlural()) {
            return this.buildPluralAttribute((PluralAttributeMetadata)attributeMetadata);
        }
        SingularAttributeMetadata singularAttributeMetadata = (SingularAttributeMetadata)attributeMetadata;
        javax.persistence.metamodel.Type<Y> metaModelType = this.getMetaModelType(singularAttributeMetadata.getValueContext());
        return new SingularAttributeImpl<X, Y>(attributeMetadata.getName(), attributeMetadata.getJavaType(), ownerType, attributeMetadata.getMember(), false, false, property.isOptional(), metaModelType, attributeMetadata.getPersistentAttributeType());
    }

    private <X> AttributeContext<X> wrap(final AbstractManagedType<X> ownerType, final Property property) {
        return new AttributeContext<X>(){

            @Override
            public AbstractManagedType<X> getOwnerType() {
                return ownerType;
            }

            @Override
            public Property getPropertyMapping() {
                return property;
            }
        };
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildIdAttribute(AbstractIdentifiableType<X> ownerType, Property property) {
        LOG.trace("Building identifier attribute [" + ownerType.getTypeName() + "." + property.getName() + "]");
        AttributeContext<X> attributeContext = this.wrap(ownerType, property);
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(attributeContext, this.IDENTIFIER_MEMBER_RESOLVER);
        javax.persistence.metamodel.Type<Y> metaModelType = this.getMetaModelType(attributeMetadata.getValueContext());
        return new SingularAttributeImpl.Identifier(property.getName(), attributeMetadata.getJavaType(), ownerType, attributeMetadata.getMember(), metaModelType, attributeMetadata.getPersistentAttributeType());
    }

    public <X, Y> SingularAttributeImpl<X, Y> buildVersionAttribute(AbstractIdentifiableType<X> ownerType, Property property) {
        LOG.trace("Building version attribute [ownerType.getTypeName().property.getName()]");
        AttributeContext<X> attributeContext = this.wrap(ownerType, property);
        SingularAttributeMetadata attributeMetadata = (SingularAttributeMetadata)this.determineAttributeMetadata(attributeContext, this.VERSION_MEMBER_RESOLVER);
        javax.persistence.metamodel.Type<Y> metaModelType = this.getMetaModelType(attributeMetadata.getValueContext());
        return new SingularAttributeImpl.Version(property.getName(), attributeMetadata.getJavaType(), ownerType, attributeMetadata.getMember(), metaModelType, attributeMetadata.getPersistentAttributeType());
    }

    private <X, Y, E, K> AttributeImplementor<X, Y> buildPluralAttribute(PluralAttributeMetadata<X, Y, E> attributeMetadata) {
        javax.persistence.metamodel.Type<Y> elementType = this.getMetaModelType(attributeMetadata.getElementValueContext());
        if (java.util.Map.class.isAssignableFrom(attributeMetadata.getJavaType())) {
            javax.persistence.metamodel.Type<Y> keyType = this.getMetaModelType(attributeMetadata.getMapKeyValueContext());
            return PluralAttributeImpl.create(attributeMetadata.getOwnerType(), elementType, attributeMetadata.getJavaType(), keyType).member(attributeMetadata.getMember()).property(attributeMetadata.getPropertyMapping()).persistentAttributeType(attributeMetadata.getPersistentAttributeType()).build();
        }
        return PluralAttributeImpl.create(attributeMetadata.getOwnerType(), elementType, attributeMetadata.getJavaType(), null).member(attributeMetadata.getMember()).property(attributeMetadata.getPropertyMapping()).persistentAttributeType(attributeMetadata.getPersistentAttributeType()).build();
    }

    private <Y> javax.persistence.metamodel.Type<Y> getMetaModelType(ValueContext typeContext) {
        switch (typeContext.getValueClassification()) {
            case BASIC: {
                return new BasicTypeImpl(typeContext.getBindableType(), Type.PersistenceType.BASIC);
            }
            case ENTITY: {
                EntityType type = (EntityType)typeContext.getValue().getType();
                return this.context.locateEntityType(type.getAssociatedEntityName());
            }
            case EMBEDDABLE: {
                Component component = (Component)typeContext.getValue();
                EmbeddableTypeImpl embeddableType = new EmbeddableTypeImpl(typeContext.getBindableType(), typeContext.getAttributeMetadata().getOwnerType(), (ComponentType)typeContext.getValue().getType());
                this.context.registerEmbeddedableType(embeddableType);
                Iterator subProperties = component.getPropertyIterator();
                while (subProperties.hasNext()) {
                    Property property = (Property)subProperties.next();
                    AttributeImplementor attribute = this.buildAttribute(embeddableType, property);
                    if (attribute == null) continue;
                    embeddableType.getBuilder().addAttribute(attribute);
                }
                embeddableType.lock();
                return embeddableType;
            }
        }
        throw new AssertionFailure("Unknown type : " + (Object)((Object)typeContext.getValueClassification()));
    }

    private EntityMetamodel getDeclarerEntityMetamodel(AbstractIdentifiableType<?> ownerType) {
        Type.PersistenceType persistenceType = ownerType.getPersistenceType();
        if (persistenceType == Type.PersistenceType.ENTITY) {
            return this.context.getSessionFactory().getEntityPersister(ownerType.getTypeName()).getEntityMetamodel();
        }
        if (persistenceType == Type.PersistenceType.MAPPED_SUPERCLASS) {
            PersistentClass persistentClass = this.context.getPersistentClassHostingProperties((MappedSuperclassTypeImpl)ownerType);
            return this.context.getSessionFactory().getEntityPersister(persistentClass.getClassName()).getEntityMetamodel();
        }
        throw new AssertionFailure("Cannot get the metamodel for PersistenceType: " + persistenceType);
    }

    private <X, Y> AttributeMetadata<X, Y> determineAttributeMetadata(AttributeContext<X> attributeContext, MemberResolver memberResolver) {
        LOG.trace("Starting attribute metadata determination [" + attributeContext.getPropertyMapping().getName() + "]");
        Member member = memberResolver.resolveMember(attributeContext);
        LOG.trace("    Determined member [" + member + "]");
        Value value = attributeContext.getPropertyMapping().getValue();
        Type type = value.getType();
        LOG.trace("    Determined type [name=" + type.getName() + ", class=" + type.getClass().getName() + "]");
        if (type.isAnyType()) {
            if (this.context.isIgnoreUnsupported()) {
                return null;
            }
            throw new UnsupportedOperationException("ANY not supported");
        }
        if (type.isAssociationType()) {
            if (type.isEntityType()) {
                return new SingularAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, AttributeFactory.determineSingularAssociationAttributeType(member));
            }
            if (value instanceof org.hibernate.mapping.Collection) {
                Attribute.PersistentAttributeType keyPersistentAttributeType;
                Attribute.PersistentAttributeType persistentAttributeType;
                Attribute.PersistentAttributeType elementPersistentAttributeType;
                org.hibernate.mapping.Collection collValue = (org.hibernate.mapping.Collection)value;
                Value elementValue = collValue.getElement();
                Type elementType = elementValue.getType();
                if (elementType.isAnyType()) {
                    throw new UnsupportedOperationException("collection of any not supported yet");
                }
                boolean isManyToMany = AttributeFactory.isManyToMany(member);
                if (elementValue instanceof Component) {
                    elementPersistentAttributeType = Attribute.PersistentAttributeType.EMBEDDED;
                    persistentAttributeType = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                } else if (elementType.isAssociationType()) {
                    persistentAttributeType = elementPersistentAttributeType = isManyToMany ? Attribute.PersistentAttributeType.MANY_TO_MANY : Attribute.PersistentAttributeType.ONE_TO_MANY;
                } else {
                    elementPersistentAttributeType = Attribute.PersistentAttributeType.BASIC;
                    persistentAttributeType = Attribute.PersistentAttributeType.ELEMENT_COLLECTION;
                }
                if (value instanceof Map) {
                    Value keyValue = ((Map)value).getIndex();
                    Type keyType = keyValue.getType();
                    if (keyType.isAnyType()) {
                        throw new UnsupportedOperationException("collection of any not supported yet");
                    }
                    keyPersistentAttributeType = keyValue instanceof Component ? Attribute.PersistentAttributeType.EMBEDDED : (keyType.isAssociationType() ? Attribute.PersistentAttributeType.MANY_TO_ONE : Attribute.PersistentAttributeType.BASIC);
                } else {
                    keyPersistentAttributeType = null;
                }
                return new PluralAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, persistentAttributeType, elementPersistentAttributeType, keyPersistentAttributeType);
            }
            if (value instanceof OneToMany) {
                throw new IllegalArgumentException("HUH???");
            }
        } else {
            if (attributeContext.getPropertyMapping().isComposite()) {
                return new SingularAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, Attribute.PersistentAttributeType.EMBEDDED);
            }
            return new SingularAttributeMetadataImpl(attributeContext.getPropertyMapping(), attributeContext.getOwnerType(), member, Attribute.PersistentAttributeType.BASIC);
        }
        throw new UnsupportedOperationException("oops, we are missing something: " + attributeContext.getPropertyMapping());
    }

    public static Attribute.PersistentAttributeType determineSingularAssociationAttributeType(Member member) {
        if (Field.class.isInstance(member)) {
            return ((Field)member).getAnnotation(OneToOne.class) != null ? Attribute.PersistentAttributeType.ONE_TO_ONE : Attribute.PersistentAttributeType.MANY_TO_ONE;
        }
        if (MapMember.class.isInstance(member)) {
            return Attribute.PersistentAttributeType.MANY_TO_ONE;
        }
        return ((Method)member).getAnnotation(OneToOne.class) != null ? Attribute.PersistentAttributeType.ONE_TO_ONE : Attribute.PersistentAttributeType.MANY_TO_ONE;
    }

    protected <Y> Class<Y> accountForPrimitiveTypes(Class<Y> declaredType) {
        return declaredType;
    }

    public static ParameterizedType getSignatureType(Member member) {
        java.lang.reflect.Type type = Field.class.isInstance(member) ? ((Field)member).getGenericType() : (Method.class.isInstance(member) ? ((Method)member).getGenericReturnType() : ((MapMember)member).getType());
        if (type instanceof Class) {
            return null;
        }
        return (ParameterizedType)type;
    }

    public static PluralAttribute.CollectionType determineCollectionType(Class javaType) {
        if (List.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.LIST;
        }
        if (Set.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.SET;
        }
        if (java.util.Map.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.MAP;
        }
        if (Collection.class.isAssignableFrom(javaType)) {
            return PluralAttribute.CollectionType.COLLECTION;
        }
        throw new IllegalArgumentException("Expecting collection type [" + javaType.getName() + "]");
    }

    public static boolean isManyToMany(Member member) {
        if (Field.class.isInstance(member)) {
            return ((Field)member).getAnnotation(ManyToMany.class) != null;
        }
        if (Method.class.isInstance(member)) {
            return ((Method)member).getAnnotation(ManyToMany.class) != null;
        }
        return false;
    }

    private class PluralAttributeMetadataImpl<X, Y, E>
    extends BaseAttributeMetadata<X, Y>
    implements PluralAttributeMetadata<X, Y, E> {
        private final PluralAttribute.CollectionType attributeCollectionType;
        private final Attribute.PersistentAttributeType elementPersistentAttributeType;
        private final Attribute.PersistentAttributeType keyPersistentAttributeType;
        private final Class elementJavaType;
        private final Class keyJavaType;
        private final ValueContext elementValueContext;
        private final ValueContext keyValueContext;

        private PluralAttributeMetadataImpl(Property propertyMapping, AbstractManagedType<X> ownerType, Member member, Attribute.PersistentAttributeType persistentAttributeType, Attribute.PersistentAttributeType elementPersistentAttributeType, Attribute.PersistentAttributeType keyPersistentAttributeType) {
            super(propertyMapping, ownerType, member, persistentAttributeType);
            this.attributeCollectionType = AttributeFactory.determineCollectionType(this.getJavaType());
            this.elementPersistentAttributeType = elementPersistentAttributeType;
            this.keyPersistentAttributeType = keyPersistentAttributeType;
            ParameterizedType signatureType = AttributeFactory.getSignatureType(member);
            if (keyPersistentAttributeType == null) {
                this.elementJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[0]) : Object.class;
                this.keyJavaType = null;
            } else {
                this.keyJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[0]) : Object.class;
                this.elementJavaType = signatureType != null ? this.getClassFromGenericArgument(signatureType.getActualTypeArguments()[1]) : Object.class;
            }
            this.elementValueContext = new ValueContext(){

                @Override
                public Value getValue() {
                    return ((org.hibernate.mapping.Collection)PluralAttributeMetadataImpl.this.getPropertyMapping().getValue()).getElement();
                }

                @Override
                public Class getBindableType() {
                    return PluralAttributeMetadataImpl.this.elementJavaType;
                }

                @Override
                public ValueContext.ValueClassification getValueClassification() {
                    switch (PluralAttributeMetadataImpl.this.elementPersistentAttributeType) {
                        case EMBEDDED: {
                            return ValueContext.ValueClassification.EMBEDDABLE;
                        }
                        case BASIC: {
                            return ValueContext.ValueClassification.BASIC;
                        }
                    }
                    return ValueContext.ValueClassification.ENTITY;
                }

                @Override
                public AttributeMetadata getAttributeMetadata() {
                    return PluralAttributeMetadataImpl.this;
                }
            };
            this.keyValueContext = keyPersistentAttributeType != null ? new ValueContext(){

                @Override
                public Value getValue() {
                    return ((Map)PluralAttributeMetadataImpl.this.getPropertyMapping().getValue()).getIndex();
                }

                @Override
                public Class getBindableType() {
                    return PluralAttributeMetadataImpl.this.keyJavaType;
                }

                @Override
                public ValueContext.ValueClassification getValueClassification() {
                    switch (PluralAttributeMetadataImpl.this.keyPersistentAttributeType) {
                        case EMBEDDED: {
                            return ValueContext.ValueClassification.EMBEDDABLE;
                        }
                        case BASIC: {
                            return ValueContext.ValueClassification.BASIC;
                        }
                    }
                    return ValueContext.ValueClassification.ENTITY;
                }

                @Override
                public AttributeMetadata getAttributeMetadata() {
                    return PluralAttributeMetadataImpl.this;
                }
            } : null;
        }

        private Class<?> getClassFromGenericArgument(java.lang.reflect.Type type) {
            if (type instanceof Class) {
                return (Class)type;
            }
            if (type instanceof TypeVariable) {
                java.lang.reflect.Type upperBound = ((TypeVariable)type).getBounds()[0];
                return this.getClassFromGenericArgument(upperBound);
            }
            if (type instanceof ParameterizedType) {
                java.lang.reflect.Type rawType = ((ParameterizedType)type).getRawType();
                return this.getClassFromGenericArgument(rawType);
            }
            throw new AssertionFailure("Fail to process type argument in a generic declaration. Member : " + this.getMemberDescription() + " Type: " + type.getClass());
        }

        @Override
        public ValueContext getElementValueContext() {
            return this.elementValueContext;
        }

        @Override
        public PluralAttribute.CollectionType getAttributeCollectionType() {
            return this.attributeCollectionType;
        }

        @Override
        public ValueContext getMapKeyValueContext() {
            return this.keyValueContext;
        }
    }

    private class SingularAttributeMetadataImpl<X, Y>
    extends BaseAttributeMetadata<X, Y>
    implements SingularAttributeMetadata<X, Y> {
        private final ValueContext valueContext;

        private SingularAttributeMetadataImpl(Property propertyMapping, AbstractManagedType<X> ownerType, Member member, Attribute.PersistentAttributeType persistentAttributeType) {
            super(propertyMapping, ownerType, member, persistentAttributeType);
            this.valueContext = new ValueContext(){

                @Override
                public Value getValue() {
                    return SingularAttributeMetadataImpl.this.getPropertyMapping().getValue();
                }

                @Override
                public Class getBindableType() {
                    return this.getAttributeMetadata().getJavaType();
                }

                @Override
                public ValueContext.ValueClassification getValueClassification() {
                    switch (SingularAttributeMetadataImpl.this.getPersistentAttributeType()) {
                        case EMBEDDED: {
                            return ValueContext.ValueClassification.EMBEDDABLE;
                        }
                        case BASIC: {
                            return ValueContext.ValueClassification.BASIC;
                        }
                    }
                    return ValueContext.ValueClassification.ENTITY;
                }

                @Override
                public AttributeMetadata getAttributeMetadata() {
                    return SingularAttributeMetadataImpl.this;
                }
            };
        }

        @Override
        public ValueContext getValueContext() {
            return this.valueContext;
        }
    }

    private abstract class BaseAttributeMetadata<X, Y>
    implements AttributeMetadata<X, Y> {
        private final Property propertyMapping;
        private final AbstractManagedType<X> ownerType;
        private final Member member;
        private final Class<Y> javaType;
        private final Attribute.PersistentAttributeType persistentAttributeType;

        protected BaseAttributeMetadata(Property propertyMapping, AbstractManagedType<X> ownerType, Member member, Attribute.PersistentAttributeType persistentAttributeType) {
            Class<?> declaredType;
            this.propertyMapping = propertyMapping;
            this.ownerType = ownerType;
            this.member = member;
            this.persistentAttributeType = persistentAttributeType;
            if (member == null) {
                declaredType = propertyMapping.getType().getReturnedClass();
            } else if (Field.class.isInstance(member)) {
                declaredType = ((Field)member).getType();
            } else if (Method.class.isInstance(member)) {
                declaredType = ((Method)member).getReturnType();
            } else if (MapMember.class.isInstance(member)) {
                declaredType = ((MapMember)member).getType();
            } else {
                throw new IllegalArgumentException("Cannot determine java-type from given member [" + member + "]");
            }
            this.javaType = AttributeFactory.this.accountForPrimitiveTypes(declaredType);
        }

        @Override
        public String getName() {
            return this.propertyMapping.getName();
        }

        @Override
        public Member getMember() {
            return this.member;
        }

        public String getMemberDescription() {
            return this.determineMemberDescription(this.getMember());
        }

        public String determineMemberDescription(Member member) {
            return member.getDeclaringClass().getName() + '#' + member.getName();
        }

        @Override
        public Class<Y> getJavaType() {
            return this.javaType;
        }

        @Override
        public Attribute.PersistentAttributeType getPersistentAttributeType() {
            return this.persistentAttributeType;
        }

        @Override
        public AbstractManagedType<X> getOwnerType() {
            return this.ownerType;
        }

        @Override
        public boolean isPlural() {
            return this.propertyMapping.getType().isCollectionType();
        }

        @Override
        public Property getPropertyMapping() {
            return this.propertyMapping;
        }
    }

    private static interface MemberResolver {
        public Member resolveMember(AttributeContext var1);
    }

    private static interface AttributeContext<X> {
        public AbstractManagedType<X> getOwnerType();

        public Property getPropertyMapping();
    }

    private static interface PluralAttributeMetadata<X, Y, E>
    extends AttributeMetadata<X, Y> {
        public PluralAttribute.CollectionType getAttributeCollectionType();

        public ValueContext getElementValueContext();

        public ValueContext getMapKeyValueContext();
    }

    private static interface SingularAttributeMetadata<X, Y>
    extends AttributeMetadata<X, Y> {
        public ValueContext getValueContext();
    }

    private static interface AttributeMetadata<X, Y> {
        public String getName();

        public Member getMember();

        public Class<Y> getJavaType();

        public Attribute.PersistentAttributeType getPersistentAttributeType();

        public AbstractManagedType<X> getOwnerType();

        public Property getPropertyMapping();

        public boolean isPlural();
    }

    private static interface ValueContext {
        public Value getValue();

        public Class getBindableType();

        public ValueClassification getValueClassification();

        public AttributeMetadata getAttributeMetadata();

        public static enum ValueClassification {
            EMBEDDABLE,
            ENTITY,
            BASIC;

        }
    }
}

