/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.jpa.event.internal.jpa;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Entity;
import javax.persistence.EntityListeners;
import javax.persistence.ExcludeDefaultListeners;
import javax.persistence.ExcludeSuperclassListeners;
import javax.persistence.MappedSuperclass;
import javax.persistence.PersistenceException;
import org.hibernate.MappingException;
import org.hibernate.annotations.common.reflection.ReflectionManager;
import org.hibernate.annotations.common.reflection.XClass;
import org.hibernate.annotations.common.reflection.XMethod;
import org.hibernate.jpa.event.internal.jpa.CallbackProcessor;
import org.hibernate.jpa.event.internal.jpa.CallbackRegistryImpl;
import org.hibernate.jpa.event.internal.jpa.EntityCallback;
import org.hibernate.jpa.event.internal.jpa.ListenerCallback;
import org.hibernate.jpa.event.spi.jpa.Callback;
import org.hibernate.jpa.event.spi.jpa.ListenerFactory;
import org.jboss.logging.Logger;

public class LegacyCallbackProcessor
implements CallbackProcessor {
    private static final Logger log = Logger.getLogger(LegacyCallbackProcessor.class);
    private final ListenerFactory jpaListenerFactory;
    private final ReflectionManager reflectionManager;
    private static boolean useAnnotationAnnotatedByListener = false;

    public LegacyCallbackProcessor(ListenerFactory jpaListenerFactory, ReflectionManager reflectionManager) {
        this.jpaListenerFactory = jpaListenerFactory;
        this.reflectionManager = reflectionManager;
    }

    @Override
    public void processCallbacksForEntity(Object entityObject, CallbackRegistryImpl callbackRegistry) {
        String entityClassName = (String)entityObject;
        try {
            XClass entityXClass = this.reflectionManager.classForName(entityClassName, this.getClass());
            Class entityClass = this.reflectionManager.toClass(entityXClass);
            for (Class annotationClass : CALLBACK_ANNOTATION_CLASSES) {
                Callback[] callbacks = this.resolveCallbacks(entityXClass, annotationClass, this.reflectionManager);
                callbackRegistry.addEntityCallbacks(entityClass, annotationClass, callbacks);
            }
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("entity class not found: " + entityClassName, (Throwable)e);
        }
    }

    public Callback[] resolveCallbacks(XClass beanClass, Class annotation, ReflectionManager reflectionManager) {
        List defaultListeners;
        ArrayList<Callback> callbacks = new ArrayList<Callback>();
        ArrayList<String> callbacksMethodNames = new ArrayList<String>();
        ArrayList<Class> orderedListeners = new ArrayList<Class>();
        XClass currentClazz = beanClass;
        boolean stopListeners = false;
        boolean stopDefaultListeners = false;
        do {
            EntityCallback callback = null;
            List methods = currentClazz.getDeclaredMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                Method method;
                String methodName;
                XMethod xMethod = (XMethod)methods.get(i);
                if (!xMethod.isAnnotationPresent(annotation) || callbacksMethodNames.contains(methodName = (method = reflectionManager.toMethod(xMethod)).getName())) continue;
                if (callback == null) {
                    callback = new EntityCallback(method);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 0) {
                        throw new RuntimeException("Callback methods annotated on the bean class must return void and take no arguments: " + annotation.getName() + " - " + xMethod);
                    }
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    log.debugf("Adding %s as %s callback for entity %s", (Object)methodName, (Object)annotation.getSimpleName(), (Object)beanClass.getName());
                    callbacks.add(0, callback);
                    callbacksMethodNames.add(0, methodName);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName());
            }
            if (!stopListeners) {
                LegacyCallbackProcessor.getListeners(currentClazz, orderedListeners);
                stopListeners = currentClazz.isAnnotationPresent(ExcludeSuperclassListeners.class);
                stopDefaultListeners = currentClazz.isAnnotationPresent(ExcludeDefaultListeners.class);
            }
            while ((currentClazz = currentClazz.getSuperclass()) != null && !currentClazz.isAnnotationPresent(Entity.class) && !currentClazz.isAnnotationPresent(MappedSuperclass.class)) {
            }
        } while (currentClazz != null);
        if (!stopDefaultListeners && (defaultListeners = (List)reflectionManager.getDefaults().get(EntityListeners.class)) != null) {
            int defaultListenerSize = defaultListeners.size();
            for (int i = defaultListenerSize - 1; i >= 0; --i) {
                orderedListeners.add((Class)defaultListeners.get(i));
            }
        }
        for (Class listener : orderedListeners) {
            ListenerCallback callback = null;
            if (listener == null) continue;
            XClass xListener = reflectionManager.toXClass(listener);
            callbacksMethodNames = new ArrayList();
            List methods = xListener.getDeclaredMethods();
            int size = methods.size();
            for (int i = 0; i < size; ++i) {
                Method method;
                String methodName;
                XMethod xMethod = (XMethod)methods.get(i);
                if (!xMethod.isAnnotationPresent(annotation) || callbacksMethodNames.contains(methodName = (method = reflectionManager.toMethod(xMethod)).getName())) continue;
                if (callback == null) {
                    callback = new ListenerCallback(this.jpaListenerFactory.buildListener(listener), method);
                    Class<?> returnType = method.getReturnType();
                    Class<?>[] args = method.getParameterTypes();
                    if (returnType != Void.TYPE || args.length != 1) {
                        throw new PersistenceException("Callback methods annotated in a listener bean class must return void and take one argument: " + annotation.getName() + " - " + method);
                    }
                    if (!method.isAccessible()) {
                        method.setAccessible(true);
                    }
                    log.debugf("Adding %s as %s callback for entity %s", (Object)methodName, (Object)annotation.getSimpleName(), (Object)beanClass.getName());
                    callbacks.add(0, callback);
                    continue;
                }
                throw new PersistenceException("You can only annotate one callback method with " + annotation.getName() + " in bean class: " + beanClass.getName() + " and callback listener: " + listener.getName());
            }
        }
        return callbacks.toArray(new Callback[callbacks.size()]);
    }

    private static void getListeners(XClass currentClazz, List<Class> orderedListeners) {
        EntityListeners entityListeners = (EntityListeners)currentClazz.getAnnotation(EntityListeners.class);
        if (entityListeners != null) {
            Class[] classes = entityListeners.value();
            int size = classes.length;
            for (int index = size - 1; index >= 0; --index) {
                orderedListeners.add(classes[index]);
            }
        }
        if (useAnnotationAnnotatedByListener) {
            Annotation[] annotations;
            for (Annotation annot : annotations = currentClazz.getAnnotations()) {
                entityListeners = annot.getClass().getAnnotation(EntityListeners.class);
                if (entityListeners == null) continue;
                Class[] classes = entityListeners.value();
                int size = classes.length;
                for (int index = size - 1; index >= 0; --index) {
                    orderedListeners.add(classes[index]);
                }
            }
        }
    }

    @Override
    public void release() {
    }

    static {
        Target target = EntityListeners.class.getAnnotation(Target.class);
        if (target != null) {
            for (ElementType type : target.value()) {
                if (!type.equals((Object)ElementType.ANNOTATION_TYPE)) continue;
                useAnnotationAnnotatedByListener = true;
            }
        }
    }
}

