/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.ejb.packaging;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.ClassFile;
import org.hibernate.ejb.EntityManagerLogger;
import org.hibernate.ejb.packaging.ClassFilter;
import org.hibernate.ejb.packaging.Entry;
import org.hibernate.ejb.packaging.FileFilter;
import org.hibernate.ejb.packaging.Filter;
import org.hibernate.ejb.packaging.JarVisitor;
import org.hibernate.ejb.packaging.JarVisitorFactory;
import org.hibernate.ejb.packaging.JavaElementFilter;
import org.hibernate.ejb.packaging.PackageFilter;
import org.jboss.logging.Logger;

public abstract class AbstractJarVisitor
implements JarVisitor {
    private static final EntityManagerLogger LOG = (EntityManagerLogger)Logger.getMessageLogger(EntityManagerLogger.class, (String)AbstractJarVisitor.class.getName());
    protected String unqualifiedJarName;
    protected URL jarUrl;
    protected boolean done = false;
    private List<Filter> filters = new ArrayList<Filter>();
    private Set<FileFilter> fileFilters = new HashSet<FileFilter>();
    private Set<JavaElementFilter> classFilters = new HashSet<JavaElementFilter>();
    private Set<JavaElementFilter> packageFilters = new HashSet<JavaElementFilter>();
    private Set[] entries;

    private AbstractJarVisitor(String jarPath) {
        this.jarUrl = JarVisitorFactory.getURLFromPath(jarPath);
        this.unqualify();
    }

    protected AbstractJarVisitor(String fileName, Filter[] filters) {
        this(fileName);
        this.initFilters(filters);
    }

    private void initFilters(Filter[] filters) {
        for (Filter filter : filters) {
            if (filter instanceof FileFilter) {
                this.fileFilters.add((FileFilter)filter);
            } else if (filter instanceof ClassFilter) {
                this.classFilters.add((ClassFilter)filter);
            } else if (filter instanceof PackageFilter) {
                this.packageFilters.add((PackageFilter)filter);
            } else {
                throw new AssertionError((Object)("Unknown filter type: " + filter.getClass().getName()));
            }
            this.filters.add(filter);
        }
        int size = this.filters.size();
        this.entries = new Set[size];
        for (int index = 0; index < size; ++index) {
            this.entries[index] = new HashSet();
        }
    }

    protected AbstractJarVisitor(URL url, Filter[] filters) {
        this(url);
        this.initFilters(filters);
    }

    private AbstractJarVisitor(URL url) {
        this.jarUrl = url;
        this.unqualify();
    }

    protected void unqualify() {
        int slash;
        String fileName = this.jarUrl.getFile();
        int exclamation = fileName.lastIndexOf("!");
        if (exclamation != -1) {
            fileName = fileName.substring(0, exclamation);
        }
        if ((slash = fileName.lastIndexOf("/")) != -1) {
            fileName = fileName.substring(fileName.lastIndexOf("/") + 1, fileName.length());
        }
        if (fileName.length() > 4 && fileName.endsWith("ar") && fileName.charAt(fileName.length() - 4) == '.') {
            fileName = fileName.substring(0, fileName.length() - 4);
        }
        this.unqualifiedJarName = fileName;
        LOG.debugf("Searching mapped entities in jar/par: %s", this.jarUrl);
    }

    @Override
    public String getUnqualifiedJarName() {
        return this.unqualifiedJarName;
    }

    @Override
    public Filter[] getFilters() {
        return this.filters.toArray(new Filter[this.filters.size()]);
    }

    @Override
    public Set[] getMatchingEntries() throws IOException {
        if (!this.done) {
            if (this.filters.size() > 0) {
                this.doProcessElements();
            }
            this.done = true;
        }
        return this.entries;
    }

    protected abstract void doProcessElements() throws IOException;

    protected final void addElement(String entryName, InputStream is, InputStream secondIs) throws IOException {
        int entryNameLength = entryName.length();
        if (entryName.endsWith("package-info.class")) {
            String name = entryNameLength == "package-info.class".length() ? "" : entryName.substring(0, entryNameLength - ".package-info.class".length()).replace('/', '.');
            this.executeJavaElementFilter(name, this.packageFilters, is, secondIs);
        } else if (entryName.endsWith(".class")) {
            String name = entryName.substring(0, entryNameLength - ".class".length()).replace('/', '.');
            LOG.debugf("Filtering: %s", name);
            this.executeJavaElementFilter(name, this.classFilters, is, secondIs);
        } else {
            String name = entryName;
            boolean accepted = false;
            for (FileFilter filter : this.fileFilters) {
                InputStream localIs;
                if (!filter.accept(name)) continue;
                accepted = true;
                if (filter.getStream()) {
                    localIs = secondIs;
                } else {
                    localIs = null;
                    secondIs.close();
                }
                is.close();
                LOG.debugf("File Filter matched for %s", name);
                Entry entry = new Entry(name, localIs);
                int index = this.filters.indexOf(filter);
                this.entries[index].add(entry);
            }
            if (!accepted) {
                is.close();
                secondIs.close();
            }
        }
    }

    private void executeJavaElementFilter(String name, Set<JavaElementFilter> filters, InputStream is, InputStream secondIs) throws IOException {
        boolean accepted = false;
        for (JavaElementFilter filter : filters) {
            InputStream localIs;
            boolean match;
            if (!filter.accept(name) || !(match = this.checkAnnotationMatching(is, filter))) continue;
            accepted = true;
            if (filter.getStream()) {
                localIs = secondIs;
            } else {
                localIs = null;
                secondIs.close();
            }
            LOG.debugf("Java element filter matched for %s", name);
            Entry entry = new Entry(name, localIs);
            int index = this.filters.indexOf(filter);
            this.entries[index].add(entry);
            break;
        }
        if (!accepted) {
            is.close();
            secondIs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkAnnotationMatching(InputStream is, JavaElementFilter filter) throws IOException {
        if (filter.getAnnotations().length == 0) {
            is.close();
            return true;
        }
        DataInputStream dstream = new DataInputStream(is);
        ClassFile cf = null;
        try {
            cf = new ClassFile(dstream);
        }
        finally {
            dstream.close();
            is.close();
        }
        boolean match = false;
        AnnotationsAttribute visible = (AnnotationsAttribute)cf.getAttribute("RuntimeVisibleAnnotations");
        if (visible != null) {
            for (Class annotation : filter.getAnnotations()) {
                boolean bl = match = visible.getAnnotation(annotation.getName()) != null;
                if (match) break;
            }
        }
        return match;
    }
}

