/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.custom.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.hibernate.QueryException;
import org.hibernate.engine.query.spi.ParameterParser;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.persister.collection.SQLLoadableCollection;
import org.hibernate.persister.entity.SQLLoadable;

public class SQLQueryParser {
    private static final Pattern PREPARED_STATEMENT_PATTERN = Pattern.compile("^\\{.*?\\}$");
    private static final String HIBERNATE_PLACEHOLDER_PREFIX = "h-";
    private static final String DOMAIN_PLACEHOLDER = "h-domain";
    private static final String CATALOG_PLACEHOLDER = "h-catalog";
    private static final String SCHEMA_PLACEHOLDER = "h-schema";
    private final SessionFactoryImplementor factory;
    private final String originalQueryString;
    private final ParserContext context;
    private final Map namedParameters = new HashMap();
    private long aliasesFound;

    public SQLQueryParser(String queryString, ParserContext context, SessionFactoryImplementor factory) {
        this.originalQueryString = queryString;
        this.context = context;
        this.factory = factory;
    }

    public Map getNamedParameters() {
        return this.namedParameters;
    }

    public boolean queryHasAliases() {
        return this.aliasesFound > 0L;
    }

    protected String getOriginalQueryString() {
        return this.originalQueryString;
    }

    public String process() {
        String processedSql = this.substituteBrackets(this.originalQueryString);
        processedSql = this.substituteParams(processedSql);
        return processedSql;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected String substituteBrackets(String sqlQuery) throws QueryException {
        if (PREPARED_STATEMENT_PATTERN.matcher(sqlQuery.trim()).matches()) {
            return sqlQuery;
        }
        StringBuilder result = new StringBuilder(sqlQuery.length() + 20);
        int curr = 0;
        while (curr < sqlQuery.length()) {
            int left = sqlQuery.indexOf(123, curr);
            if (left < 0) {
                result.append(sqlQuery.substring(curr));
                return result.toString();
            }
            result.append(sqlQuery.substring(curr, left));
            int right = sqlQuery.indexOf(125, left + 1);
            if (right < 0) {
                throw new QueryException("Unmatched braces for alias path", sqlQuery);
            }
            String aliasPath = sqlQuery.substring(left + 1, right);
            boolean isPlaceholder = aliasPath.startsWith(HIBERNATE_PLACEHOLDER_PREFIX);
            if (isPlaceholder) {
                if (DOMAIN_PLACEHOLDER.equals(aliasPath)) {
                    String schemaName;
                    String catalogName = this.factory.getSettings().getDefaultCatalogName();
                    if (catalogName != null) {
                        result.append(catalogName);
                        result.append(".");
                    }
                    if ((schemaName = this.factory.getSettings().getDefaultSchemaName()) != null) {
                        result.append(schemaName);
                        result.append(".");
                    }
                } else if (SCHEMA_PLACEHOLDER.equals(aliasPath)) {
                    String schemaName = this.factory.getSettings().getDefaultSchemaName();
                    if (schemaName != null) {
                        result.append(schemaName);
                        result.append(".");
                    }
                } else {
                    if (!CATALOG_PLACEHOLDER.equals(aliasPath)) throw new QueryException("Unknown placeholder ", aliasPath);
                    String catalogName = this.factory.getSettings().getDefaultCatalogName();
                    if (catalogName != null) {
                        result.append(catalogName);
                        result.append(".");
                    }
                }
            } else if (this.context != null) {
                int firstDot = aliasPath.indexOf(46);
                if (firstDot == -1) {
                    if (this.context.isEntityAlias(aliasPath)) {
                        result.append(aliasPath);
                        ++this.aliasesFound;
                    } else {
                        result.append('{').append(aliasPath).append('}');
                    }
                } else {
                    String propertyName;
                    String aliasName = aliasPath.substring(0, firstDot);
                    if (this.context.isCollectionAlias(aliasName)) {
                        propertyName = aliasPath.substring(firstDot + 1);
                        result.append(this.resolveCollectionProperties(aliasName, propertyName));
                        ++this.aliasesFound;
                    } else if (this.context.isEntityAlias(aliasName)) {
                        propertyName = aliasPath.substring(firstDot + 1);
                        result.append(this.resolveProperties(aliasName, propertyName));
                        ++this.aliasesFound;
                    } else {
                        result.append('{').append(aliasPath).append('}');
                    }
                }
            }
            curr = right + 1;
        }
        return result.toString();
    }

    private String resolveCollectionProperties(String aliasName, String propertyName) {
        Map fieldResults = this.context.getPropertyResultsMapByAlias(aliasName);
        SQLLoadableCollection collectionPersister = this.context.getCollectionPersisterByAlias(aliasName);
        String collectionSuffix = this.context.getCollectionSuffixByAlias(aliasName);
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            String selectFragment = collectionPersister.selectFragment(aliasName, collectionSuffix);
            ++this.aliasesFound;
            return selectFragment + ", " + this.resolveProperties(aliasName, propertyName);
        }
        if ("element.*".equals(propertyName)) {
            return this.resolveProperties(aliasName, "*");
        }
        String[] columnAliases = (String[])fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = collectionPersister.getCollectionPropertyColumnAliases(propertyName, collectionSuffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.originalQueryString);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.originalQueryString);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String resolveProperties(String aliasName, String propertyName) {
        Map fieldResults = this.context.getPropertyResultsMapByAlias(aliasName);
        SQLLoadable persister = this.context.getEntityPersisterByAlias(aliasName);
        String suffix = this.context.getEntitySuffixByAlias(aliasName);
        if ("*".equals(propertyName)) {
            if (!fieldResults.isEmpty()) {
                throw new QueryException("Using return-propertys together with * syntax is not supported.");
            }
            ++this.aliasesFound;
            return persister.selectFragment(aliasName, suffix);
        }
        String[] columnAliases = (String[])fieldResults.get(propertyName);
        if (columnAliases == null) {
            columnAliases = persister.getSubclassPropertyColumnAliases(propertyName, suffix);
        }
        if (columnAliases == null || columnAliases.length == 0) {
            throw new QueryException("No column name found for property [" + propertyName + "] for alias [" + aliasName + "]", this.originalQueryString);
        }
        if (columnAliases.length != 1) {
            throw new QueryException("SQL queries only support properties mapped to a single column - property [" + propertyName + "] is mapped to " + columnAliases.length + " columns.", this.originalQueryString);
        }
        ++this.aliasesFound;
        return columnAliases[0];
    }

    private String substituteParams(String sqlString) {
        ParameterSubstitutionRecognizer recognizer = new ParameterSubstitutionRecognizer();
        ParameterParser.parse(sqlString, recognizer);
        this.namedParameters.clear();
        this.namedParameters.putAll(recognizer.namedParameterBindPoints);
        return recognizer.result.toString();
    }

    public static class ParameterSubstitutionRecognizer
    implements ParameterParser.Recognizer {
        StringBuilder result = new StringBuilder();
        Map namedParameterBindPoints = new HashMap();
        int parameterCount;

        @Override
        public void outParameter(int position) {
            this.result.append('?');
        }

        @Override
        public void ordinalParameter(int position) {
            this.result.append('?');
        }

        @Override
        public void namedParameter(String name, int position) {
            this.addNamedParameter(name);
            this.result.append('?');
        }

        @Override
        public void jpaPositionalParameter(String name, int position) {
            this.namedParameter(name, position);
        }

        @Override
        public void other(char character) {
            this.result.append(character);
        }

        private void addNamedParameter(String name) {
            Integer loc = this.parameterCount++;
            Object o = this.namedParameterBindPoints.get(name);
            if (o == null) {
                this.namedParameterBindPoints.put(name, loc);
            } else if (o instanceof Integer) {
                ArrayList<Object> list = new ArrayList<Object>(4);
                list.add(o);
                list.add(loc);
                this.namedParameterBindPoints.put(name, list);
            } else {
                ((List)o).add(loc);
            }
        }
    }

    static interface ParserContext {
        public boolean isEntityAlias(String var1);

        public SQLLoadable getEntityPersisterByAlias(String var1);

        public String getEntitySuffixByAlias(String var1);

        public boolean isCollectionAlias(String var1);

        public SQLLoadableCollection getCollectionPersisterByAlias(String var1);

        public String getCollectionSuffixByAlias(String var1);

        public Map getPropertyResultsMapByAlias(String var1);
    }
}

