/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal.exec;

import java.sql.Connection;
import java.sql.SQLException;
import org.hibernate.engine.jdbc.connections.spi.JdbcConnectionAccess;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.spi.SqlStatementLogger;
import org.hibernate.tool.schema.internal.exec.JdbcConnectionContext;
import org.hibernate.tool.schema.spi.SchemaManagementException;

public abstract class AbstractJdbcConnectionContextImpl
implements JdbcConnectionContext {
    private final JdbcConnectionAccess jdbcConnectionAccess;
    private final SqlStatementLogger sqlStatementLogger;
    private final boolean needsAutoCommit;
    private Connection jdbcConnection;
    private boolean wasInitiallyAutoCommit;

    public AbstractJdbcConnectionContextImpl(JdbcConnectionAccess jdbcConnectionAccess, SqlStatementLogger sqlStatementLogger, boolean needsAutoCommit) {
        this.jdbcConnectionAccess = jdbcConnectionAccess;
        this.sqlStatementLogger = sqlStatementLogger;
        this.needsAutoCommit = needsAutoCommit;
    }

    @Override
    public Connection getConnection() {
        if (this.jdbcConnection == null) {
            try {
                this.jdbcConnection = this.jdbcConnectionAccess.obtainConnection();
            }
            catch (SQLException e) {
                throw new SchemaManagementException("Unable to obtain JDBC Connection", e);
            }
            try {
                if (this.needsAutoCommit) {
                    this.wasInitiallyAutoCommit = this.jdbcConnection.getAutoCommit();
                    this.jdbcConnection.setAutoCommit(true);
                }
            }
            catch (SQLException e) {
                throw new SchemaManagementException("Unable to manage auto-commit", e);
            }
        }
        return this.jdbcConnection;
    }

    @Override
    public void logSqlStatement(String sqlStatement) {
        this.sqlStatementLogger.logStatement(sqlStatement, FormatStyle.NONE.getFormatter());
    }

    protected void reallyRelease() {
        if (this.jdbcConnection != null) {
            try {
                if (!this.jdbcConnection.getAutoCommit()) {
                    this.jdbcConnection.commit();
                } else if (this.needsAutoCommit && !this.wasInitiallyAutoCommit) {
                    this.jdbcConnection.setAutoCommit(false);
                }
            }
            catch (SQLException e) {
                throw new SchemaManagementException("Unable to reset auto-commit afterQuery schema management;  may or may not be a problem", e);
            }
            try {
                this.jdbcConnectionAccess.releaseConnection(this.jdbcConnection);
            }
            catch (SQLException e) {
                throw new SchemaManagementException("Unable to release JDBC Connection", e);
            }
        }
    }
}

