/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.internal.javassist;

import java.lang.reflect.Modifier;
import org.hibernate.bytecode.internal.javassist.AccessOptimizerAdapter;
import org.hibernate.bytecode.internal.javassist.BulkAccessor;
import org.hibernate.bytecode.internal.javassist.BulkAccessorException;
import org.hibernate.bytecode.internal.javassist.FastClass;
import org.hibernate.bytecode.internal.javassist.InstantiationOptimizerAdapter;
import org.hibernate.bytecode.internal.javassist.ProxyFactoryFactoryImpl;
import org.hibernate.bytecode.internal.javassist.ReflectionOptimizerImpl;
import org.hibernate.bytecode.spi.BytecodeProvider;
import org.hibernate.bytecode.spi.ProxyFactoryFactory;
import org.hibernate.bytecode.spi.ReflectionOptimizer;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.jboss.logging.Logger;

public class BytecodeProviderImpl
implements BytecodeProvider {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)BytecodeProviderImpl.class.getName());

    @Override
    public ProxyFactoryFactory getProxyFactoryFactory() {
        return new ProxyFactoryFactoryImpl();
    }

    @Override
    public ReflectionOptimizer getReflectionOptimizer(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        BulkAccessor bulkAccessor;
        FastClass fastClass;
        block8: {
            try {
                fastClass = FastClass.create(clazz);
                bulkAccessor = BulkAccessor.create(clazz, getterNames, setterNames, types);
                if (!clazz.isInterface() && !Modifier.isAbstract(clazz.getModifiers())) {
                    if (fastClass == null) {
                        bulkAccessor = null;
                    } else {
                        Object instance = fastClass.newInstance();
                        bulkAccessor.setPropertyValues(instance, bulkAccessor.getPropertyValues(instance));
                    }
                }
            }
            catch (Throwable t) {
                fastClass = null;
                bulkAccessor = null;
                if (!LOG.isDebugEnabled()) break block8;
                int index = 0;
                if (t instanceof BulkAccessorException) {
                    index = ((BulkAccessorException)((Object)t)).getIndex();
                }
                if (index >= 0) {
                    LOG.debugf("Reflection optimizer disabled for %s [%s: %s (property %s)]", new Object[]{clazz.getName(), StringHelper.unqualify(t.getClass().getName()), t.getMessage(), setterNames[index]});
                }
                LOG.debugf("Reflection optimizer disabled for %s [%s: %s]", clazz.getName(), StringHelper.unqualify(t.getClass().getName()), t.getMessage());
            }
        }
        if (fastClass != null && bulkAccessor != null) {
            return new ReflectionOptimizerImpl(new InstantiationOptimizerAdapter(fastClass), new AccessOptimizerAdapter(bulkAccessor, clazz));
        }
        return null;
    }
}

