/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.io.FileWriter;
import java.io.IOException;
import org.hibernate.engine.jdbc.internal.FormatStyle;
import org.hibernate.engine.jdbc.internal.Formatter;
import org.hibernate.tool.schema.spi.SchemaManagementException;
import org.hibernate.tool.schema.spi.Target;

public class TargetFileImpl
implements Target {
    private final FileWriter fileWriter;
    private final String delimiter;
    private final Formatter formatter;

    public TargetFileImpl(String outputFile, String delimiter) {
        this(outputFile, delimiter, FormatStyle.NONE.getFormatter());
    }

    public TargetFileImpl(String outputFile, String delimiter, Formatter formatter) {
        try {
            this.delimiter = delimiter;
            this.fileWriter = new FileWriter(outputFile);
            this.formatter = formatter;
        }
        catch (IOException e) {
            throw new SchemaManagementException("Unable to open FileWriter [" + outputFile + "]", e);
        }
    }

    @Override
    public boolean acceptsImportScriptActions() {
        return true;
    }

    @Override
    public void prepare() {
    }

    @Override
    public void accept(String action) {
        try {
            if (this.formatter != null) {
                action = this.formatter.format(action);
            }
            this.fileWriter.write(action);
            if (this.delimiter != null) {
                this.fileWriter.write(this.delimiter);
            }
            this.fileWriter.write("\n");
        }
        catch (IOException e) {
            throw new SchemaManagementException("Unable to write to FileWriter", e);
        }
    }

    @Override
    public void release() {
        if (this.fileWriter != null) {
            try {
                this.fileWriter.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

