/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.enhance.internal;

import java.util.IdentityHashMap;
import java.util.LinkedList;
import java.util.Map;
import javassist.CannotCompileException;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.Modifier;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.CodeIterator;
import javassist.bytecode.ConstPool;
import javassist.bytecode.MethodInfo;
import javassist.bytecode.stackmap.MapMaker;
import javax.persistence.Embedded;
import javax.persistence.Id;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import org.hibernate.Hibernate;
import org.hibernate.bytecode.enhance.internal.AttributeTypeDescriptor;
import org.hibernate.bytecode.enhance.internal.MethodWriter;
import org.hibernate.bytecode.enhance.internal.PersistentAttributesHelper;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.EnhancementException;
import org.hibernate.bytecode.enhance.spi.Enhancer;
import org.hibernate.engine.spi.CompositeOwner;
import org.hibernate.engine.spi.CompositeTracker;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;

public class PersistentAttributesEnhancer
extends Enhancer {
    private static final CoreMessageLogger log = CoreLogging.messageLogger(PersistentAttributesEnhancer.class);

    public PersistentAttributesEnhancer(EnhancementContext context) {
        super(context);
    }

    public void enhance(CtClass managedCtClass) {
        IdentityHashMap<String, PersistentAttributeAccessMethods> attrDescriptorMap = new IdentityHashMap<String, PersistentAttributeAccessMethods>();
        for (CtField persistentField : this.collectPersistentFields(managedCtClass)) {
            attrDescriptorMap.put(persistentField.getName(), this.enhancePersistentAttribute(managedCtClass, persistentField));
        }
        this.enhanceAttributesAccess(managedCtClass, attrDescriptorMap);
        if (this.enhancementContext.doExtendedEnhancement(managedCtClass)) {
            this.extendedEnhancement(managedCtClass);
        }
    }

    private CtField[] collectPersistentFields(CtClass managedCtClass) {
        LinkedList<CtField> persistentFieldList = new LinkedList<CtField>();
        for (CtField ctField : managedCtClass.getDeclaredFields()) {
            if (Modifier.isStatic((int)ctField.getModifiers()) || ctField.getName().startsWith("$$_hibernate_") || "this$0".equals(ctField.getName()) || !this.enhancementContext.isPersistentField(ctField)) continue;
            persistentFieldList.add(ctField);
        }
        return this.enhancementContext.order(persistentFieldList.toArray(new CtField[persistentFieldList.size()]));
    }

    private PersistentAttributeAccessMethods enhancePersistentAttribute(CtClass managedCtClass, CtField persistentField) {
        try {
            AttributeTypeDescriptor typeDescriptor = AttributeTypeDescriptor.resolve(persistentField);
            return new PersistentAttributeAccessMethods(this.generateFieldReader(managedCtClass, persistentField, typeDescriptor), this.generateFieldWriter(managedCtClass, persistentField, typeDescriptor));
        }
        catch (Exception e) {
            String msg = String.format("Unable to enhance persistent attribute [%s:%s]", managedCtClass.getName(), persistentField.getName());
            throw new EnhancementException(msg, e);
        }
    }

    private CtMethod generateFieldReader(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String readerName = "$$_hibernate_read_" + fieldName;
        if (!this.enhancementContext.hasLazyLoadableAttributes(managedCtClass) || !this.enhancementContext.isLazyLoadable(persistentField)) {
            return MethodWriter.addGetter(managedCtClass, fieldName, readerName);
        }
        try {
            return MethodWriter.write(managedCtClass, "public %s %s() {%n%s%n  return this.%s;%n}", persistentField.getType().getName(), readerName, typeDescriptor.buildReadInterceptionBodyFragment(fieldName), fieldName);
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance entity class [%s] to add field reader method [%s]", managedCtClass.getName(), readerName);
            throw new EnhancementException(msg, nfe);
        }
    }

    private CtMethod generateFieldWriter(CtClass managedCtClass, CtField persistentField, AttributeTypeDescriptor typeDescriptor) {
        String fieldName = persistentField.getName();
        String writerName = "$$_hibernate_write_" + fieldName;
        try {
            CtMethod writer = !this.enhancementContext.hasLazyLoadableAttributes(managedCtClass) || !this.enhancementContext.isLazyLoadable(persistentField) ? MethodWriter.addSetter(managedCtClass, fieldName, writerName) : MethodWriter.write(managedCtClass, "public void %s(%s %s) {%n%s%n}", writerName, persistentField.getType().getName(), fieldName, typeDescriptor.buildWriteInterceptionBodyFragment(fieldName));
            if (this.enhancementContext.doDirtyCheckingInline(managedCtClass)) {
                if (this.enhancementContext.isCompositeClass(managedCtClass)) {
                    writer.insertBefore(String.format("  if (%1$s != null) { %1$s.callOwner(\"\"); }%n", "$$_hibernate_compositeOwners"));
                } else {
                    writer.insertBefore(typeDescriptor.buildInLineDirtyCheckingBodyFragment(this.enhancementContext, persistentField));
                }
                this.handleCompositeField(managedCtClass, persistentField, writer);
            }
            if (this.enhancementContext.doBiDirectionalAssociationManagement(persistentField)) {
                this.handleBiDirectionalAssociation(managedCtClass, persistentField, writer);
            }
            return writer;
        }
        catch (CannotCompileException cce) {
            String msg = String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName);
            throw new EnhancementException(msg, cce);
        }
        catch (NotFoundException nfe) {
            String msg = String.format("Could not enhance entity class [%s] to add field writer method [%s]", managedCtClass.getName(), writerName);
            throw new EnhancementException(msg, nfe);
        }
    }

    private void handleBiDirectionalAssociation(CtClass managedCtClass, CtField persistentField, CtMethod fieldWriter) throws NotFoundException, CannotCompileException {
        CtMethod setter;
        CtMethod getter;
        if (!PersistentAttributesHelper.isPossibleBiDirectionalAssociation(persistentField)) {
            return;
        }
        CtClass targetEntity = PersistentAttributesHelper.getTargetEntityClass(managedCtClass, persistentField);
        if (targetEntity == null) {
            log.infof("Could not find type of bi-directional association for field [%s#%s]", managedCtClass.getName(), persistentField.getName());
            return;
        }
        String mappedBy = PersistentAttributesHelper.getMappedBy(persistentField, targetEntity, this.enhancementContext);
        if (mappedBy == null || mappedBy.isEmpty()) {
            log.infof("Could not find bi-directional association for field [%s#%s]", managedCtClass.getName(), persistentField.getName());
            return;
        }
        String mappedByGetterName = "$$_hibernate_read_" + mappedBy;
        String mappedBySetterName = "$$_hibernate_write_" + mappedBy;
        boolean tmpTargetMethods = false;
        try {
            getter = targetEntity.getDeclaredMethod(mappedByGetterName);
            setter = targetEntity.getDeclaredMethod(mappedByGetterName);
        }
        catch (NotFoundException nfe) {
            getter = MethodWriter.addGetter(targetEntity, mappedBy, mappedByGetterName);
            setter = MethodWriter.addSetter(targetEntity, mappedBy, mappedBySetterName);
            tmpTargetMethods = true;
        }
        String currentAssociationLoaded = String.format("%s.isPropertyInitialized(this.%s, \"%s\")", Hibernate.class.getName(), persistentField.getName(), mappedBy);
        String targetElementLoaded = String.format("%s.isPropertyInitialized(target, \"%s\")", Hibernate.class.getName(), mappedBy);
        String newAssociationLoaded = String.format("%s.isPropertyInitialized($1, \"%s\")", Hibernate.class.getName(), mappedBy);
        if (PersistentAttributesHelper.hasAnnotation(persistentField, OneToOne.class)) {
            fieldWriter.insertBefore(String.format("  if (this.%1$s != null && %2$s && $1 != null) { this.%1$s.%3$s(null); }%n", persistentField.getName(), currentAssociationLoaded, mappedBySetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %s && $1.%s() != this) { $1.%s(this); }%n", newAssociationLoaded, mappedByGetterName, mappedBySetterName));
        }
        if (PersistentAttributesHelper.hasAnnotation(persistentField, OneToMany.class)) {
            boolean isMap = PersistentAttributesHelper.isAssignable(persistentField.getType(), Map.class.getName());
            String toArrayMethod = isMap ? "values().toArray()" : "toArray()";
            fieldWriter.insertBefore(String.format("  if (this.%3$s != null && %1$s) {%n    Object[] array = this.%3$s.%2$s;%n    for (int i = 0; i < array.length; i++) {%n      %4$s target = (%4$s) array[i];%n      if ($1 == null || !$1.contains(target)) { target.%5$s(null); }%n    }%n  }%n", currentAssociationLoaded, toArrayMethod, persistentField.getName(), targetEntity.getName(), mappedBySetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %1$s) {%n    Object[] array = $1.%2$s;%n    for (int i = 0; i < array.length; i++) {%n      %4$s target = (%4$s) array[i];%n      if (%3$s && target.%5$s() != this) { target.%6$s(this); }%n    }%n  }%n", newAssociationLoaded, toArrayMethod, targetElementLoaded, targetEntity.getName(), mappedByGetterName, mappedBySetterName));
        }
        if (PersistentAttributesHelper.hasAnnotation(persistentField, ManyToOne.class)) {
            fieldWriter.insertBefore(String.format("  if (this.%2$s != null && %1$s && this.%2$s.%3$s() != null) { this.%2$s.%3$s().remove(this); }%n", currentAssociationLoaded, persistentField.getName(), mappedByGetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %s) {%n    java.util.Collection c = $1.%s();%n    if (c != null && !c.contains(this)) { c.add(this); }%n  }%n", newAssociationLoaded, mappedByGetterName));
        }
        if (PersistentAttributesHelper.hasAnnotation(persistentField, ManyToMany.class)) {
            if (PersistentAttributesHelper.isAssignable(persistentField.getType(), Map.class.getName()) || PersistentAttributesHelper.isAssignable(targetEntity.getField(mappedBy).getType(), Map.class.getName())) {
                log.infof("Bi-directional association for field [%s#%s] not managed: @ManyToMany in java.util.Map attribute not supported ", managedCtClass.getName(), persistentField.getName());
                return;
            }
            fieldWriter.insertBefore(String.format("  if (this.%2$s != null && %1$s) {%n    Object[] array = this.%2$s.toArray();%n    for (int i = 0; i < array.length; i++) {%n      %3$s target = (%3$s) array[i];%n      if ($1 == null || !$1.contains(target)) { target.%4$s().remove(this); }%n    }%n  }%n", currentAssociationLoaded, persistentField.getName(), targetEntity.getName(), mappedByGetterName));
            fieldWriter.insertAfter(String.format("  if ($1 != null && %s) {%n    Object[] array = $1.toArray();%n    for (int i = 0; i < array.length; i++) {%n      %s target = (%s) array[i];%n\t   if (%s) {%n        java.util.Collection c = target.%s();%n        if (c != this && c != null) { c.add(this); }%n      }%n    }%n  }%n", newAssociationLoaded, targetEntity.getName(), targetEntity.getName(), targetElementLoaded, mappedByGetterName));
        }
        if (tmpTargetMethods) {
            targetEntity.removeMethod(getter);
            targetEntity.removeMethod(setter);
        }
    }

    private void handleCompositeField(CtClass managedCtClass, CtField persistentField, CtMethod fieldWriter) throws NotFoundException, CannotCompileException {
        if (!this.enhancementContext.isCompositeClass(persistentField.getType()) || !PersistentAttributesHelper.hasAnnotation(persistentField, Embedded.class)) {
            return;
        }
        managedCtClass.addInterface(this.classPool.get(CompositeOwner.class.getName()));
        if (this.enhancementContext.isCompositeClass(managedCtClass)) {
            MethodWriter.write(managedCtClass, "public void %1$s(String name) {%n  if (%2$s != null) { %2$s.callOwner(\".\" + name); }%n}", "$$_hibernate_trackChange", "$$_hibernate_compositeOwners");
        }
        fieldWriter.insertBefore(String.format("if (%1$s != null) { ((%2$s) %1$s).%3$s(\"%1$s\"); }%n", persistentField.getName(), CompositeTracker.class.getName(), "$$_hibernate_clearOwner"));
        fieldWriter.insertAfter(String.format("((%2$s) %1$s).%4$s(\"%1$s\", (%3$s) this);%n%5$s(\"%1$s\");", persistentField.getName(), CompositeTracker.class.getName(), CompositeOwner.class.getName(), "$$_hibernate_setOwner", "$$_hibernate_trackChange"));
    }

    protected void enhanceAttributesAccess(CtClass managedCtClass, IdentityHashMap<String, PersistentAttributeAccessMethods> attributeDescriptorMap) {
        ConstPool constPool = managedCtClass.getClassFile().getConstPool();
        for (Object oMethod : managedCtClass.getClassFile().getMethods()) {
            MethodInfo methodInfo = (MethodInfo)oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith("$$_hibernate_") || methodInfo.getCodeAttribute() == null) continue;
            try {
                CodeIterator itr = methodInfo.getCodeAttribute().iterator();
                while (itr.hasNext()) {
                    int methodIndex;
                    String fieldName;
                    PersistentAttributeAccessMethods attributeMethods;
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180 || !managedCtClass.getName().equals(constPool.getFieldrefClassName(itr.u16bitAt(index + 1))) || (attributeMethods = attributeDescriptorMap.get(fieldName = constPool.getFieldrefName(itr.u16bitAt(index + 1)))) == null) continue;
                    log.debugf("Transforming access to field [%s] from method [%s]", fieldName, methodName);
                    if (op == 180) {
                        methodIndex = MethodWriter.addMethod(constPool, attributeMethods.getReader());
                        itr.writeByte(183, index);
                        itr.write16bit(methodIndex, index + 1);
                        continue;
                    }
                    methodIndex = MethodWriter.addMethod(constPool, attributeMethods.getWriter());
                    itr.writeByte(183, index);
                    itr.write16bit(methodIndex, index + 1);
                }
                methodInfo.getCodeAttribute().setAttribute(MapMaker.make((ClassPool)this.classPool, (MethodInfo)methodInfo));
            }
            catch (BadBytecode bb) {
                String msg = String.format("Unable to perform field access transformation in method [%s]", methodName);
                throw new EnhancementException(msg, bb);
            }
        }
    }

    public void extendedEnhancement(CtClass aCtClass) {
        ConstPool constPool = aCtClass.getClassFile().getConstPool();
        for (Object oMethod : aCtClass.getClassFile().getMethods()) {
            MethodInfo methodInfo = (MethodInfo)oMethod;
            String methodName = methodInfo.getName();
            if (methodName.startsWith("$$_hibernate_") || methodInfo.getCodeAttribute() == null) continue;
            try {
                CodeIterator itr = methodInfo.getCodeAttribute().iterator();
                while (itr.hasNext()) {
                    int index = itr.next();
                    int op = itr.byteAt(index);
                    if (op != 181 && op != 180) continue;
                    String fieldName = constPool.getFieldrefName(itr.u16bitAt(index + 1));
                    String fieldClassName = constPool.getClassInfo(constPool.getFieldrefClass(itr.u16bitAt(index + 1)));
                    CtClass targetCtClass = this.classPool.getCtClass(fieldClassName);
                    if (!this.enhancementContext.isEntityClass(targetCtClass) && !this.enhancementContext.isCompositeClass(targetCtClass) || targetCtClass == aCtClass || !this.enhancementContext.isPersistentField(targetCtClass.getField(fieldName)) || PersistentAttributesHelper.hasAnnotation(targetCtClass, fieldName, Id.class) || "this$0".equals(fieldName)) continue;
                    log.debugf("Extended enhancement: Transforming access to field [%s.%s] from method [%s#%s]", new Object[]{fieldClassName, fieldName, aCtClass.getName(), methodName});
                    if (op == 180) {
                        int fieldReaderMethodIndex = constPool.addMethodrefInfo(constPool.addClassInfo(fieldClassName), "$$_hibernate_read_" + fieldName, "()" + constPool.getFieldrefType(itr.u16bitAt(index + 1)));
                        itr.writeByte(182, index);
                        itr.write16bit(fieldReaderMethodIndex, index + 1);
                        continue;
                    }
                    int fieldWriterMethodIndex = constPool.addMethodrefInfo(constPool.addClassInfo(fieldClassName), "$$_hibernate_write_" + fieldName, "(" + constPool.getFieldrefType(itr.u16bitAt(index + 1)) + ")V");
                    itr.writeByte(182, index);
                    itr.write16bit(fieldWriterMethodIndex, index + 1);
                }
                methodInfo.getCodeAttribute().setAttribute(MapMaker.make((ClassPool)this.classPool, (MethodInfo)methodInfo));
            }
            catch (BadBytecode bb) {
                String msg = String.format("Unable to perform extended enhancement in method [%s]", methodName);
                throw new EnhancementException(msg, bb);
            }
            catch (NotFoundException nfe) {
                String msg = String.format("Unable to perform extended enhancement in method [%s]", methodName);
                throw new EnhancementException(msg, nfe);
            }
        }
    }

    private static class PersistentAttributeAccessMethods {
        private final CtMethod reader;
        private final CtMethod writer;

        private PersistentAttributeAccessMethods(CtMethod reader, CtMethod writer) {
            this.reader = reader;
            this.writer = writer;
        }

        private CtMethod getReader() {
            return this.reader;
        }

        private CtMethod getWriter() {
            return this.writer;
        }
    }
}

