/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.schema.internal;

import java.util.Map;
import org.hibernate.dialect.Dialect;
import org.hibernate.engine.jdbc.spi.JdbcServices;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.service.spi.ServiceRegistryAwareService;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.tool.schema.internal.SchemaCreatorImpl;
import org.hibernate.tool.schema.internal.SchemaDropperImpl;
import org.hibernate.tool.schema.internal.SchemaMigratorImpl;
import org.hibernate.tool.schema.internal.SchemaValidatorImpl;
import org.hibernate.tool.schema.spi.SchemaCreator;
import org.hibernate.tool.schema.spi.SchemaDropper;
import org.hibernate.tool.schema.spi.SchemaManagementTool;
import org.hibernate.tool.schema.spi.SchemaMigrator;
import org.hibernate.tool.schema.spi.SchemaValidator;

public class HibernateSchemaManagementTool
implements SchemaManagementTool,
ServiceRegistryAwareService {
    private ServiceRegistry serviceRegistry;

    @Override
    public SchemaCreator getSchemaCreator(Map options) {
        return new SchemaCreatorImpl();
    }

    @Override
    public SchemaDropper getSchemaDropper(Map options) {
        return new SchemaDropperImpl();
    }

    @Override
    public SchemaMigrator getSchemaMigrator(Map options) {
        return new SchemaMigratorImpl();
    }

    @Override
    public SchemaValidator getSchemaValidator(Map options) {
        Dialect dialect = this.serviceRegistry.getService(JdbcServices.class).getDialect();
        return new SchemaValidatorImpl(dialect);
    }

    @Override
    public void injectServices(ServiceRegistryImplementor serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }
}

