/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.boot.model.source.internal.hbm;

import org.hibernate.boot.jaxb.hbm.spi.JaxbHbmColumnType;
import org.hibernate.boot.model.TruthValue;
import org.hibernate.boot.model.source.internal.hbm.AbstractHbmSourceNode;
import org.hibernate.boot.model.source.internal.hbm.Helper;
import org.hibernate.boot.model.source.internal.hbm.MappingDocument;
import org.hibernate.boot.model.source.spi.ColumnSource;
import org.hibernate.boot.model.source.spi.JdbcDataType;
import org.hibernate.boot.model.source.spi.RelationalValueSource;
import org.hibernate.boot.model.source.spi.SizeSource;

class ColumnSourceImpl
extends AbstractHbmSourceNode
implements ColumnSource {
    private final String tableName;
    private final JaxbHbmColumnType columnElement;
    private final TruthValue nullable;

    ColumnSourceImpl(MappingDocument mappingDocument, String tableName, JaxbHbmColumnType columnElement) {
        this(mappingDocument, tableName, columnElement, ColumnSourceImpl.interpretNotNullToNullability(columnElement.isNotNull()));
    }

    private static TruthValue interpretNotNullToNullability(Boolean notNull) {
        if (notNull == null) {
            return TruthValue.UNKNOWN;
        }
        return notNull != false ? TruthValue.FALSE : TruthValue.TRUE;
    }

    ColumnSourceImpl(MappingDocument mappingDocument, String tableName, JaxbHbmColumnType columnElement, TruthValue nullable) {
        super(mappingDocument);
        this.tableName = tableName;
        this.columnElement = columnElement;
        this.nullable = nullable;
    }

    @Override
    public RelationalValueSource.Nature getNature() {
        return RelationalValueSource.Nature.COLUMN;
    }

    @Override
    public String getName() {
        return this.columnElement.getName();
    }

    @Override
    public TruthValue isNullable() {
        return this.nullable;
    }

    @Override
    public String getDefaultValue() {
        return this.columnElement.getDefault();
    }

    @Override
    public String getSqlType() {
        return this.columnElement.getSqlType();
    }

    @Override
    public JdbcDataType getDatatype() {
        return null;
    }

    @Override
    public SizeSource getSizeSource() {
        return Helper.interpretSizeSource(this.columnElement.getLength(), this.columnElement.getScale(), this.columnElement.getPrecision());
    }

    @Override
    public String getReadFragment() {
        return this.columnElement.getRead();
    }

    @Override
    public String getWriteFragment() {
        return this.columnElement.getWrite();
    }

    @Override
    public boolean isUnique() {
        return this.columnElement.isUnique() != null && this.columnElement.isUnique() != false;
    }

    @Override
    public String getCheckCondition() {
        return this.columnElement.getCheck();
    }

    @Override
    public String getComment() {
        return this.columnElement.getComment();
    }

    @Override
    public String getContainingTableName() {
        return this.tableName;
    }
}

