/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.jta.platform.internal;

import java.util.Map;
import org.hibernate.boot.registry.classloading.spi.ClassLoaderService;
import org.hibernate.boot.registry.classloading.spi.ClassLoadingException;
import org.hibernate.engine.transaction.jta.platform.internal.BitronixJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JOTMJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.JOnASJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.NoJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.internal.WebSphereJtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatform;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformProvider;
import org.hibernate.engine.transaction.jta.platform.spi.JtaPlatformResolver;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.jboss.logging.Logger;

public class StandardJtaPlatformResolver
implements JtaPlatformResolver {
    public static final StandardJtaPlatformResolver INSTANCE = new StandardJtaPlatformResolver();
    private static final Logger log = Logger.getLogger(StandardJtaPlatformResolver.class);

    @Override
    public JtaPlatform resolveJtaPlatform(Map configurationValues, ServiceRegistryImplementor registry) {
        ClassLoaderService classLoaderService = registry.getService(ClassLoaderService.class);
        for (JtaPlatformProvider provider : classLoaderService.loadJavaServices(JtaPlatformProvider.class)) {
            JtaPlatform providedPlatform = provider.getProvidedJtaPlatform();
            if (providedPlatform == null) continue;
            return providedPlatform;
        }
        try {
            classLoaderService.classForName("com.arjuna.ats.jta.TransactionManager");
            classLoaderService.classForName("com.arjuna.ats.jta.UserTransaction");
            return new JBossStandAloneJtaPlatform();
        }
        catch (ClassLoadingException classLoadingException) {
            try {
                classLoaderService.classForName("bitronix.tm.TransactionManagerServices");
                return new BitronixJtaPlatform();
            }
            catch (ClassLoadingException classLoadingException2) {
                try {
                    classLoaderService.classForName("org.objectweb.jonas_tm.Current");
                    return new JOnASJtaPlatform();
                }
                catch (ClassLoadingException classLoadingException3) {
                    try {
                        classLoaderService.classForName("org.objectweb.jotm.Current");
                        return new JOTMJtaPlatform();
                    }
                    catch (ClassLoadingException classLoadingException4) {
                        for (WebSphereJtaPlatform.WebSphereEnvironment webSphereEnvironment : WebSphereJtaPlatform.WebSphereEnvironment.values()) {
                            try {
                                Class accessClass = classLoaderService.classForName(webSphereEnvironment.getTmAccessClassName());
                                return new WebSphereJtaPlatform(accessClass, webSphereEnvironment);
                            }
                            catch (ClassLoadingException classLoadingException5) {
                            }
                        }
                        log.debugf("Could not resolve JtaPlatform, using default [%s]", (Object)NoJtaPlatform.class.getName());
                        return NoJtaPlatform.INSTANCE;
                    }
                }
            }
        }
    }
}

