/*
 * Hibernate, Relational Persistence for Idiomatic Java
 *
 * Copyright (c) 2013, Red Hat Inc. or third-party contributors as
 * indicated by the @author tags or express copyright attribution
 * statements applied by the authors.  All third-party contributions are
 * distributed under license by Red Hat Inc.
 *
 * This copyrighted material is made available to anyone wishing to use, modify,
 * copy, or redistribute it subject to the terms and conditions of the GNU
 * Lesser General Public License, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
 * or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License
 * for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this distribution; if not, write to:
 * Free Software Foundation, Inc.
 * 51 Franklin Street, Fifth Floor
 * Boston, MA  02110-1301  USA
 */
package org.hibernate.hql.internal.ast;

import java.io.Reader;

import org.hibernate.QueryException;
import org.hibernate.hql.internal.antlr.HqlBaseLexer;

import antlr.Token;

/**
 * Custom lexer for the HQL grammar.  Extends the base lexer generated by ANTLR
 * in order to keep the grammar source file clean.
 */
class HqlLexer extends HqlBaseLexer {
	private boolean possibleID;

	public HqlLexer(Reader in) {
		super( in );
	}

	@Override
	public void setTokenObjectClass(String cl) {
		this.tokenObjectClass = HqlToken.class;
	}

	@Override
	protected void setPossibleID(boolean possibleID) {
		this.possibleID = possibleID;
	}

	@Override
	protected Token makeToken(int i) {
		HqlToken token = (HqlToken) super.makeToken( i );
		token.setPossibleID( possibleID );
		possibleID = false;
		return token;
	}

	@Override
	public void panic() {
		//overriden to avoid System.exit
		panic( "CharScanner: panic" );
	}

	@Override
	public void panic(String s) {
		//overriden to avoid System.exit
		throw new QueryException( s );
	}
}
