/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.bytecode.buildtime.spi;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.hibernate.bytecode.buildtime.spi.ClassFilter;

public class BasicClassFilter
implements ClassFilter {
    private final String[] includedPackages;
    private final Set<String> includedClassNames = new HashSet<String>();
    private final boolean isAllEmpty;

    public BasicClassFilter() {
        this(null, null);
    }

    public BasicClassFilter(String[] includedPackages, String[] includedClassNames) {
        this.includedPackages = includedPackages;
        if (includedClassNames != null) {
            this.includedClassNames.addAll(Arrays.asList(includedClassNames));
        }
        this.isAllEmpty = (this.includedPackages == null || this.includedPackages.length == 0) && this.includedClassNames.isEmpty();
    }

    @Override
    public boolean shouldInstrumentClass(String className) {
        return this.isAllEmpty || this.includedClassNames.contains(className) || this.isInIncludedPackage(className);
    }

    private boolean isInIncludedPackage(String className) {
        if (this.includedPackages != null) {
            for (String includedPackage : this.includedPackages) {
                if (!className.startsWith(includedPackage)) continue;
                return true;
            }
        }
        return false;
    }
}

