/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.spi;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.PropertyValueException;
import org.hibernate.action.internal.AbstractEntityInsertAction;
import org.hibernate.action.internal.BulkOperationCleanupAction;
import org.hibernate.action.internal.CollectionRecreateAction;
import org.hibernate.action.internal.CollectionRemoveAction;
import org.hibernate.action.internal.CollectionUpdateAction;
import org.hibernate.action.internal.EntityDeleteAction;
import org.hibernate.action.internal.EntityIdentityInsertAction;
import org.hibernate.action.internal.EntityInsertAction;
import org.hibernate.action.internal.EntityUpdateAction;
import org.hibernate.action.internal.OrphanRemovalAction;
import org.hibernate.action.internal.QueuedOperationCollectionAction;
import org.hibernate.action.internal.UnresolvedEntityInsertActions;
import org.hibernate.action.spi.AfterTransactionCompletionProcess;
import org.hibernate.action.spi.BeforeTransactionCompletionProcess;
import org.hibernate.action.spi.Executable;
import org.hibernate.cache.CacheException;
import org.hibernate.engine.internal.NonNullableTransientDependencies;
import org.hibernate.engine.spi.EntityEntry;
import org.hibernate.engine.spi.ExecutableList;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.internal.CoreLogging;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.type.Type;

public class ActionQueue {
    private static final CoreMessageLogger LOG = CoreLogging.messageLogger(ActionQueue.class);
    private SessionImplementor session;
    private UnresolvedEntityInsertActions unresolvedInsertions;
    private final ExecutableList<AbstractEntityInsertAction> insertions;
    private final ExecutableList<EntityDeleteAction> deletions;
    private final ExecutableList<EntityUpdateAction> updates;
    private final ExecutableList<CollectionRecreateAction> collectionCreations;
    private final ExecutableList<CollectionUpdateAction> collectionUpdates;
    private final ExecutableList<QueuedOperationCollectionAction> collectionQueuedOps;
    private final ExecutableList<CollectionRemoveAction> collectionRemovals;
    private final ExecutableList<OrphanRemovalAction> orphanRemovals;
    private final List<ExecutableList<?>> executableLists;
    private final AfterTransactionCompletionProcessQueue afterTransactionProcesses;
    private final BeforeTransactionCompletionProcessQueue beforeTransactionProcesses;

    public ActionQueue(SessionImplementor session) {
        this.session = session;
        this.unresolvedInsertions = new UnresolvedEntityInsertActions();
        this.insertions = new ExecutableList<AbstractEntityInsertAction>(new InsertActionSorter());
        this.deletions = new ExecutableList();
        this.updates = new ExecutableList();
        this.collectionCreations = new ExecutableList();
        this.collectionRemovals = new ExecutableList();
        this.collectionUpdates = new ExecutableList();
        this.collectionQueuedOps = new ExecutableList();
        this.orphanRemovals = new ExecutableList();
        ArrayList tmp = new ArrayList(7);
        tmp.add(this.orphanRemovals);
        tmp.add(this.insertions);
        tmp.add(this.updates);
        tmp.add(this.collectionQueuedOps);
        tmp.add(this.collectionRemovals);
        tmp.add(this.collectionUpdates);
        tmp.add(this.collectionCreations);
        tmp.add(this.deletions);
        this.executableLists = Collections.unmodifiableList(tmp);
        this.afterTransactionProcesses = new AfterTransactionCompletionProcessQueue(session);
        this.beforeTransactionProcesses = new BeforeTransactionCompletionProcessQueue(session);
    }

    public void clear() {
        for (ExecutableList<?> l : this.executableLists) {
            l.clear();
        }
        this.unresolvedInsertions.clear();
    }

    public void addAction(EntityInsertAction action) {
        LOG.tracev("Adding an EntityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    private void addInsertAction(AbstractEntityInsertAction insert) {
        NonNullableTransientDependencies nonNullableTransientDependencies;
        if (insert.isEarlyInsert()) {
            LOG.tracev("Executing inserts before finding non-nullable transient entities for early insert: [{0}]", insert);
            this.executeInserts();
        }
        if ((nonNullableTransientDependencies = insert.findNonNullableTransientEntities()) == null) {
            LOG.tracev("Adding insert with no non-nullable, transient entities: [{0}]", insert);
            this.addResolvedEntityInsertAction(insert);
        } else {
            if (LOG.isTraceEnabled()) {
                LOG.tracev("Adding insert with non-nullable, transient entities; insert=[{0}], dependencies=[{1}]", insert, nonNullableTransientDependencies.toLoggableString(insert.getSession()));
            }
            this.unresolvedInsertions.addUnresolvedEntityInsertAction(insert, nonNullableTransientDependencies);
        }
    }

    private void addResolvedEntityInsertAction(AbstractEntityInsertAction insert) {
        if (insert.isEarlyInsert()) {
            LOG.trace("Executing insertions before resolved early-insert");
            this.executeInserts();
            LOG.debug("Executing identity-insert immediately");
            this.execute(insert);
        } else {
            LOG.trace("Adding resolved non-early insert action.");
            this.insertions.add(insert);
        }
        insert.makeEntityManaged();
        for (AbstractEntityInsertAction resolvedAction : this.unresolvedInsertions.resolveDependentActions(insert.getInstance(), this.session)) {
            this.addResolvedEntityInsertAction(resolvedAction);
        }
    }

    public void addAction(EntityIdentityInsertAction action) {
        LOG.tracev("Adding an EntityIdentityInsertAction for [{0}] object", action.getEntityName());
        this.addInsertAction(action);
    }

    public void addAction(EntityDeleteAction action) {
        this.deletions.add(action);
    }

    public void addAction(OrphanRemovalAction action) {
        this.orphanRemovals.add(action);
    }

    public void addAction(EntityUpdateAction action) {
        this.updates.add(action);
    }

    public void addAction(CollectionRecreateAction action) {
        this.collectionCreations.add(action);
    }

    public void addAction(CollectionRemoveAction action) {
        this.collectionRemovals.add(action);
    }

    public void addAction(CollectionUpdateAction action) {
        this.collectionUpdates.add(action);
    }

    public void addAction(QueuedOperationCollectionAction action) {
        this.collectionQueuedOps.add(action);
    }

    public void addAction(BulkOperationCleanupAction action) {
        this.registerCleanupActions(action);
    }

    private void registerCleanupActions(Executable executable) {
        this.beforeTransactionProcesses.register(executable.getBeforeTransactionCompletionProcess());
        if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
            this.invalidateSpaces(executable.getPropertySpaces());
        }
        this.afterTransactionProcesses.register(executable.getAfterTransactionCompletionProcess());
    }

    public boolean hasUnresolvedEntityInsertActions() {
        return !this.unresolvedInsertions.isEmpty();
    }

    public void checkNoUnresolvedActionsAfterOperation() throws PropertyValueException {
        this.unresolvedInsertions.checkNoUnresolvedActionsAfterOperation();
    }

    public void registerProcess(AfterTransactionCompletionProcess process) {
        this.afterTransactionProcesses.register(process);
    }

    public void registerProcess(BeforeTransactionCompletionProcess process) {
        this.beforeTransactionProcesses.register(process);
    }

    public void executeInserts() throws HibernateException {
        this.executeActions(this.insertions);
    }

    public void executeActions() throws HibernateException {
        if (!this.unresolvedInsertions.isEmpty()) {
            throw new IllegalStateException("About to execute actions, but there are unresolved entity insert actions.");
        }
        for (ExecutableList<?> l : this.executableLists) {
            this.executeActions(l);
        }
    }

    public void prepareActions() throws HibernateException {
        this.prepareActions(this.collectionRemovals);
        this.prepareActions(this.collectionUpdates);
        this.prepareActions(this.collectionCreations);
        this.prepareActions(this.collectionQueuedOps);
    }

    private void prepareActions(ExecutableList<?> queue) throws HibernateException {
        for (Executable executable : queue) {
            executable.beforeExecutions();
        }
    }

    public void afterTransactionCompletion(boolean success) {
        this.afterTransactionProcesses.afterTransactionCompletion(success);
    }

    public void beforeTransactionCompletion() {
        this.beforeTransactionProcesses.beforeTransactionCompletion();
    }

    public boolean areInsertionsOrDeletionsQueued() {
        return !this.insertions.isEmpty() || !this.unresolvedInsertions.isEmpty() || !this.deletions.isEmpty() || !this.orphanRemovals.isEmpty();
    }

    public boolean areTablesToBeUpdated(Set tables) {
        if (tables.isEmpty()) {
            return false;
        }
        for (ExecutableList<?> l : this.executableLists) {
            if (!ActionQueue.areTablesToBeUpdated(l, tables)) continue;
            return true;
        }
        return ActionQueue.areTablesToBeUpdated(this.unresolvedInsertions, tables);
    }

    private static boolean areTablesToBeUpdated(ExecutableList<?> actions, Set tableSpaces) {
        if (actions.isEmpty()) {
            return false;
        }
        for (Serializable actionSpace : actions.getQuerySpaces()) {
            if (!tableSpaces.contains(actionSpace)) continue;
            LOG.debugf("Changes must be flushed to space: %s", actionSpace);
            return true;
        }
        return false;
    }

    private static boolean areTablesToBeUpdated(UnresolvedEntityInsertActions actions, Set tableSpaces) {
        for (Executable executable : actions.getDependentEntityInsertActions()) {
            Serializable[] spaces;
            for (Serializable space : spaces = executable.getPropertySpaces()) {
                if (!tableSpaces.contains(space)) continue;
                LOG.debugf("Changes must be flushed to space: %s", space);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <E extends Executable & Comparable<?>> void executeActions(ExecutableList<E> list) throws HibernateException {
        try {
            for (Executable e : list) {
                try {
                    e.execute();
                }
                finally {
                    this.beforeTransactionProcesses.register(e.getBeforeTransactionCompletionProcess());
                    this.afterTransactionProcesses.register(e.getAfterTransactionCompletionProcess());
                }
            }
        }
        finally {
            if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
                Set<Serializable> propertySpaces = list.getQuerySpaces();
                this.invalidateSpaces(propertySpaces.toArray(new Serializable[propertySpaces.size()]));
            }
        }
        list.clear();
        this.session.getTransactionCoordinator().getJdbcCoordinator().executeBatch();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <E extends Executable & Comparable<?>> void execute(E executable) {
        try {
            executable.execute();
        }
        finally {
            this.registerCleanupActions(executable);
        }
    }

    private void invalidateSpaces(Serializable ... spaces) {
        if (spaces != null && spaces.length > 0) {
            for (Serializable s : spaces) {
                this.afterTransactionProcesses.addSpaceToInvalidate((String)((Object)s));
            }
            this.session.getFactory().getUpdateTimestampsCache().preInvalidate(spaces, this.session);
        }
    }

    public String toString() {
        return "ActionQueue[insertions=" + this.insertions + " updates=" + this.updates + " deletions=" + this.deletions + " orphanRemovals=" + this.orphanRemovals + " collectionCreations=" + this.collectionCreations + " collectionRemovals=" + this.collectionRemovals + " collectionUpdates=" + this.collectionUpdates + " collectionQueuedOps=" + this.collectionQueuedOps + " unresolvedInsertDependencies=" + this.unresolvedInsertions + "]";
    }

    public int numberOfCollectionRemovals() {
        return this.collectionRemovals.size();
    }

    public int numberOfCollectionUpdates() {
        return this.collectionUpdates.size();
    }

    public int numberOfCollectionCreations() {
        return this.collectionCreations.size();
    }

    public int numberOfDeletions() {
        return this.deletions.size() + this.orphanRemovals.size();
    }

    public int numberOfUpdates() {
        return this.updates.size();
    }

    public int numberOfInsertions() {
        return this.insertions.size();
    }

    public void sortCollectionActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            this.collectionCreations.sort();
            this.collectionUpdates.sort();
            this.collectionQueuedOps.sort();
            this.collectionRemovals.sort();
        }
    }

    public void sortActions() {
        if (this.session.getFactory().getSettings().isOrderUpdatesEnabled()) {
            this.updates.sort();
        }
        if (this.session.getFactory().getSettings().isOrderInsertsEnabled()) {
            this.insertions.sort();
        }
    }

    public void clearFromFlushNeededCheck(int previousCollectionRemovalSize) {
        this.collectionCreations.clear();
        this.collectionUpdates.clear();
        this.collectionQueuedOps.clear();
        this.updates.clear();
        if (this.collectionRemovals.size() > previousCollectionRemovalSize) {
            this.collectionRemovals.removeLastN(this.collectionRemovals.size() - previousCollectionRemovalSize);
        }
    }

    public boolean hasAfterTransactionActions() {
        return !this.afterTransactionProcesses.processes.isEmpty();
    }

    public boolean hasBeforeTransactionActions() {
        return !this.beforeTransactionProcesses.processes.isEmpty();
    }

    public boolean hasAnyQueuedActions() {
        return !this.updates.isEmpty() || !this.insertions.isEmpty() || !this.unresolvedInsertions.isEmpty() || !this.deletions.isEmpty() || !this.collectionUpdates.isEmpty() || !this.collectionQueuedOps.isEmpty() || !this.collectionRemovals.isEmpty() || !this.collectionCreations.isEmpty();
    }

    public void unScheduleDeletion(EntityEntry entry, Object rescuedEntity) {
        EntityDeleteAction action;
        int i;
        for (i = 0; i < this.deletions.size(); ++i) {
            action = this.deletions.get(i);
            if (action.getInstance() != rescuedEntity) continue;
            this.deletions.remove(i);
            return;
        }
        for (i = 0; i < this.orphanRemovals.size(); ++i) {
            action = this.orphanRemovals.get(i);
            if (action.getInstance() != rescuedEntity) continue;
            this.orphanRemovals.remove(i);
            return;
        }
        throw new AssertionFailure("Unable to perform un-delete for instance " + entry.getEntityName());
    }

    public void serialize(ObjectOutputStream oos) throws IOException {
        LOG.trace("Serializing action-queue");
        this.unresolvedInsertions.serialize(oos);
        for (ExecutableList<?> l : this.executableLists) {
            l.writeExternal(oos);
        }
    }

    public static ActionQueue deserialize(ObjectInputStream ois, SessionImplementor session) throws IOException, ClassNotFoundException {
        LOG.trace("Deserializing action-queue");
        ActionQueue rtn = new ActionQueue(session);
        rtn.unresolvedInsertions = UnresolvedEntityInsertActions.deserialize(ois, session);
        for (ExecutableList<?> l : rtn.executableLists) {
            l.readExternal(ois);
            LOG.tracev("Deserialized [{0}] entries", l.size());
            l.afterDeserialize(session);
        }
        return rtn;
    }

    private static class InsertActionSorter
    implements ExecutableList.Sorter<AbstractEntityInsertAction> {
        public static final InsertActionSorter INSTANCE = new InsertActionSorter();
        private Map<String, Integer> latestBatches;
        private Map<Object, Integer> entityBatchNumber;
        private Map<Integer, List<AbstractEntityInsertAction>> actionBatches;

        @Override
        public void sort(List<AbstractEntityInsertAction> insertions) {
            this.latestBatches = new HashMap<String, Integer>();
            this.entityBatchNumber = new HashMap<Object, Integer>(insertions.size() + 1, 1.0f);
            this.actionBatches = new HashMap<Integer, List<AbstractEntityInsertAction>>();
            for (AbstractEntityInsertAction action : insertions) {
                Integer batchNumber;
                String entityName = action.getEntityName();
                Object currentEntity = action.getInstance();
                if (this.latestBatches.containsKey(entityName)) {
                    batchNumber = this.findBatchNumber(action, entityName);
                } else {
                    batchNumber = this.actionBatches.size();
                    this.latestBatches.put(entityName, batchNumber);
                }
                this.entityBatchNumber.put(currentEntity, batchNumber);
                this.addToBatch(batchNumber, action);
            }
            insertions.clear();
            for (int i = 0; i < this.actionBatches.size(); ++i) {
                List<AbstractEntityInsertAction> batch = this.actionBatches.get(i);
                insertions.addAll(batch);
            }
        }

        private Integer findBatchNumber(AbstractEntityInsertAction action, String entityName) {
            Integer latestBatchNumberForType = this.latestBatches.get(entityName);
            Object[] propertyValues = action.getState();
            Type[] propertyTypes = action.getPersister().getClassMetadata().getPropertyTypes();
            for (int i = 0; i < propertyValues.length; ++i) {
                Integer associationBatchNumber;
                Object value = propertyValues[i];
                Type type = propertyTypes[i];
                if (!type.isEntityType() || value == null || (associationBatchNumber = this.entityBatchNumber.get(value)) == null || associationBatchNumber.compareTo(latestBatchNumberForType) <= 0) continue;
                latestBatchNumberForType = this.actionBatches.size();
                this.latestBatches.put(entityName, latestBatchNumberForType);
                break;
            }
            return latestBatchNumberForType;
        }

        private void addToBatch(Integer batchNumber, AbstractEntityInsertAction action) {
            List<AbstractEntityInsertAction> actions = this.actionBatches.get(batchNumber);
            if (actions == null) {
                actions = new LinkedList<AbstractEntityInsertAction>();
                this.actionBatches.put(batchNumber, actions);
            }
            actions.add(action);
        }
    }

    private static class AfterTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private Set<String> querySpacesToInvalidate = new HashSet<String>();
        private Queue<AfterTransactionCompletionProcess> processes = new ConcurrentLinkedQueue<AfterTransactionCompletionProcess>();

        private AfterTransactionCompletionProcessQueue(SessionImplementor session) {
            this.session = session;
        }

        public void addSpaceToInvalidate(String space) {
            this.querySpacesToInvalidate.add(space);
        }

        public void register(AfterTransactionCompletionProcess process) {
            if (process == null) {
                return;
            }
            this.processes.add(process);
        }

        public void afterTransactionCompletion(boolean success) {
            for (AfterTransactionCompletionProcess process : this.processes) {
                try {
                    process.doAfterTransactionCompletion(success, this.session);
                }
                catch (CacheException ce) {
                    LOG.unableToReleaseCacheLock(ce);
                }
                catch (Exception e) {
                    throw new AssertionFailure("Exception releasing cache locks", e);
                }
            }
            this.processes.clear();
            if (this.session.getFactory().getSettings().isQueryCacheEnabled()) {
                this.session.getFactory().getUpdateTimestampsCache().invalidate((Serializable[])this.querySpacesToInvalidate.toArray(new String[this.querySpacesToInvalidate.size()]), this.session);
            }
            this.querySpacesToInvalidate.clear();
        }
    }

    private static class BeforeTransactionCompletionProcessQueue {
        private SessionImplementor session;
        private Queue<BeforeTransactionCompletionProcess> processes = new ConcurrentLinkedQueue<BeforeTransactionCompletionProcess>();

        private BeforeTransactionCompletionProcessQueue(SessionImplementor session) {
            this.session = session;
        }

        public void register(BeforeTransactionCompletionProcess process) {
            if (process == null) {
                return;
            }
            this.processes.add(process);
        }

        public void beforeTransactionCompletion() {
            for (BeforeTransactionCompletionProcess process : this.processes) {
                try {
                    process.doBeforeTransactionCompletion(this.session);
                }
                catch (HibernateException he) {
                    throw he;
                }
                catch (Exception e) {
                    throw new AssertionFailure("Unable to perform beforeTransactionCompletion callback", e);
                }
            }
            this.processes.clear();
        }
    }
}

