/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.hibernate.HibernateException;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.cache.spi.QueryCache;
import org.hibernate.cache.spi.Region;
import org.hibernate.cache.spi.RegionFactory;
import org.hibernate.cache.spi.UpdateTimestampsCache;
import org.hibernate.cfg.Settings;
import org.hibernate.engine.spi.CacheImplementor;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.collections.CollectionHelper;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.pretty.MessageHelper;
import org.jboss.logging.Logger;

public class CacheImpl
implements CacheImplementor {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)CacheImpl.class.getName());
    private final SessionFactoryImplementor sessionFactory;
    private final Settings settings;
    private final transient QueryCache queryCache;
    private final transient RegionFactory regionFactory;
    private final transient UpdateTimestampsCache updateTimestampsCache;
    private final transient ConcurrentMap<String, QueryCache> queryCaches;
    private final transient ConcurrentMap<String, Region> allCacheRegions = new ConcurrentHashMap<String, Region>();

    public CacheImpl(SessionFactoryImplementor sessionFactory) {
        this.sessionFactory = sessionFactory;
        this.settings = sessionFactory.getSettings();
        this.regionFactory = this.settings.getRegionFactory();
        this.regionFactory.start(this.settings, sessionFactory.getProperties());
        if (this.settings.isQueryCacheEnabled()) {
            this.updateTimestampsCache = new UpdateTimestampsCache(this.settings, sessionFactory.getProperties(), sessionFactory);
            this.queryCache = this.settings.getQueryCacheFactory().getQueryCache(null, this.updateTimestampsCache, this.settings, sessionFactory.getProperties());
            this.queryCaches = new ConcurrentHashMap<String, QueryCache>();
            this.allCacheRegions.put(this.updateTimestampsCache.getRegion().getName(), this.updateTimestampsCache.getRegion());
            this.allCacheRegions.put(this.queryCache.getRegion().getName(), this.queryCache.getRegion());
        } else {
            this.updateTimestampsCache = null;
            this.queryCache = null;
            this.queryCaches = null;
        }
    }

    @Override
    public boolean containsEntity(Class entityClass, Serializable identifier) {
        return this.containsEntity(entityClass.getName(), identifier);
    }

    @Override
    public boolean containsEntity(String entityName, Serializable identifier) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        return p.hasCache() && p.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(identifier, p));
    }

    @Override
    public void evictEntity(Class entityClass, Serializable identifier) {
        this.evictEntity(entityClass.getName(), identifier);
    }

    @Override
    public void evictEntity(String entityName, Serializable identifier) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", MessageHelper.infoString(p, identifier, this.sessionFactory));
            }
            p.getCacheAccessStrategy().evict(this.buildCacheKey(identifier, p));
        }
    }

    private CacheKey buildCacheKey(Serializable identifier, EntityPersister p) {
        return new CacheKey(identifier, p.getIdentifierType(), p.getRootEntityName(), this.sessionFactory);
    }

    @Override
    public void evictEntityRegion(Class entityClass) {
        this.evictEntityRegion(entityClass.getName());
    }

    @Override
    public void evictEntityRegion(String entityName) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", p.getEntityName());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictEntityRegions() {
        for (String s : this.sessionFactory.getEntityPersisters().keySet()) {
            this.evictEntityRegion(s);
        }
    }

    @Override
    public void evictNaturalIdRegion(Class entityClass) {
        this.evictNaturalIdRegion(entityClass.getName());
    }

    @Override
    public void evictNaturalIdRegion(String entityName) {
        EntityPersister p = this.sessionFactory.getEntityPersister(entityName);
        if (p.hasNaturalIdCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting natural-id cache: %s", p.getEntityName());
            }
            p.getNaturalIdCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictNaturalIdRegions() {
        for (String s : this.sessionFactory.getEntityPersisters().keySet()) {
            this.evictNaturalIdRegion(s);
        }
    }

    @Override
    public boolean containsCollection(String role, Serializable ownerIdentifier) {
        CollectionPersister p = this.sessionFactory.getCollectionPersister(role);
        return p.hasCache() && p.getCacheAccessStrategy().getRegion().contains(this.buildCacheKey(ownerIdentifier, p));
    }

    @Override
    public void evictCollection(String role, Serializable ownerIdentifier) {
        CollectionPersister p = this.sessionFactory.getCollectionPersister(role);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", MessageHelper.collectionInfoString(p, ownerIdentifier, this.sessionFactory));
            }
            CacheKey cacheKey = this.buildCacheKey(ownerIdentifier, p);
            p.getCacheAccessStrategy().evict(cacheKey);
        }
    }

    private CacheKey buildCacheKey(Serializable ownerIdentifier, CollectionPersister p) {
        return new CacheKey(ownerIdentifier, p.getKeyType(), p.getRole(), this.sessionFactory);
    }

    @Override
    public void evictCollectionRegion(String role) {
        CollectionPersister p = this.sessionFactory.getCollectionPersister(role);
        if (p.hasCache()) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting second-level cache: %s", p.getRole());
            }
            p.getCacheAccessStrategy().evictAll();
        }
    }

    @Override
    public void evictCollectionRegions() {
        for (String s : this.sessionFactory.getCollectionPersisters().keySet()) {
            this.evictCollectionRegion(s);
        }
    }

    @Override
    public boolean containsQuery(String regionName) {
        return this.queryCaches.containsKey(regionName);
    }

    @Override
    public void evictDefaultQueryRegion() {
        if (this.sessionFactory.getSettings().isQueryCacheEnabled()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Evicting default query region cache.");
            }
            this.sessionFactory.getQueryCache().clear();
        }
    }

    @Override
    public void evictQueryRegion(String regionName) {
        QueryCache namedQueryCache;
        if (regionName == null) {
            throw new NullPointerException("Region-name cannot be null (use Cache#evictDefaultQueryRegion to evict the default query cache)");
        }
        if (this.sessionFactory.getSettings().isQueryCacheEnabled() && (namedQueryCache = (QueryCache)this.queryCaches.get(regionName)) != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debugf("Evicting query cache, region: %s", regionName);
            }
            namedQueryCache.clear();
        }
    }

    @Override
    public void evictQueryRegions() {
        this.evictDefaultQueryRegion();
        if (CollectionHelper.isEmpty(this.queryCaches)) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Evicting cache of all query regions.");
        }
        for (QueryCache queryCache : this.queryCaches.values()) {
            queryCache.clear();
        }
    }

    @Override
    public void close() {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.destroy();
            for (QueryCache cache : this.queryCaches.values()) {
                cache.destroy();
            }
            this.updateTimestampsCache.destroy();
        }
        this.regionFactory.stop();
    }

    @Override
    public QueryCache getQueryCache() {
        return this.queryCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryCache getQueryCache(String regionName) throws HibernateException {
        if (regionName == null) {
            return this.getQueryCache();
        }
        if (!this.settings.isQueryCacheEnabled()) {
            return null;
        }
        QueryCache currentQueryCache = (QueryCache)this.queryCaches.get(regionName);
        if (currentQueryCache == null) {
            ConcurrentMap<String, Region> concurrentMap = this.allCacheRegions;
            synchronized (concurrentMap) {
                currentQueryCache = (QueryCache)this.queryCaches.get(regionName);
                if (currentQueryCache != null) {
                    return currentQueryCache;
                }
                currentQueryCache = this.settings.getQueryCacheFactory().getQueryCache(regionName, this.updateTimestampsCache, this.settings, this.sessionFactory.getProperties());
                this.queryCaches.put(regionName, currentQueryCache);
                this.allCacheRegions.put(currentQueryCache.getRegion().getName(), currentQueryCache.getRegion());
            }
        }
        return currentQueryCache;
    }

    @Override
    public void addCacheRegion(String name, Region region) {
        this.allCacheRegions.put(name, region);
    }

    @Override
    public UpdateTimestampsCache getUpdateTimestampsCache() {
        return this.updateTimestampsCache;
    }

    @Override
    public void evictQueries() throws HibernateException {
        if (this.settings.isQueryCacheEnabled()) {
            this.queryCache.clear();
        }
    }

    @Override
    public Region getSecondLevelCacheRegion(String regionName) {
        return (Region)this.allCacheRegions.get(regionName);
    }

    @Override
    public Region getNaturalIdCacheRegion(String regionName) {
        return (Region)this.allCacheRegions.get(regionName);
    }

    @Override
    public Map<String, Region> getAllSecondLevelCacheRegions() {
        return new HashMap<String, Region>(this.allCacheRegions);
    }

    @Override
    public RegionFactory getRegionFactory() {
        return this.regionFactory;
    }
}

