/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.List;
import java.util.UUID;
import org.hibernate.HibernateException;
import org.hibernate.MappingException;
import org.hibernate.MultiTenancyStrategy;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.ScrollableResults;
import org.hibernate.SessionEventListener;
import org.hibernate.SessionException;
import org.hibernate.SharedSessionContract;
import org.hibernate.cache.internal.TenantAwareCacheKey;
import org.hibernate.cache.spi.CacheKey;
import org.hibernate.engine.jdbc.LobCreationContext;
import org.hibernate.engine.jdbc.spi.JdbcConnectionAccess;
import org.hibernate.engine.query.spi.HQLQueryPlan;
import org.hibernate.engine.query.spi.NativeSQLQueryPlan;
import org.hibernate.engine.query.spi.ParameterMetadata;
import org.hibernate.engine.query.spi.sql.NativeSQLQuerySpecification;
import org.hibernate.engine.spi.EntityKey;
import org.hibernate.engine.spi.NamedQueryDefinition;
import org.hibernate.engine.spi.NamedSQLQueryDefinition;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.transaction.spi.TransactionContext;
import org.hibernate.engine.transaction.spi.TransactionEnvironment;
import org.hibernate.id.uuid.StandardRandomStrategy;
import org.hibernate.internal.AbstractQueryImpl;
import org.hibernate.internal.QueryImpl;
import org.hibernate.internal.SQLQueryImpl;
import org.hibernate.internal.SessionFactoryImpl;
import org.hibernate.jdbc.WorkExecutor;
import org.hibernate.jdbc.WorkExecutorVisitable;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.service.jdbc.connections.spi.ConnectionProvider;
import org.hibernate.service.jdbc.connections.spi.MultiTenantConnectionProvider;
import org.hibernate.type.Type;

public abstract class AbstractSessionImpl
implements Serializable,
SharedSessionContract,
SessionImplementor,
TransactionContext {
    protected transient SessionFactoryImpl factory;
    private final String tenantIdentifier;
    private boolean closed = false;
    private transient JdbcConnectionAccess jdbcConnectionAccess;
    private UUID sessionIdentifier;

    protected AbstractSessionImpl(SessionFactoryImpl factory, String tenantIdentifier) {
        this.factory = factory;
        this.tenantIdentifier = tenantIdentifier;
        if (MultiTenancyStrategy.NONE == factory.getSettings().getMultiTenancyStrategy()) {
            if (tenantIdentifier != null) {
                throw new HibernateException("SessionFactory was not configured for multi-tenancy");
            }
        } else if (tenantIdentifier == null) {
            throw new HibernateException("SessionFactory configured for multi-tenancy, but no tenant identifier specified");
        }
    }

    @Override
    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    @Override
    public TransactionEnvironment getTransactionEnvironment() {
        return this.factory.getTransactionEnvironment();
    }

    @Override
    public <T> T execute(final LobCreationContext.Callback<T> callback) {
        return this.getTransactionCoordinator().getJdbcCoordinator().coordinateWork(new WorkExecutorVisitable<T>(){

            @Override
            public T accept(WorkExecutor<T> workExecutor, Connection connection) throws SQLException {
                try {
                    return callback.executeOnConnection(connection);
                }
                catch (SQLException e) {
                    throw AbstractSessionImpl.this.getFactory().getSQLExceptionHelper().convert(e, "Error creating contextual LOB : " + e.getMessage());
                }
            }
        });
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    protected void setClosed() {
        this.closed = true;
    }

    protected void errorIfClosed() {
        if (this.closed) {
            throw new SessionException("Session is closed!");
        }
    }

    @Override
    public Query getNamedQuery(String queryName) throws MappingException {
        AbstractQueryImpl query;
        this.errorIfClosed();
        NamedQueryDefinition nqd = this.factory.getNamedQuery(queryName);
        if (nqd != null) {
            String queryString = nqd.getQueryString();
            query = new QueryImpl(queryString, nqd.getFlushMode(), this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
            query.setComment("named HQL query " + queryName);
            if (nqd.getLockTimeout() != null) {
                ((QueryImpl)query).getLockOptions().setTimeOut(nqd.getLockTimeout());
            }
        } else {
            NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
            if (nsqlqd == null) {
                throw new MappingException("Named query not known: " + queryName);
            }
            ParameterMetadata parameterMetadata = this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString());
            query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, parameterMetadata);
            query.setComment("named native SQL query " + queryName);
            nqd = nsqlqd;
        }
        this.initQuery(query, nqd);
        return query;
    }

    @Override
    public Query getNamedSQLQuery(String queryName) throws MappingException {
        this.errorIfClosed();
        NamedSQLQueryDefinition nsqlqd = this.factory.getNamedSQLQuery(queryName);
        if (nsqlqd == null) {
            throw new MappingException("Named SQL query not known: " + queryName);
        }
        SQLQueryImpl query = new SQLQueryImpl(nsqlqd, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(nsqlqd.getQueryString()));
        query.setComment("named native SQL query " + queryName);
        this.initQuery(query, nsqlqd);
        return query;
    }

    private void initQuery(Query query, NamedQueryDefinition nqd) {
        query.setCacheable(nqd.isCacheable());
        query.setCacheRegion(nqd.getCacheRegion());
        if (nqd.getTimeout() != null) {
            query.setTimeout(nqd.getTimeout());
        }
        if (nqd.getFetchSize() != null) {
            query.setFetchSize(nqd.getFetchSize());
        }
        if (nqd.getCacheMode() != null) {
            query.setCacheMode(nqd.getCacheMode());
        }
        query.setReadOnly(nqd.isReadOnly());
        if (nqd.getComment() != null) {
            query.setComment(nqd.getComment());
        }
    }

    @Override
    public Query createQuery(String queryString) {
        this.errorIfClosed();
        QueryImpl query = new QueryImpl(queryString, this, this.getHQLQueryPlan(queryString, false).getParameterMetadata());
        query.setComment(queryString);
        return query;
    }

    @Override
    public SQLQuery createSQLQuery(String sql) {
        this.errorIfClosed();
        SQLQueryImpl query = new SQLQueryImpl(sql, (SessionImplementor)this, this.factory.getQueryPlanCache().getSQLParameterMetadata(sql));
        query.setComment("dynamic native SQL query");
        return query;
    }

    protected HQLQueryPlan getHQLQueryPlan(String query, boolean shallow) throws HibernateException {
        return this.factory.getQueryPlanCache().getHQLQueryPlan(query, shallow, this.getEnabledFilters());
    }

    protected NativeSQLQueryPlan getNativeSQLQueryPlan(NativeSQLQuerySpecification spec) throws HibernateException {
        return this.factory.getQueryPlanCache().getNativeSQLQueryPlan(spec);
    }

    @Override
    public List list(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.listCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public ScrollableResults scroll(NativeSQLQuerySpecification spec, QueryParameters queryParameters) throws HibernateException {
        return this.scrollCustomQuery(this.getNativeSQLQueryPlan(spec).getCustomQuery(), queryParameters);
    }

    @Override
    public String getTenantIdentifier() {
        return this.tenantIdentifier;
    }

    @Override
    public EntityKey generateEntityKey(Serializable id, EntityPersister persister) {
        return new EntityKey(id, persister);
    }

    @Override
    public CacheKey generateCacheKey(Serializable id, Type type, String entityOrRoleName) {
        String tenantIdentifier = this.getTenantIdentifier();
        if (tenantIdentifier == null) {
            return new CacheKey(id, type, entityOrRoleName, this.getFactory());
        }
        return new TenantAwareCacheKey(id, type, entityOrRoleName, this.getFactory(), tenantIdentifier);
    }

    @Override
    public JdbcConnectionAccess getJdbcConnectionAccess() {
        if (this.jdbcConnectionAccess == null) {
            this.jdbcConnectionAccess = MultiTenancyStrategy.NONE == this.factory.getSettings().getMultiTenancyStrategy() ? new NonContextualJdbcConnectionAccess(this.getEventListenerManager(), this.factory.getServiceRegistry().getService(ConnectionProvider.class)) : new ContextualJdbcConnectionAccess(this.getEventListenerManager(), this.factory.getServiceRegistry().getService(MultiTenantConnectionProvider.class));
        }
        return this.jdbcConnectionAccess;
    }

    public UUID getSessionIdentifier() {
        if (this.sessionIdentifier == null) {
            this.sessionIdentifier = StandardRandomStrategy.INSTANCE.generateUUID(this);
        }
        return this.sessionIdentifier;
    }

    private class ContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final SessionEventListener listener;
        private final MultiTenantConnectionProvider connectionProvider;

        private ContextualJdbcConnectionAccess(SessionEventListener listener, MultiTenantConnectionProvider connectionProvider) {
            this.listener = listener;
            this.connectionProvider = connectionProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection obtainConnection() throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            try {
                this.listener.jdbcConnectionAcquisitionStart();
                Connection connection = this.connectionProvider.getConnection(AbstractSessionImpl.this.tenantIdentifier);
                return connection;
            }
            finally {
                this.listener.jdbcConnectionAcquisitionEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            if (AbstractSessionImpl.this.tenantIdentifier == null) {
                throw new HibernateException("Tenant identifier required!");
            }
            try {
                this.listener.jdbcConnectionReleaseStart();
                this.connectionProvider.releaseConnection(AbstractSessionImpl.this.tenantIdentifier, connection);
            }
            finally {
                this.listener.jdbcConnectionReleaseEnd();
            }
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }

    private static class NonContextualJdbcConnectionAccess
    implements JdbcConnectionAccess,
    Serializable {
        private final SessionEventListener listener;
        private final ConnectionProvider connectionProvider;

        private NonContextualJdbcConnectionAccess(SessionEventListener listener, ConnectionProvider connectionProvider) {
            this.listener = listener;
            this.connectionProvider = connectionProvider;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Connection obtainConnection() throws SQLException {
            try {
                this.listener.jdbcConnectionAcquisitionStart();
                Connection connection = this.connectionProvider.getConnection();
                return connection;
            }
            finally {
                this.listener.jdbcConnectionAcquisitionEnd();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void releaseConnection(Connection connection) throws SQLException {
            try {
                this.listener.jdbcConnectionReleaseStart();
                this.connectionProvider.closeConnection(connection);
            }
            finally {
                this.listener.jdbcConnectionReleaseEnd();
            }
        }

        @Override
        public boolean supportsAggressiveRelease() {
            return this.connectionProvider.supportsAggressiveRelease();
        }
    }
}

