/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.service.jta.platform.internal;

import java.util.Map;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.jndi.JndiHelper;
import org.hibernate.service.classloading.spi.ClassLoaderService;
import org.hibernate.service.config.spi.ConfigurationService;
import org.hibernate.service.jta.platform.internal.BitronixJtaPlatform;
import org.hibernate.service.jta.platform.internal.BorlandEnterpriseServerJtaPlatform;
import org.hibernate.service.jta.platform.internal.JBossAppServerJtaPlatform;
import org.hibernate.service.jta.platform.internal.JBossStandAloneJtaPlatform;
import org.hibernate.service.jta.platform.internal.JOTMJtaPlatform;
import org.hibernate.service.jta.platform.internal.JOnASJtaPlatform;
import org.hibernate.service.jta.platform.internal.JRun4JtaPlatform;
import org.hibernate.service.jta.platform.internal.NoJtaPlatform;
import org.hibernate.service.jta.platform.internal.OC4JJtaPlatform;
import org.hibernate.service.jta.platform.internal.OrionJtaPlatform;
import org.hibernate.service.jta.platform.internal.ResinJtaPlatform;
import org.hibernate.service.jta.platform.internal.SunOneJtaPlatform;
import org.hibernate.service.jta.platform.internal.TransactionManagerLookupBridge;
import org.hibernate.service.jta.platform.internal.WebSphereExtendedJtaPlatform;
import org.hibernate.service.jta.platform.internal.WebSphereJtaPlatform;
import org.hibernate.service.jta.platform.internal.WeblogicJtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatform;
import org.hibernate.service.jta.platform.spi.JtaPlatformException;
import org.hibernate.service.spi.BasicServiceInitiator;
import org.hibernate.service.spi.ServiceRegistryImplementor;
import org.hibernate.transaction.TransactionManagerLookup;
import org.jboss.logging.Logger;

public class JtaPlatformInitiator
implements BasicServiceInitiator<JtaPlatform> {
    public static final JtaPlatformInitiator INSTANCE = new JtaPlatformInitiator();
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)JtaPlatformInitiator.class.getName());

    @Override
    public Class<JtaPlatform> getServiceInitiated() {
        return JtaPlatform.class;
    }

    @Override
    public JtaPlatform initiateService(Map configurationValues, ServiceRegistryImplementor registry) {
        Object platform = this.getConfiguredPlatform(configurationValues, registry);
        if (platform == null) {
            return new NoJtaPlatform();
        }
        return registry.getService(ConfigurationService.class).cast(JtaPlatform.class, platform);
    }

    private Object getConfiguredPlatform(Map configVales, ServiceRegistryImplementor registry) {
        String transactionManagerLookupImplName;
        Object platform = configVales.get("hibernate.transaction.jta.platform");
        if (platform == null && (transactionManagerLookupImplName = (String)configVales.get("hibernate.transaction.manager_lookup_class")) != null) {
            LOG.deprecatedTransactionManagerStrategy(TransactionManagerLookup.class.getName(), "hibernate.transaction.manager_lookup_class", JtaPlatform.class.getName(), "hibernate.transaction.jta.platform");
            platform = this.mapLegacyClasses(transactionManagerLookupImplName, configVales, registry);
            LOG.debugf("Mapped %s -> %s", transactionManagerLookupImplName, platform);
        }
        return platform;
    }

    private JtaPlatform mapLegacyClasses(String tmlImplName, Map configVales, ServiceRegistryImplementor registry) {
        if (tmlImplName == null) {
            return null;
        }
        LOG.legacyTransactionManagerStrategy(JtaPlatform.class.getName(), "hibernate.transaction.jta.platform");
        if ("org.hibernate.transaction.BESTransactionManagerLookup".equals(tmlImplName)) {
            return new BorlandEnterpriseServerJtaPlatform();
        }
        if ("org.hibernate.transaction.BTMTransactionManagerLookup".equals(tmlImplName)) {
            return new BitronixJtaPlatform();
        }
        if ("org.hibernate.transaction.JBossTransactionManagerLookup".equals(tmlImplName)) {
            return new JBossAppServerJtaPlatform();
        }
        if ("org.hibernate.transaction.JBossTSStandaloneTransactionManagerLookup".equals(tmlImplName)) {
            return new JBossStandAloneJtaPlatform();
        }
        if ("org.hibernate.transaction.JOnASTransactionManagerLookup".equals(tmlImplName)) {
            return new JOnASJtaPlatform();
        }
        if ("org.hibernate.transaction.JOTMTransactionManagerLookup".equals(tmlImplName)) {
            return new JOTMJtaPlatform();
        }
        if ("org.hibernate.transaction.JRun4TransactionManagerLookup".equals(tmlImplName)) {
            return new JRun4JtaPlatform();
        }
        if ("org.hibernate.transaction.OC4JTransactionManagerLookup".equals(tmlImplName)) {
            return new OC4JJtaPlatform();
        }
        if ("org.hibernate.transaction.OrionTransactionManagerLookup".equals(tmlImplName)) {
            return new OrionJtaPlatform();
        }
        if ("org.hibernate.transaction.ResinTransactionManagerLookup".equals(tmlImplName)) {
            return new ResinJtaPlatform();
        }
        if ("org.hibernate.transaction.SunONETransactionManagerLookup".equals(tmlImplName)) {
            return new SunOneJtaPlatform();
        }
        if ("org.hibernate.transaction.WeblogicTransactionManagerLookup".equals(tmlImplName)) {
            return new WeblogicJtaPlatform();
        }
        if ("org.hibernate.transaction.WebSphereTransactionManagerLookup".equals(tmlImplName)) {
            return new WebSphereJtaPlatform();
        }
        if ("org.hibernate.transaction.WebSphereExtendedJTATransactionLookup".equals(tmlImplName)) {
            return new WebSphereExtendedJtaPlatform();
        }
        try {
            TransactionManagerLookup lookup = (TransactionManagerLookup)registry.getService(ClassLoaderService.class).classForName(tmlImplName).newInstance();
            return new TransactionManagerLookupBridge(lookup, JndiHelper.extractJndiProperties(configVales));
        }
        catch (Exception e) {
            throw new JtaPlatformException("Unable to build " + TransactionManagerLookupBridge.class.getName() + " from specified " + TransactionManagerLookup.class.getName() + " implementation: " + tmlImplName);
        }
    }
}

