/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.internal.util.collections;

import java.util.Iterator;
import java.util.List;
import org.hibernate.internal.util.collections.EmptyIterator;

public class JoinedIterator
implements Iterator {
    private static final Iterator[] ITERATORS = new Iterator[0];
    private Iterator[] iterators;
    private int currentIteratorIndex;
    private Iterator currentIterator;
    private Iterator lastUsedIterator;

    public JoinedIterator(List iterators) {
        this(iterators.toArray(ITERATORS));
    }

    public JoinedIterator(Iterator[] iterators) {
        if (iterators == null) {
            throw new NullPointerException("Unexpected NULL iterators argument");
        }
        this.iterators = iterators;
    }

    public JoinedIterator(Iterator first, Iterator second) {
        this(new Iterator[]{first, second});
    }

    @Override
    public boolean hasNext() {
        this.updateCurrentIterator();
        return this.currentIterator.hasNext();
    }

    public Object next() {
        this.updateCurrentIterator();
        return this.currentIterator.next();
    }

    @Override
    public void remove() {
        this.updateCurrentIterator();
        this.lastUsedIterator.remove();
    }

    protected void updateCurrentIterator() {
        if (this.currentIterator == null) {
            this.currentIterator = this.iterators.length == 0 ? EmptyIterator.INSTANCE : this.iterators[0];
            this.lastUsedIterator = this.currentIterator;
        }
        while (!this.currentIterator.hasNext() && this.currentIteratorIndex < this.iterators.length - 1) {
            ++this.currentIteratorIndex;
            this.currentIterator = this.iterators[this.currentIteratorIndex];
        }
    }
}

