/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.transaction.synchronization.internal;

import org.hibernate.HibernateException;
import org.hibernate.engine.transaction.internal.jta.JtaStatusHelper;
import org.hibernate.engine.transaction.spi.TransactionCoordinator;
import org.hibernate.engine.transaction.synchronization.internal.SynchronizationCallbackCoordinatorNonTrackingImpl;
import org.hibernate.internal.CoreMessageLogger;
import org.jboss.logging.Logger;

public class SynchronizationCallbackCoordinatorTrackingImpl
extends SynchronizationCallbackCoordinatorNonTrackingImpl {
    private static final CoreMessageLogger log = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)SynchronizationCallbackCoordinatorTrackingImpl.class.getName());
    private static final int NO_STATUS = -1;
    private static final long NO_THREAD_ID = Long.MIN_VALUE;
    private volatile long registrationThreadId;
    private volatile int delayedCompletionHandlingStatus;

    public SynchronizationCallbackCoordinatorTrackingImpl(TransactionCoordinator transactionCoordinator) {
        super(transactionCoordinator);
    }

    @Override
    public void reset() {
        super.reset();
        this.delayedCompletionHandlingStatus = -1;
        this.registrationThreadId = Long.MIN_VALUE;
    }

    @Override
    public void afterCompletion(int status) {
        if (JtaStatusHelper.isRollback(status)) {
            boolean isRegistrationThread;
            long currentThreadId = Thread.currentThread().getId();
            boolean bl = isRegistrationThread = currentThreadId == this.registrationThreadId;
            if (!isRegistrationThread) {
                this.delayedCompletionHandlingStatus = status;
                log.rollbackFromBackgroundThread(status);
                return;
            }
        }
        this.doAfterCompletion(status);
    }

    @Override
    public void pulse() {
        if (this.registrationThreadId == Long.MIN_VALUE) {
            this.registrationThreadId = Thread.currentThread().getId();
        }
    }

    @Override
    public void processAnyDelayedAfterCompletion() {
        if (this.delayedCompletionHandlingStatus != -1) {
            this.doAfterCompletion(this.delayedCompletionHandlingStatus);
            this.delayedCompletionHandlingStatus = -1;
            throw new HibernateException("Transaction was rolled back in a different thread!");
        }
    }
}

