/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tool.enhance;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javax.persistence.Entity;
import javax.persistence.Transient;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;
import org.hibernate.bytecode.enhance.spi.EnhancementContext;
import org.hibernate.bytecode.enhance.spi.Enhancer;

public class EnhancementTask
extends Task
implements EnhancementContext {
    private List<FileSet> filesets = new ArrayList<FileSet>();
    private final ClassPool classPool = new ClassPool(false);
    private final Enhancer enhancer = new Enhancer(this);

    public void addFileset(FileSet set) {
        this.filesets.add(set);
    }

    public void execute() throws BuildException {
        this.log("Starting Hibernate EnhancementTask execution", 2);
        Project project = this.getProject();
        for (FileSet fileSet : this.filesets) {
            File fileSetBaseDir = fileSet.getDir(project);
            DirectoryScanner directoryScanner = fileSet.getDirectoryScanner(project);
            for (String relativeIncludedFileName : directoryScanner.getIncludedFiles()) {
                File javaClassFile = new File(fileSetBaseDir, relativeIncludedFileName);
                if (!javaClassFile.exists()) continue;
                this.processClassFile(javaClassFile);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processClassFile(File javaClassFile) {
        try {
            byte[] enhancedBytecode;
            CtClass ctClass = this.classPool.makeClass((InputStream)new FileInputStream(javaClassFile));
            if (!this.shouldInclude(ctClass)) {
                return;
            }
            try {
                enhancedBytecode = this.enhancer.enhance(ctClass.getName(), ctClass.toBytecode());
            }
            catch (Exception e) {
                this.log("Unable to enhance class [" + ctClass.getName() + "]", e, 1);
                return;
            }
            if (javaClassFile.delete()) {
                if (!javaClassFile.createNewFile()) {
                    this.log("Unable to recreate class file [" + ctClass.getName() + "]", 2);
                }
            } else {
                this.log("Unable to delete class file [" + ctClass.getName() + "]", 2);
            }
            FileOutputStream outputStream = new FileOutputStream(javaClassFile, false);
            try {
                outputStream.write(enhancedBytecode);
                outputStream.flush();
            }
            finally {
                try {
                    outputStream.close();
                }
                catch (IOException ignore) {}
            }
        }
        catch (FileNotFoundException ignore) {
        }
        catch (IOException e) {
            throw new BuildException(String.format("Error processing included file [%s]", javaClassFile.getAbsolutePath()), (Throwable)e);
        }
    }

    private boolean shouldInclude(CtClass ctClass) {
        return !ctClass.hasAnnotation(Entity.class);
    }

    @Override
    public ClassLoader getLoadingClassLoader() {
        return this.getClass().getClassLoader();
    }

    @Override
    public boolean isEntityClass(CtClass classDescriptor) {
        return true;
    }

    @Override
    public boolean isCompositeClass(CtClass classDescriptor) {
        return false;
    }

    @Override
    public boolean doDirtyCheckingInline(CtClass classDescriptor) {
        return false;
    }

    @Override
    public boolean hasLazyLoadableAttributes(CtClass classDescriptor) {
        return true;
    }

    @Override
    public boolean isLazyLoadable(CtField field) {
        return true;
    }

    @Override
    public boolean isPersistentField(CtField ctField) {
        return !ctField.hasAnnotation(Transient.class);
    }

    @Override
    public CtField[] order(CtField[] persistentFields) {
        return persistentFields;
    }
}

