/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.io.InputStream;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.xml.DTDEntityResolver;
import org.jboss.logging.Logger;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;

public class EJB3DTDEntityResolver
extends DTDEntityResolver {
    public static final EntityResolver INSTANCE = new EJB3DTDEntityResolver();
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)EJB3DTDEntityResolver.class.getName());
    boolean resolved = false;

    public boolean isResolved() {
        return this.resolved;
    }

    @Override
    public InputSource resolveEntity(String publicId, String systemId) {
        LOG.tracev("Resolving XML entity {0} : {1}", publicId, systemId);
        InputSource is = super.resolveEntity(publicId, systemId);
        if (is == null) {
            if (systemId != null) {
                InputStream dtdStream;
                InputSource source;
                if (systemId.endsWith("orm_1_0.xsd")) {
                    InputStream dtdStream2 = this.getStreamFromClasspath("orm_1_0.xsd");
                    InputSource source2 = this.buildInputSource(publicId, systemId, dtdStream2, false);
                    if (source2 != null) {
                        return source2;
                    }
                } else if (systemId.endsWith("orm_2_0.xsd")) {
                    InputStream dtdStream3 = this.getStreamFromClasspath("orm_2_0.xsd");
                    InputSource source3 = this.buildInputSource(publicId, systemId, dtdStream3, false);
                    if (source3 != null) {
                        return source3;
                    }
                } else if (systemId.endsWith("persistence_1_0.xsd")) {
                    InputStream dtdStream4 = this.getStreamFromClasspath("persistence_1_0.xsd");
                    InputSource source4 = this.buildInputSource(publicId, systemId, dtdStream4, true);
                    if (source4 != null) {
                        return source4;
                    }
                } else if (systemId.endsWith("persistence_2_0.xsd") && (source = this.buildInputSource(publicId, systemId, dtdStream = this.getStreamFromClasspath("persistence_2_0.xsd"), true)) != null) {
                    return source;
                }
            }
        } else {
            this.resolved = true;
            return is;
        }
        return null;
    }

    private InputSource buildInputSource(String publicId, String systemId, InputStream dtdStream, boolean resolved) {
        if (dtdStream == null) {
            LOG.tracev("Unable to locate [{0}] on classpath", systemId);
            return null;
        }
        LOG.tracev("Located [{0}] in classpath", systemId);
        InputSource source = new InputSource(dtdStream);
        source.setPublicId(publicId);
        source.setSystemId(systemId);
        this.resolved = resolved;
        return source;
    }

    private InputStream getStreamFromClasspath(String fileName) {
        LOG.trace("Recognized JPA ORM namespace; attempting to resolve on classpath under org/hibernate/ejb");
        String path = "org/hibernate/ejb/" + fileName;
        InputStream dtdStream = this.resolveInHibernateNamespace(path);
        return dtdStream;
    }
}

