/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.hql.internal.ast.exec;

import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.QueryParameters;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.hql.internal.ast.HqlSqlWalker;
import org.hibernate.hql.internal.ast.exec.AbstractStatementExecutor;
import org.hibernate.hql.internal.ast.tree.AssignmentSpecification;
import org.hibernate.hql.internal.ast.tree.FromElement;
import org.hibernate.hql.internal.ast.tree.UpdateStatement;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.param.ParameterSpecification;
import org.hibernate.persister.entity.Queryable;
import org.hibernate.sql.Update;
import org.jboss.logging.Logger;

public class MultiTableUpdateExecutor
extends AbstractStatementExecutor {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)MultiTableUpdateExecutor.class.getName());
    private final Queryable persister;
    private final String idInsertSelect;
    private final String[] updates;
    private final ParameterSpecification[][] hqlParameters;

    public MultiTableUpdateExecutor(HqlSqlWalker walker) {
        super(walker, null);
        if (!walker.getSessionFactoryHelper().getFactory().getDialect().supportsTemporaryTables()) {
            throw new HibernateException("cannot doAfterTransactionCompletion multi-table updates using dialect not supporting temp tables");
        }
        UpdateStatement updateStatement = (UpdateStatement)walker.getAST();
        FromElement fromElement = updateStatement.getFromClause().getFromElement();
        String bulkTargetAlias = fromElement.getTableAlias();
        this.persister = fromElement.getQueryable();
        this.idInsertSelect = this.generateIdInsertSelect(this.persister, bulkTargetAlias, updateStatement.getWhereClause());
        LOG.tracev("Generated ID-INSERT-SELECT SQL (multi-table update) : {0}", this.idInsertSelect);
        String[] tableNames = this.persister.getConstraintOrderedTableNameClosure();
        String[][] columnNames = this.persister.getContraintOrderedTableKeyColumnClosure();
        String idSubselect = this.generateIdSubselect(this.persister);
        ArrayList assignmentSpecifications = walker.getAssignmentSpecifications();
        this.updates = new String[tableNames.length];
        this.hqlParameters = new ParameterSpecification[tableNames.length][];
        for (int tableIndex = 0; tableIndex < tableNames.length; ++tableIndex) {
            boolean affected = false;
            ArrayList<ParameterSpecification> parameterList = new ArrayList<ParameterSpecification>();
            Update update = new Update(this.getFactory().getDialect()).setTableName(tableNames[tableIndex]).setWhere("(" + StringHelper.join(", ", columnNames[tableIndex]) + ") IN (" + idSubselect + ")");
            if (this.getFactory().getSettings().isCommentsEnabled()) {
                update.setComment("bulk update");
            }
            for (AssignmentSpecification specification : assignmentSpecifications) {
                if (!specification.affectsTable(tableNames[tableIndex])) continue;
                affected = true;
                update.appendAssignmentFragment(specification.getSqlAssignmentFragment());
                if (specification.getParameters() == null) continue;
                for (int paramIndex = 0; paramIndex < specification.getParameters().length; ++paramIndex) {
                    parameterList.add(specification.getParameters()[paramIndex]);
                }
            }
            if (!affected) continue;
            this.updates[tableIndex] = update.toStatementString();
            this.hqlParameters[tableIndex] = parameterList.toArray(new ParameterSpecification[0]);
        }
    }

    public Queryable getAffectedQueryable() {
        return this.persister;
    }

    @Override
    public String[] getSqlStatements() {
        return this.updates;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int execute(QueryParameters parameters, SessionImplementor session) throws HibernateException {
        this.coordinateSharedCacheCleanup(session);
        this.createTemporaryTableIfNecessary(this.persister, session);
        try {
            Statement ps = null;
            int resultCount = 0;
            try {
                try {
                    ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.idInsertSelect, false);
                    Iterator whereParams = this.getIdSelectParameterSpecifications().iterator();
                    int sum = 1;
                    while (whereParams.hasNext()) {
                        sum += ((ParameterSpecification)whereParams.next()).bind((PreparedStatement)ps, parameters, session, sum);
                    }
                    resultCount = ps.executeUpdate();
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
            }
            catch (SQLException e) {
                throw this.getFactory().getSQLExceptionHelper().convert(e, "could not insert/select ids for bulk update", this.idInsertSelect);
            }
            for (int i = 0; i < this.updates.length; ++i) {
                if (this.updates[i] == null) continue;
                try {
                    try {
                        ps = session.getTransactionCoordinator().getJdbcCoordinator().getStatementPreparer().prepareStatement(this.updates[i], false);
                        if (this.hqlParameters[i] != null) {
                            int position = 1;
                            for (int x = 0; x < this.hqlParameters[i].length; ++x) {
                                position += this.hqlParameters[i][x].bind((PreparedStatement)ps, parameters, session, position);
                            }
                        }
                        ps.executeUpdate();
                        continue;
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                }
                catch (SQLException e) {
                    throw this.getFactory().getSQLExceptionHelper().convert(e, "error performing bulk update", this.updates[i]);
                }
            }
            int n = resultCount;
            return n;
        }
        finally {
            this.dropTemporaryTableIfNecessary(this.persister, session);
        }
    }

    @Override
    protected Queryable[] getAffectedQueryables() {
        return new Queryable[]{this.persister};
    }
}

