/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.ordering.antlr;

import antlr.TokenStream;
import java.io.StringReader;
import org.hibernate.HibernateException;
import org.hibernate.hql.internal.ast.util.ASTPrinter;
import org.hibernate.internal.CoreMessageLogger;
import org.hibernate.sql.ordering.antlr.GeneratedOrderByLexer;
import org.hibernate.sql.ordering.antlr.OrderByFragmentParser;
import org.hibernate.sql.ordering.antlr.OrderByFragmentRenderer;
import org.hibernate.sql.ordering.antlr.OrderByTemplateTokenTypes;
import org.hibernate.sql.ordering.antlr.TranslationContext;
import org.jboss.logging.Logger;

public class OrderByFragmentTranslator {
    private static final CoreMessageLogger LOG = (CoreMessageLogger)Logger.getMessageLogger(CoreMessageLogger.class, (String)OrderByFragmentTranslator.class.getName());
    public final TranslationContext context;

    public OrderByFragmentTranslator(TranslationContext context) {
        this.context = context;
    }

    public String render(String fragment) {
        GeneratedOrderByLexer lexer = new GeneratedOrderByLexer(new StringReader(fragment));
        OrderByFragmentParser parser = new OrderByFragmentParser((TokenStream)lexer, this.context);
        try {
            parser.orderByFragment();
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to parse order-by fragment", t);
        }
        if (LOG.isTraceEnabled()) {
            ASTPrinter printer = new ASTPrinter(OrderByTemplateTokenTypes.class);
            LOG.trace(printer.showAsString(parser.getAST(), "--- {order-by fragment} ---"));
        }
        OrderByFragmentRenderer renderer = new OrderByFragmentRenderer();
        try {
            renderer.orderByFragment(parser.getAST());
        }
        catch (HibernateException e) {
            throw e;
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to render parsed order-by fragment", t);
        }
        return renderer.getRenderedFragment();
    }
}

