/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;

public class ColumnNameCache {
    public static final float LOAD_FACTOR = 0.75f;
    private final Map columnNameToIndexCache;

    public ColumnNameCache(int columnCount) {
        this.columnNameToIndexCache = new HashMap(columnCount + (int)((float)columnCount * 0.75f) + 1, 0.75f);
    }

    public int getIndexForColumnName(String columnName, ResultSet rs) throws SQLException {
        Integer cached = (Integer)this.columnNameToIndexCache.get(columnName);
        if (cached != null) {
            return cached;
        }
        int index = rs.findColumn(columnName);
        this.columnNameToIndexCache.put(columnName, new Integer(index));
        return index;
    }
}

