/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.engine.profile;

import java.util.HashMap;
import java.util.Map;
import org.hibernate.engine.profile.Association;
import org.hibernate.engine.profile.Fetch;
import org.hibernate.type.BagType;
import org.hibernate.type.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FetchProfile {
    private static final Logger log = LoggerFactory.getLogger((Class)FetchProfile.class);
    private final String name;
    private Map fetches = new HashMap();
    private boolean containsJoinFetchedCollection = false;
    private boolean containsJoinFetchedBag = false;
    private Fetch bagJoinFetch;

    public FetchProfile(String name) {
        this.name = name;
    }

    public void addFetch(Association association, String fetchStyleName) {
        this.addFetch(association, Fetch.Style.parse(fetchStyleName));
    }

    public void addFetch(Association association, Fetch.Style style) {
        this.addFetch(new Fetch(association, style));
    }

    public void addFetch(Fetch fetch) {
        Type associationType = fetch.getAssociation().getOwner().getPropertyType(fetch.getAssociation().getAssociationPath());
        if (associationType.isCollectionType()) {
            log.trace("handling request to add collection fetch [{}]", (Object)fetch.getAssociation().getRole());
            if (Fetch.Style.JOIN == fetch.getStyle()) {
                if (BagType.class.isInstance(associationType) && this.containsJoinFetchedCollection) {
                    log.warn("Ignoring bag join fetch [{}] due to prior collection join fetch", (Object)fetch.getAssociation().getRole());
                    return;
                }
                if (this.containsJoinFetchedBag) {
                    if (this.fetches.remove(this.bagJoinFetch.getAssociation().getRole()) != this.bagJoinFetch) {
                        log.warn("Unable to erase previously added bag join fetch");
                    }
                    this.bagJoinFetch = null;
                    this.containsJoinFetchedBag = false;
                }
                this.containsJoinFetchedCollection = true;
            }
        }
        this.fetches.put(fetch.getAssociation().getRole(), fetch);
    }

    public String getName() {
        return this.name;
    }

    public Map getFetches() {
        return this.fetches;
    }

    public Fetch getFetchByRole(String role) {
        return (Fetch)this.fetches.get(role);
    }

    public boolean isContainsJoinFetchedCollection() {
        return this.containsJoinFetchedCollection;
    }

    public boolean isContainsJoinFetchedBag() {
        return this.containsJoinFetchedBag;
    }
}

