/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect;

import org.hibernate.Hibernate;
import org.hibernate.dialect.Dialect;
import org.hibernate.dialect.function.NoArgSQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.dialect.function.StandardSQLFunction;
import org.hibernate.dialect.function.VarArgsSQLFunction;

public class IngresDialect
extends Dialect {
    public IngresDialect() {
        this.registerColumnType(-7, "tinyint");
        this.registerColumnType(-6, "tinyint");
        this.registerColumnType(5, "smallint");
        this.registerColumnType(4, "integer");
        this.registerColumnType(-5, "bigint");
        this.registerColumnType(7, "real");
        this.registerColumnType(6, "float");
        this.registerColumnType(8, "float");
        this.registerColumnType(2, "decimal($p, $s)");
        this.registerColumnType(3, "decimal($p, $s)");
        this.registerColumnType(-2, 32000, "byte($l)");
        this.registerColumnType(-2, "long byte");
        this.registerColumnType(-3, 32000, "varbyte($l)");
        this.registerColumnType(-3, "long byte");
        this.registerColumnType(-4, "long byte");
        this.registerColumnType(1, "char(1)");
        this.registerColumnType(12, 32000, "varchar($l)");
        this.registerColumnType(12, "long varchar");
        this.registerColumnType(-1, "long varchar");
        this.registerColumnType(91, "date");
        this.registerColumnType(92, "time with time zone");
        this.registerColumnType(93, "timestamp with time zone");
        this.registerColumnType(2004, "blob");
        this.registerColumnType(2005, "clob");
        this.registerFunction("abs", new StandardSQLFunction("abs"));
        this.registerFunction("atan", new StandardSQLFunction("atan", Hibernate.DOUBLE));
        this.registerFunction("bit_add", new StandardSQLFunction("bit_add"));
        this.registerFunction("bit_and", new StandardSQLFunction("bit_and"));
        this.registerFunction("bit_length", new SQLFunctionTemplate(Hibernate.INTEGER, "octet_length(hex(?1))*4"));
        this.registerFunction("bit_not", new StandardSQLFunction("bit_not"));
        this.registerFunction("bit_or", new StandardSQLFunction("bit_or"));
        this.registerFunction("bit_xor", new StandardSQLFunction("bit_xor"));
        this.registerFunction("character_length", new StandardSQLFunction("character_length", Hibernate.LONG));
        this.registerFunction("charextract", new StandardSQLFunction("charextract", Hibernate.STRING));
        this.registerFunction("concat", new VarArgsSQLFunction(Hibernate.STRING, "(", "+", ")"));
        this.registerFunction("cos", new StandardSQLFunction("cos", Hibernate.DOUBLE));
        this.registerFunction("current_user", new NoArgSQLFunction("current_user", Hibernate.STRING, false));
        this.registerFunction("current_time", new NoArgSQLFunction("date('now')", Hibernate.TIMESTAMP, false));
        this.registerFunction("current_timestamp", new NoArgSQLFunction("date('now')", Hibernate.TIMESTAMP, false));
        this.registerFunction("current_date", new NoArgSQLFunction("date('now')", Hibernate.TIMESTAMP, false));
        this.registerFunction("date_trunc", new StandardSQLFunction("date_trunc", Hibernate.TIMESTAMP));
        this.registerFunction("day", new StandardSQLFunction("day", Hibernate.INTEGER));
        this.registerFunction("dba", new NoArgSQLFunction("dba", Hibernate.STRING, true));
        this.registerFunction("dow", new StandardSQLFunction("dow", Hibernate.STRING));
        this.registerFunction("extract", new SQLFunctionTemplate(Hibernate.INTEGER, "date_part('?1', ?3)"));
        this.registerFunction("exp", new StandardSQLFunction("exp", Hibernate.DOUBLE));
        this.registerFunction("gmt_timestamp", new StandardSQLFunction("gmt_timestamp", Hibernate.STRING));
        this.registerFunction("hash", new StandardSQLFunction("hash", Hibernate.INTEGER));
        this.registerFunction("hex", new StandardSQLFunction("hex", Hibernate.STRING));
        this.registerFunction("hour", new StandardSQLFunction("hour", Hibernate.INTEGER));
        this.registerFunction("initial_user", new NoArgSQLFunction("initial_user", Hibernate.STRING, false));
        this.registerFunction("intextract", new StandardSQLFunction("intextract", Hibernate.INTEGER));
        this.registerFunction("left", new StandardSQLFunction("left", Hibernate.STRING));
        this.registerFunction("locate", new SQLFunctionTemplate(Hibernate.LONG, "locate(?1, ?2)"));
        this.registerFunction("length", new StandardSQLFunction("length", Hibernate.LONG));
        this.registerFunction("ln", new StandardSQLFunction("ln", Hibernate.DOUBLE));
        this.registerFunction("log", new StandardSQLFunction("log", Hibernate.DOUBLE));
        this.registerFunction("lower", new StandardSQLFunction("lower"));
        this.registerFunction("lowercase", new StandardSQLFunction("lowercase"));
        this.registerFunction("minute", new StandardSQLFunction("minute", Hibernate.INTEGER));
        this.registerFunction("month", new StandardSQLFunction("month", Hibernate.INTEGER));
        this.registerFunction("octet_length", new StandardSQLFunction("octet_length", Hibernate.LONG));
        this.registerFunction("pad", new StandardSQLFunction("pad", Hibernate.STRING));
        this.registerFunction("position", new StandardSQLFunction("position", Hibernate.LONG));
        this.registerFunction("power", new StandardSQLFunction("power", Hibernate.DOUBLE));
        this.registerFunction("random", new NoArgSQLFunction("random", Hibernate.LONG, true));
        this.registerFunction("randomf", new NoArgSQLFunction("randomf", Hibernate.DOUBLE, true));
        this.registerFunction("right", new StandardSQLFunction("right", Hibernate.STRING));
        this.registerFunction("session_user", new NoArgSQLFunction("session_user", Hibernate.STRING, false));
        this.registerFunction("second", new StandardSQLFunction("second", Hibernate.INTEGER));
        this.registerFunction("size", new NoArgSQLFunction("size", Hibernate.LONG, true));
        this.registerFunction("squeeze", new StandardSQLFunction("squeeze"));
        this.registerFunction("sin", new StandardSQLFunction("sin", Hibernate.DOUBLE));
        this.registerFunction("soundex", new StandardSQLFunction("soundex", Hibernate.STRING));
        this.registerFunction("sqrt", new StandardSQLFunction("sqrt", Hibernate.DOUBLE));
        this.registerFunction("substring", new SQLFunctionTemplate(Hibernate.STRING, "substring(?1 FROM ?2 FOR ?3)"));
        this.registerFunction("system_user", new NoArgSQLFunction("system_user", Hibernate.STRING, false));
        this.registerFunction("unhex", new StandardSQLFunction("unhex", Hibernate.STRING));
        this.registerFunction("upper", new StandardSQLFunction("upper"));
        this.registerFunction("uppercase", new StandardSQLFunction("uppercase"));
        this.registerFunction("user", new NoArgSQLFunction("user", Hibernate.STRING, false));
        this.registerFunction("usercode", new NoArgSQLFunction("usercode", Hibernate.STRING, true));
        this.registerFunction("username", new NoArgSQLFunction("username", Hibernate.STRING, true));
        this.registerFunction("uuid_create", new StandardSQLFunction("uuid_create", Hibernate.BYTE));
        this.registerFunction("uuid_compare", new StandardSQLFunction("uuid_compare", Hibernate.INTEGER));
        this.registerFunction("uuid_from_char", new StandardSQLFunction("uuid_from_char", Hibernate.BYTE));
        this.registerFunction("uuid_to_char", new StandardSQLFunction("uuid_to_char", Hibernate.STRING));
        this.registerFunction("year", new StandardSQLFunction("year", Hibernate.INTEGER));
        this.registerFunction("str", new SQLFunctionTemplate(Hibernate.STRING, "cast(?1 as varchar)"));
        this.getDefaultProperties().setProperty("hibernate.jdbc.use_get_generated_keys", "false");
        this.getDefaultProperties().setProperty("hibernate.query.substitutions", "true=1,false=0");
    }

    public boolean dropConstraints() {
        return false;
    }

    public boolean supportsForUpdateOf() {
        return true;
    }

    public String getAddColumnString() {
        return "add column";
    }

    public String getNullColumnString() {
        return " with null";
    }

    public boolean supportsSequences() {
        return true;
    }

    public String getSequenceNextValString(String sequenceName) {
        return "select nextval for " + sequenceName;
    }

    public String getSelectSequenceNextValString(String sequenceName) {
        return sequenceName + ".nextval";
    }

    public String getCreateSequenceString(String sequenceName) {
        return "create sequence " + sequenceName;
    }

    public String getDropSequenceString(String sequenceName) {
        return "drop sequence " + sequenceName + " restrict";
    }

    public String getQuerySequencesString() {
        return "select seq_name from iisequence";
    }

    public String getLowercaseFunction() {
        return "lowercase";
    }

    public boolean supportsLimit() {
        return true;
    }

    public boolean supportsLimitOffset() {
        return false;
    }

    public String getLimitString(String querySelect, int offset, int limit) {
        if (offset > 0) {
            throw new UnsupportedOperationException("query result offset is not supported");
        }
        return new StringBuffer(querySelect.length() + 16).append(querySelect).insert(6, " first " + limit).toString();
    }

    public boolean supportsVariableLimit() {
        return false;
    }

    public boolean useMaxForLimit() {
        return true;
    }

    public boolean supportsNotNullUnique() {
        return false;
    }

    public boolean supportsTemporaryTables() {
        return true;
    }

    public String getCreateTemporaryTableString() {
        return "declare global temporary table";
    }

    public String getCreateTemporaryTablePostfix() {
        return "on commit preserve rows with norecovery";
    }

    public String generateTemporaryTableName(String baseTableName) {
        return "session." + super.generateTemporaryTableName(baseTableName);
    }

    public String getCurrentTimestampSQLFunctionName() {
        return "date(now)";
    }

    public boolean supportsSubselectAsInPredicateLHS() {
        return false;
    }

    public boolean supportsEmptyInList() {
        return false;
    }

    public boolean supportsExpectedLobUsagePattern() {
        return false;
    }
}

