/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.tuple.entity;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.util.Map;
import org.hibernate.EntityMode;
import org.hibernate.HibernateException;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.tuple.entity.Dom4jEntityTuplizer;
import org.hibernate.tuple.entity.DynamicMapEntityTuplizer;
import org.hibernate.tuple.entity.EntityMetamodel;
import org.hibernate.tuple.entity.EntityTuplizer;
import org.hibernate.tuple.entity.PojoEntityTuplizer;
import org.hibernate.util.FastHashMap;
import org.hibernate.util.ReflectHelper;

public class EntityTuplizerFactory
implements Serializable {
    public static final Class[] ENTITY_TUP_CTOR_SIG;
    private Map defaultImplClassByMode = EntityTuplizerFactory.buildBaseMapping();
    static final /* synthetic */ boolean $assertionsDisabled;

    public void registerDefaultTuplizerClass(EntityMode entityMode, Class tuplizerClass) {
        if (!$assertionsDisabled && !this.isEntityTuplizerImplementor(tuplizerClass)) {
            throw new AssertionError((Object)("Specified tuplizer class [" + tuplizerClass.getName() + "] does not implement " + EntityTuplizer.class.getName()));
        }
        if (!$assertionsDisabled && !this.hasProperConstructor(tuplizerClass)) {
            throw new AssertionError((Object)("Specified tuplizer class [" + tuplizerClass.getName() + "] is not properly instantiatable"));
        }
        this.defaultImplClassByMode.put(entityMode, tuplizerClass);
    }

    public EntityTuplizer constructTuplizer(String tuplizerClassName, EntityMetamodel metamodel, PersistentClass persistentClass) {
        try {
            Class tuplizerClass = ReflectHelper.classForName(tuplizerClassName);
            return this.constructTuplizer(tuplizerClass, metamodel, persistentClass);
        }
        catch (ClassNotFoundException e) {
            throw new HibernateException("Could not locate specified tuplizer class [" + tuplizerClassName + "]");
        }
    }

    public EntityTuplizer constructTuplizer(Class tuplizerClass, EntityMetamodel metamodel, PersistentClass persistentClass) {
        Constructor ctor = this.getProperConstructor(tuplizerClass);
        if (!$assertionsDisabled && ctor == null) {
            throw new AssertionError((Object)("Unable to locate proper constructor for tuplizer [" + tuplizerClass.getName() + "]"));
        }
        try {
            return (EntityTuplizer)ctor.newInstance(metamodel, persistentClass);
        }
        catch (Throwable t) {
            throw new HibernateException("Unable to instantiate default tuplizer [" + tuplizerClass.getName() + "]", t);
        }
    }

    public EntityTuplizer constructDefaultTuplizer(EntityMode entityMode, EntityMetamodel metamodel, PersistentClass persistentClass) {
        Class tuplizerClass = (Class)this.defaultImplClassByMode.get(entityMode);
        if (tuplizerClass == null) {
            throw new HibernateException("could not determine default tuplizer class to use [" + entityMode + "]");
        }
        return this.constructTuplizer(tuplizerClass, metamodel, persistentClass);
    }

    private boolean isEntityTuplizerImplementor(Class tuplizerClass) {
        return ReflectHelper.implementsInterface(tuplizerClass, EntityTuplizer.class);
    }

    private boolean hasProperConstructor(Class tuplizerClass) {
        return this.getProperConstructor(tuplizerClass) != null && !ReflectHelper.isAbstractClass(tuplizerClass);
    }

    private Constructor getProperConstructor(Class clazz) {
        Constructor ctor = null;
        try {
            ctor = clazz.getDeclaredConstructor(ENTITY_TUP_CTOR_SIG);
            if (!ReflectHelper.isPublic(ctor)) {
                try {
                    ctor.setAccessible(true);
                }
                catch (SecurityException e) {
                    ctor = null;
                }
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return ctor;
    }

    private static Map buildBaseMapping() {
        FastHashMap map = new FastHashMap();
        map.put(EntityMode.POJO, PojoEntityTuplizer.class);
        map.put(EntityMode.DOM4J, Dom4jEntityTuplizer.class);
        map.put(EntityMode.MAP, DynamicMapEntityTuplizer.class);
        return map;
    }

    static {
        $assertionsDisabled = !EntityTuplizerFactory.class.desiredAssertionStatus();
        ENTITY_TUP_CTOR_SIG = new Class[]{EntityMetamodel.class, PersistentClass.class};
    }
}

