package org.hibernate.reflection.java.generics;

import java.lang.reflect.Type;

/**
 * A composition of two <code>TypeEnvironment</code> functions.
 *
 * @author Davide Marchignoli
 * @author Paolo Perrotta
 */
public class CompoundTypeEnvironment implements TypeEnvironment {

	private final TypeEnvironment f;

	private final TypeEnvironment g;

	public CompoundTypeEnvironment(TypeEnvironment f, TypeEnvironment g) {
		this.f = f;
		this.g = g;
	}

	public Type bind(Type type) {
		return f.bind( g.bind( type ) );
	}

	public boolean equals(Object o) {
		if ( this == o ) return true;
		if ( o == null || getClass() != o.getClass() ) return false;

		final CompoundTypeEnvironment that = (CompoundTypeEnvironment) o;

		if ( !f.equals( that.f ) ) return false;
		if ( !g.equals( that.g ) ) return false;

		return true;
	}

	public int hashCode() {
		int result;
		result = f.hashCode();
		result = 29 * result + g.hashCode();
		return result;
	}
}
