//$Id: $
package org.hibernate.lucene.store;

import java.util.Properties;

import org.hibernate.cfg.Configuration;
import org.apache.lucene.store.Directory;


/**
 * Set up and provide a Lucene <code>Directory</code>
 * <code>equals()</code> and <code>hashCode()</code> must guaranty equality
 * between two providers pointing to the same underlying Lucene Store
 * This class must be thread safe regarding <code>getDirectory()</code>
 * calls
 *
 * @author Emmanuel Bernard
 * @author Sylvain Vieujot
 */
public interface DirectoryProvider<TDirectory extends Directory> {
	/** get the information to initialize the directory and build its hashCode */
	void initialize(Class<?> entity, Configuration cfg, Properties properties);

	/**
	 * Returns an initialized Lucene Directory. This method call <b>must</b> be threadsafe
	 */
	TDirectory getDirectory();
}

