/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.lucene;

import java.beans.Introspector;
import java.io.Serializable;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.Term;
import org.hibernate.AssertionFailure;
import org.hibernate.HibernateException;
import org.hibernate.cfg.annotations.Version;
import org.hibernate.lucene.Boost;
import org.hibernate.lucene.Keyword;
import org.hibernate.lucene.Text;
import org.hibernate.lucene.Unstored;
import org.hibernate.lucene.store.DirectoryProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DocumentBuilder<T> {
    private final List<Member> keywordGetters = new ArrayList<Member>();
    private final List<String> keywordNames = new ArrayList<String>();
    private final List<Member> unstoredGetters = new ArrayList<Member>();
    private final List<String> unstoredNames = new ArrayList<String>();
    private final List<Member> textGetters = new ArrayList<Member>();
    private final List<String> textNames = new ArrayList<String>();
    private final DirectoryProvider directoryProvider;
    private String idKeywordName;
    private final Analyzer analyzer;
    private Float idBoost;

    public DocumentBuilder(Class<?> clazz, Analyzer analyzer, DirectoryProvider directory) {
        this.analyzer = analyzer;
        this.directoryProvider = directory;
        for (Class<?> currClass = clazz; currClass != null; currClass = currClass.getSuperclass()) {
            Method[] methods = currClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Text textAnn;
                Unstored unstoredAnn;
                Method method = methods[i];
                Keyword keywordAnn = method.getAnnotation(Keyword.class);
                if (keywordAnn != null) {
                    String name = DocumentBuilder.getAttributeName(method, keywordAnn.name());
                    if (keywordAnn.id()) {
                        this.idKeywordName = name;
                        this.idBoost = this.getBoost(method);
                    } else {
                        DocumentBuilder.setAccessible(method);
                        this.keywordGetters.add(method);
                        this.keywordNames.add(name);
                    }
                }
                if ((unstoredAnn = method.getAnnotation(Unstored.class)) != null) {
                    DocumentBuilder.setAccessible(method);
                    this.unstoredGetters.add(method);
                    this.unstoredNames.add(DocumentBuilder.getAttributeName(method, unstoredAnn.name()));
                }
                if ((textAnn = method.getAnnotation(Text.class)) == null) continue;
                this.textGetters.add(method);
                this.textNames.add(DocumentBuilder.getAttributeName(method, textAnn.name()));
            }
        }
        if (this.idKeywordName == null) {
            throw new HibernateException("No id Keyword for: " + clazz.getName());
        }
    }

    private Float getBoost(AnnotatedElement element) {
        if (element == null) {
            return null;
        }
        Boost boost = element.getAnnotation(Boost.class);
        return boost != null ? new Float(boost.value()) : null;
    }

    private Object getValue(Member member, T bean) {
        try {
            if (member instanceof Field) {
                return ((Field)member).get(bean);
            }
            if (member instanceof Method) {
                return ((Method)member).invoke(bean, new Object[0]);
            }
            throw new AssertionFailure("Unexpected member: " + member.getClass().getName());
        }
        catch (Exception e) {
            throw new IllegalStateException("Could not get property value", e);
        }
    }

    public Document getDocument(T instance, Serializable id) {
        org.apache.lucene.document.Field field;
        Object value;
        Member member;
        int i;
        Document doc = new Document();
        Float boost = this.getBoost(instance.getClass());
        if (boost != null) {
            doc.setBoost(boost.floatValue());
        }
        org.apache.lucene.document.Field idField = new org.apache.lucene.document.Field(this.idKeywordName, id.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED);
        if (this.idBoost != null) {
            idField.setBoost(this.idBoost.floatValue());
        }
        doc.add(idField);
        for (i = 0; i < this.keywordNames.size(); ++i) {
            member = this.keywordGetters.get(i);
            value = this.getValue(member, instance);
            if (value == null) continue;
            field = new org.apache.lucene.document.Field(this.keywordNames.get(i), DocumentBuilder.toString(value), Field.Store.YES, Field.Index.UN_TOKENIZED);
            this.boostField(field, member);
            doc.add(field);
        }
        for (i = 0; i < this.textNames.size(); ++i) {
            member = this.textGetters.get(i);
            value = this.getValue(member, instance);
            if (value == null) continue;
            field = new org.apache.lucene.document.Field(this.textNames.get(i), DocumentBuilder.toString(value), Field.Store.YES, Field.Index.TOKENIZED);
            this.boostField(field, member);
            doc.add(field);
        }
        for (i = 0; i < this.unstoredNames.size(); ++i) {
            member = this.unstoredGetters.get(i);
            value = this.getValue(member, instance);
            if (value == null) continue;
            field = new org.apache.lucene.document.Field(this.unstoredNames.get(i), DocumentBuilder.toString(value), Field.Store.NO, Field.Index.TOKENIZED);
            this.boostField(field, member);
            doc.add(field);
        }
        return doc;
    }

    private void boostField(org.apache.lucene.document.Field field, Member member) {
        Float boost = this.getBoost((AnnotatedElement)((Object)member));
        if (boost != null) {
            field.setBoost(boost.floatValue());
        }
    }

    private static String toString(Object value) {
        return value.toString();
    }

    public Term getTerm(Serializable id) {
        return new Term(this.idKeywordName, id.toString());
    }

    private static String getAttributeName(Method method, String name) {
        if (!"".equals(name)) {
            return name;
        }
        String methodName = method.getName();
        int startIndex = 3;
        if (methodName.startsWith("is")) {
            startIndex = 2;
        }
        return Introspector.decapitalize(methodName.substring(startIndex));
    }

    public DirectoryProvider getDirectoryProvider() {
        return this.directoryProvider;
    }

    public Analyzer getAnalyzer() {
        return this.analyzer;
    }

    private static void setAccessible(Member member) {
        if (!Modifier.isPublic(member.getModifiers())) {
            ((AccessibleObject)((Object)member)).setAccessible(true);
        }
    }

    static {
        Version.touch();
    }
}

