/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.reflection.java;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.Embeddable;
import javax.persistence.Entity;
import javax.persistence.MappedSuperclass;
import org.dom4j.Element;
import org.hibernate.annotationfactory.AnnotationDescriptor;
import org.hibernate.annotationfactory.AnnotationFactory;
import org.hibernate.reflection.java.JavaAnnotationReader;
import org.hibernate.reflection.java.xml.XMLContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class EJB3ClassAnnotationReader
extends JavaAnnotationReader {
    private XMLContext xmlContext;
    private String className;
    private static final Map<Class, String> annotationToXml = new HashMap<Class, String>();

    public EJB3ClassAnnotationReader(AnnotatedElement el, XMLContext xmlContext) {
        super(el);
        this.xmlContext = xmlContext;
        if (el instanceof Class) {
            Class clazz = (Class)el;
            this.className = clazz.getName();
        }
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationType) {
        return super.getAnnotation(annotationType);
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationType) {
        return super.isAnnotationPresent(annotationType);
    }

    @Override
    public Annotation[] getAnnotations() {
        XMLContext.Default defaults = this.xmlContext.getDefault(this.className);
        Element tree = this.xmlContext.getXMLTree(this.className, null);
        Annotation[] annotations = super.getAnnotations();
        ArrayList<Annotation> annotationList = new ArrayList<Annotation>(annotations.length + 5);
        for (Annotation annotation : annotations) {
            if (annotationToXml.containsKey(annotation)) continue;
            annotationList.add(annotation);
        }
        Entity current = this.getEntity(tree, defaults);
        if (current != null) {
            annotationList.add((Annotation)current);
        }
        return super.getAnnotations();
    }

    private Entity getEntity(Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return Boolean.TRUE.equals(defaults.getMetadataComplete()) ? super.getAnnotation(Entity.class) : null;
        }
        if ("entity".equals(tree.getName())) {
            AnnotationDescriptor entity = new AnnotationDescriptor(Entity.class);
            entity.setValue("name", tree.attributeValue("name", ""));
            return (Entity)AnnotationFactory.create(entity);
        }
        return null;
    }

    private Annotation getTopLevelElement(Class<Annotation> annotation, Element tree, XMLContext.Default defaults) {
        if (tree == null) {
            return this.getAnnotation(annotation);
        }
        if (tree.getName().equals(annotationToXml.get(annotation))) {
            return null;
        }
        return null;
    }

    static {
        annotationToXml.put(Entity.class, "entity");
        annotationToXml.put(MappedSuperclass.class, "mapped-superclass");
        annotationToXml.put(Embeddable.class, "embeddable");
    }
}

