/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.Iterator;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.SecondPass;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.Collection;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.Formula;
import org.hibernate.mapping.Map;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Value;
import org.hibernate.reflection.XProperty;

public class MapBinder
extends CollectionBinder {
    protected Collection createCollection(PersistentClass persistentClass) {
        return new Map(persistentClass);
    }

    public SecondPass getSecondPass(final Ejb3JoinColumn[] fkJoinColumns, final Ejb3JoinColumn[] keyColumns, final Ejb3JoinColumn[] inverseColumns, final Ejb3Column[] elementColumns, final boolean isEmbedded, final XProperty property, final String collType, final FetchMode fetchMode, final boolean ignoreNotFound, final boolean unique, final TableBinder assocTableBinder, final ExtendedMappings mappings) {
        return new CollectionSecondPass(mappings, this.collection){

            public void secondPass(java.util.Map persistentClasses, java.util.Map inheritedMetas) throws MappingException {
                MapBinder.this.bindStarToManySecondPass(persistentClasses, collType, fkJoinColumns, keyColumns, inverseColumns, elementColumns, isEmbedded, property, fetchMode, unique, assocTableBinder, ignoreNotFound, mappings);
                MapBinder.this.bindKeyFromAssociationTable(collType, persistentClasses, MapBinder.this.mapKeyPropertyName, mappings);
            }
        };
    }

    private void bindKeyFromAssociationTable(String collType, java.util.Map persistentClasses, String mapKeyPropertyName, ExtendedMappings mappings) {
        if (mapKeyPropertyName == null) {
            throw new AnnotationException("A Map must declare a @MapKey element");
        }
        PersistentClass associatedClass = (PersistentClass)persistentClasses.get(collType);
        if (associatedClass == null) {
            throw new AnnotationException("Associated class not found: " + collType);
        }
        Property property = BinderHelper.findPropertyByName(associatedClass, mapKeyPropertyName);
        if (property == null) {
            throw new AnnotationException("Map key property not found: " + collType + "." + mapKeyPropertyName);
        }
        Map map = (Map)this.collection;
        Value indexValue = this.createFormulatedValue(property.getValue(), (Collection)map);
        map.setIndex(indexValue);
    }

    protected Value createFormulatedValue(Value value, Collection collection) {
        if (value instanceof Component) {
            Component component = (Component)value;
            Iterator properties = component.getPropertyIterator();
            Component indexComponent = new Component(collection);
            indexComponent.setComponentClassName(component.getComponentClassName());
            while (properties.hasNext()) {
                Property current = (Property)properties.next();
                Property newProperty = new Property();
                newProperty.setCascade(current.getCascade());
                newProperty.setGeneration(current.getGeneration());
                newProperty.setInsertable(false);
                newProperty.setUpdateable(false);
                newProperty.setMetaAttributes(current.getMetaAttributes());
                newProperty.setName(current.getName());
                newProperty.setNaturalIdentifier(false);
                newProperty.setOptional(false);
                newProperty.setPersistentClass(current.getPersistentClass());
                newProperty.setPropertyAccessorName(current.getPropertyAccessorName());
                newProperty.setSelectable(current.isSelectable());
                newProperty.setValue(this.createFormulatedValue(current.getValue(), collection));
                indexComponent.addProperty(newProperty);
            }
            return indexComponent;
        }
        SimpleValue sourceValue = (SimpleValue)value;
        SimpleValue targetValue = new SimpleValue(collection.getCollectionTable());
        targetValue.setTypeName(sourceValue.getTypeName());
        targetValue.setTypeParameters(sourceValue.getTypeParameters());
        Iterator columns = sourceValue.getColumnIterator();
        while (columns.hasNext()) {
            Object current = columns.next();
            Formula formula = new Formula();
            if (current instanceof Column) {
                formula.setFormula(((Column)current).getName());
            } else if (current instanceof Formula) {
                formula.setFormula(((Formula)current).getFormula());
            } else {
                throw new AssertionFailure("Unknown element in column iterator: " + current.getClass());
            }
            targetValue.addFormula(formula);
        }
        return targetValue;
    }
}

