/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Embeddable;
import javax.persistence.Embedded;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.IdClass;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.MapKey;
import javax.persistence.MappedSuperclass;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderBy;
import javax.persistence.PrimaryKeyJoinColumn;
import javax.persistence.PrimaryKeyJoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.SequenceGenerator;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.TableGenerator;
import javax.persistence.Transient;
import javax.persistence.Version;
import net.sf.cglib.transform.impl.InterceptFieldCallback;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.AccessType;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.CollectionOfElements;
import org.hibernate.annotations.Columns;
import org.hibernate.annotations.DiscriminatorFormula;
import org.hibernate.annotations.Filter;
import org.hibernate.annotations.FilterDef;
import org.hibernate.annotations.FilterDefs;
import org.hibernate.annotations.Filters;
import org.hibernate.annotations.Formula;
import org.hibernate.annotations.GenericGenerator;
import org.hibernate.annotations.Index;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;
import org.hibernate.annotations.OnDelete;
import org.hibernate.annotations.OnDeleteAction;
import org.hibernate.annotations.ParamDef;
import org.hibernate.annotations.Parameter;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Sort;
import org.hibernate.annotations.Tables;
import org.hibernate.annotations.TypeDef;
import org.hibernate.annotations.TypeDefs;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.IndexColumn;
import org.hibernate.cfg.InheritanceState;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PropertyData;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.cfg.PropertyPreloadedData;
import org.hibernate.cfg.ToOneMappedBySecondPass;
import org.hibernate.cfg.annotations.CollectionBinder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.cfg.annotations.Nullability;
import org.hibernate.cfg.annotations.PropertyBinder;
import org.hibernate.cfg.annotations.QueryBinder;
import org.hibernate.cfg.annotations.SimpleValueBinder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.engine.FilterDefinition;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.SingleTableSubclass;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.ToOne;
import org.hibernate.mapping.UnionSubclass;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.persister.entity.UnionSubclassEntityPersister;
import org.hibernate.reflection.ReflectionManager;
import org.hibernate.reflection.XAnnotatedElement;
import org.hibernate.reflection.XClass;
import org.hibernate.reflection.XPackage;
import org.hibernate.reflection.XProperty;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.type.Type;
import org.hibernate.type.TypeFactory;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    public static final String ANNOTATION_STRING_DEFAULT = "";
    private static final Log log = LogFactory.getLog(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindPackage(String packageName, ExtendedMappings mappings) {
        IdGenerator idGen;
        Object ann;
        XPackage pckg = null;
        try {
            pckg = ReflectionManager.INSTANCE.packageForName(packageName);
        }
        catch (ClassNotFoundException cnf) {
            log.warn((Object)("Package not found or wo package-info.java: " + packageName));
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, mappings);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add sequence generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, mappings);
            mappings.addGenerator(idGen);
        }
        if (pckg.isAnnotationPresent(GenericGenerator.class)) {
            ann = pckg.getAnnotation(GenericGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann, mappings);
            mappings.addGenerator(idGen);
        }
        AnnotationBinder.bindQueries(pckg, mappings);
        AnnotationBinder.bindFilterDefs(pckg, mappings);
        AnnotationBinder.bindTypeDefs(pckg, mappings);
    }

    private static void bindQueries(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        Object ann = annotatedElement.getAnnotation(SqlResultSetMapping.class);
        QueryBinder.bindSqlResultsetMapping(ann, mappings);
        ann = annotatedElement.getAnnotation(SqlResultSetMappings.class);
        if (ann != null) {
            for (SqlResultSetMapping current : ann.value()) {
                QueryBinder.bindSqlResultsetMapping(current, mappings);
            }
        }
        ann = annotatedElement.getAnnotation(NamedQuery.class);
        QueryBinder.bindQuery((NamedQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(org.hibernate.annotations.NamedQuery.class);
        QueryBinder.bindQuery((org.hibernate.annotations.NamedQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(javax.persistence.NamedQueries.class);
        QueryBinder.bindQueries((javax.persistence.NamedQueries)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedQueries.class);
        QueryBinder.bindQueries((NamedQueries)ann, mappings);
        ann = annotatedElement.getAnnotation(javax.persistence.NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((javax.persistence.NamedNativeQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedNativeQuery.class);
        QueryBinder.bindNativeQuery((NamedNativeQuery)ann, mappings);
        ann = annotatedElement.getAnnotation(javax.persistence.NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((javax.persistence.NamedNativeQueries)ann, mappings);
        ann = annotatedElement.getAnnotation(NamedNativeQueries.class);
        QueryBinder.bindNativeQueries((NamedNativeQueries)ann, mappings);
    }

    private static IdGenerator buildIdGenerator(Annotation ann, Mappings mappings) {
        IdGenerator idGen = new IdGenerator();
        if (mappings.getSchemaName() != null) {
            idGen.addParam("schema", mappings.getSchemaName());
        }
        if (mappings.getCatalogName() != null) {
            idGen.addParam("catalog", mappings.getCatalogName());
        }
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof TableGenerator) {
            TableGenerator tabGen = (TableGenerator)ann;
            idGen.setName(tabGen.name());
            idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
            if (!AnnotationBinder.isDefault(tabGen.table())) {
                idGen.addParam("table", tabGen.table());
            }
            if (!AnnotationBinder.isDefault(tabGen.catalog())) {
                idGen.addParam("catalog", tabGen.catalog());
            }
            if (!AnnotationBinder.isDefault(tabGen.schema())) {
                idGen.addParam("schema", tabGen.schema());
            }
            if (!AnnotationBinder.isDefault(tabGen.pkColumnName())) {
                idGen.addParam("primary_key_column", tabGen.pkColumnName());
            }
            if (!AnnotationBinder.isDefault(tabGen.valueColumnName())) {
                idGen.addParam("value_column", tabGen.valueColumnName());
            }
            if (!AnnotationBinder.isDefault(tabGen.pkColumnValue())) {
                idGen.addParam("primary_key_value", tabGen.pkColumnValue());
            }
            idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize()));
            log.debug((Object)("Add table generator with name: " + idGen.getName()));
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            idGen.setIdentifierGeneratorStrategy("sequence");
            if (!AnnotationBinder.isDefault(seqGen.sequenceName())) {
                idGen.addParam("sequence", seqGen.sequenceName());
            }
            if (seqGen.initialValue() != 0 || seqGen.allocationSize() != 50) {
                log.warn((Object)"Hibernate does not support SequenceGenerator.initialValue() nor SequenceGenerator.allocationSize()");
            }
            log.debug((Object)("Add sequence generator with name: " + idGen.getName()));
        } else if (ann instanceof GenericGenerator) {
            Parameter[] params;
            GenericGenerator genGen = (GenericGenerator)ann;
            idGen.setName(genGen.name());
            idGen.setIdentifierGeneratorStrategy(genGen.strategy());
            for (Parameter parameter : params = genGen.parameters()) {
                idGen.addParam(parameter.name(), parameter.value());
            }
            log.debug((Object)("Add generic generator with name: " + idGen.getName()));
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, ExtendedMappings mappings) throws MappingException {
        Filters filtersAnn;
        RootClass persistentClass;
        boolean hasJoinedColumns;
        InheritanceState superEntityState;
        PersistentClass superEntity;
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        AnnotatedClassType classType = mappings.getClassType(clazzToProcess);
        if (AnnotatedClassType.EMBEDDABLE_SUPERCLASS.equals((Object)classType) || AnnotatedClassType.NONE.equals((Object)classType) || AnnotatedClassType.EMBEDDABLE.equals((Object)classType)) {
            return;
        }
        if (!classType.equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have a @javax.persistence.Entity, @javax.persistence.Embeddable or @javax.persistence.EmbeddedSuperclass annotation: " + clazzToProcess.getName());
        }
        XClass annotatedClass = clazzToProcess;
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding entity from annotated class: " + clazzToProcess.getName()));
        }
        PersistentClass persistentClass2 = superEntity = (superEntityState = InheritanceState.getSuperEntityInheritanceState(clazzToProcess, inheritanceStatePerClass)) != null ? mappings.getClass(superEntityState.clazz.getName()) : null;
        if (superEntity == null && inheritanceState.hasParents) {
            throw new AssertionFailure("Subclass has to be binded after it's mother class: " + superEntityState.clazz.getName());
        }
        AnnotationBinder.bindQueries(annotatedClass, mappings);
        AnnotationBinder.bindFilterDefs(annotatedClass, mappings);
        AnnotationBinder.bindTypeDefs(annotatedClass, mappings);
        String schema = ANNOTATION_STRING_DEFAULT;
        String table = ANNOTATION_STRING_DEFAULT;
        String catalog = ANNOTATION_STRING_DEFAULT;
        String discrimValue = null;
        List<Object> uniqueConstraints = new ArrayList();
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        Ejb3JoinColumn[] inheritanceJoinedColumns = null;
        if (annotatedClass.isAnnotationPresent(Table.class)) {
            Table tabAnn = annotatedClass.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            uniqueConstraints = TableBinder.buildUniqueConstraints(tabAnn.uniqueConstraints());
        }
        boolean bl = hasJoinedColumns = inheritanceState.hasParents && InheritanceType.JOINED.equals((Object)inheritanceState.type);
        if (hasJoinedColumns) {
            boolean explicitInheritanceJoinedColumns;
            PrimaryKeyJoinColumns jcsAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumns.class);
            boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
            if (explicitInheritanceJoinedColumns) {
                int nbrOfInhJoinedColumns = jcsAnn.value().length;
                inheritanceJoinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                    PrimaryKeyJoinColumn jcAnn = jcsAnn.value()[colIndex];
                    inheritanceJoinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), null, null, mappings);
                }
            } else {
                PrimaryKeyJoinColumn jcAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumn.class);
                inheritanceJoinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), null, null, mappings)};
            }
            log.debug((Object)"Subclass joined column(s) created");
        } else if (annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumns.class) || annotatedClass.isAnnotationPresent(PrimaryKeyJoinColumn.class)) {
            log.warn((Object)"Root entity should not hold an PrimaryKeyJoinColum(s), will be ignored");
        }
        if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            Inheritance inhAnn = annotatedClass.getAnnotation(Inheritance.class);
            DiscriminatorColumn discAnn = annotatedClass.getAnnotation(DiscriminatorColumn.class);
            DiscriminatorType discriminatorType = discAnn != null ? discAnn.discriminatorType() : DiscriminatorType.STRING;
            DiscriminatorFormula discFormulaAnn = annotatedClass.getAnnotation(DiscriminatorFormula.class);
            if (!inheritanceState.hasParents) {
                discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(discriminatorType, discAnn, discFormulaAnn, mappings);
            }
            if (discAnn != null && inheritanceState.hasParents) {
                log.warn((Object)("Discriminator column has to be defined in the root entity, it will be ignored in subclass: " + clazzToProcess.getName()));
            }
            String string = discrimValue = annotatedClass.isAnnotationPresent(DiscriminatorValue.class) ? annotatedClass.getAnnotation(DiscriminatorValue.class).value() : null;
        }
        if (!inheritanceState.hasParents) {
            persistentClass = new RootClass();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            persistentClass = new SingleTableSubclass(superEntity);
        } else if (InheritanceType.JOINED.equals((Object)inheritanceState.type)) {
            persistentClass = new JoinedSubclass(superEntity);
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type)) {
            persistentClass = new UnionSubclass(superEntity);
        } else {
            throw new AssertionFailure("Unknown inheritance type: " + inheritanceState.type);
        }
        Proxy proxyAnn = annotatedClass.getAnnotation(Proxy.class);
        BatchSize sizeAnn = annotatedClass.getAnnotation(BatchSize.class);
        Where whereAnn = annotatedClass.getAnnotation(Where.class);
        Entity entityAnn = annotatedClass.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
        Cache cacheAnn = annotatedClass.getAnnotation(Cache.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, clazzToProcess, (PersistentClass)persistentClass, mappings);
        entityBinder.setDiscriminatorValue(discrimValue);
        entityBinder.setBatchSize(sizeAnn);
        entityBinder.setProxy(proxyAnn);
        entityBinder.setWhere(whereAnn);
        entityBinder.setCache(cacheAnn);
        entityBinder.setInheritanceState(inheritanceState);
        Filter filterAnn = annotatedClass.getAnnotation(Filter.class);
        if (filterAnn != null) {
            entityBinder.addFilter(filterAnn.name(), filterAnn.condition());
        }
        if ((filtersAnn = annotatedClass.getAnnotation(Filters.class)) != null) {
            for (Filter filter : filtersAnn.value()) {
                entityBinder.addFilter(filter.name(), filter.condition());
            }
        }
        entityBinder.bindEntity();
        if (inheritanceState.hasTable()) {
            Check checkAnn = annotatedClass.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            entityBinder.bindTable(schema, catalog, table, uniqueConstraints, constraints, inheritanceState.hasDenormalizedTable() ? superEntity.getTable() : null);
        }
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder(clazzToProcess, (PersistentClass)persistentClass, entityBinder.getSecondaryTables());
        SecondaryTable secTabAnn = annotatedClass.getAnnotation(SecondaryTable.class);
        SecondaryTables secTabsAnn = annotatedClass.getAnnotation(SecondaryTables.class);
        PrimaryKeyJoinColumn joinColAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumn.class);
        PrimaryKeyJoinColumns joinColsAnn = annotatedClass.getAnnotation(PrimaryKeyJoinColumns.class);
        entityBinder.firstLevelSecondaryTablesBinding(secTabAnn, secTabsAnn, joinColAnn, joinColsAnn);
        OnDelete onDeleteAnn = annotatedClass.getAnnotation(OnDelete.class);
        boolean onDeleteAppropriate = false;
        if (InheritanceType.JOINED.equals((Object)inheritanceState.type) && inheritanceState.hasParents) {
            onDeleteAppropriate = true;
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
            }
            DependantValue key = new DependantValue(jsc.getTable(), jsc.getIdentifier());
            jsc.setKey((KeyValue)key);
            if (onDeleteAnn != null) {
                key.setCascadeDeleteEnabled(OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action()));
            } else {
                key.setCascadeDeleteEnabled(false);
            }
            TableBinder.bindFk(jsc.getSuperclass(), (PersistentClass)jsc, inheritanceJoinedColumns, (SimpleValue)key, false, mappings);
            jsc.createPrimaryKey();
            jsc.createForeignKey();
        } else if (InheritanceType.SINGLE_TABLE.equals((Object)inheritanceState.type)) {
            if (inheritanceState.hasParents) {
                if (persistentClass.getEntityPersisterClass() == null) {
                    persistentClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
                }
            } else if (inheritanceState.hasSons || !discriminatorColumn.isImplicit()) {
                AnnotationBinder.bindDiscriminatorToPersistentClass(persistentClass, discriminatorColumn, entityBinder.getSecondaryTables(), propertyHolder);
                entityBinder.bindDiscriminatorValue();
            }
        } else if (InheritanceType.TABLE_PER_CLASS.equals((Object)inheritanceState.type) && inheritanceState.hasParents && persistentClass.getEntityPersisterClass() == null) {
            persistentClass.getRootClass().setEntityPersisterClass(UnionSubclassEntityPersister.class);
        }
        if (onDeleteAnn != null && !onDeleteAppropriate) {
            log.warn((Object)("Inapropriate use of @OnDelete on entity, annotation ignored: " + propertyHolder.getEntityName()));
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators(annotatedClass, mappings);
        List<PropertyData> elements = AnnotationBinder.getElementsToProcess(clazzToProcess, inheritanceStatePerClass, propertyHolder, entityBinder);
        if (elements == null) {
            throw new AnnotationException("No identifier specified for entity: " + propertyHolder.getEntityName());
        }
        boolean subclassAndSingleTableStrategy = inheritanceState.type == InheritanceType.SINGLE_TABLE && inheritanceState.hasParents;
        HashSet<String> idProperties = new HashSet<String>();
        IdClass idClass = null;
        if (!inheritanceState.hasParents) {
            XClass current = inheritanceState.clazz;
            InheritanceState state = inheritanceState;
            do {
                if (!(current = state.clazz).isAnnotationPresent(IdClass.class)) continue;
                idClass = current.getAnnotation(IdClass.class);
                break;
            } while ((state = InheritanceState.getSuperclassInheritanceState(current, inheritanceStatePerClass)) != null);
        }
        if (idClass != null) {
            XClass compositeClass = ReflectionManager.INSTANCE.toXClass(idClass.value());
            boolean isComponent = true;
            boolean propertyAnnotated = entityBinder.isPropertyAnnotated(compositeClass);
            String propertyAccessor = entityBinder.getPropertyAccessor(compositeClass);
            String generatorType = "assigned";
            String generator = ANNOTATION_STRING_DEFAULT;
            PropertyPreloadedData inferredData = new PropertyPreloadedData(entityBinder.getPropertyAccessor(), "id", compositeClass);
            HashMap<String, IdGenerator> localGenerators = new HashMap<String, IdGenerator>();
            AnnotationBinder.bindId(generatorType, generator, inferredData, null, propertyHolder, localGenerators, isComponent, propertyAnnotated, propertyAccessor, entityBinder, null, true, false, mappings);
            inferredData = new PropertyPreloadedData(propertyAccessor, "_identifierMapper", compositeClass);
            Component mapper = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAnnotated, propertyAccessor, false, entityBinder, true, true, mappings);
            persistentClass.setIdentifierMapper(mapper);
            Property property = new Property();
            property.setName("_identifierMapper");
            property.setNodeName("id");
            property.setUpdateable(false);
            property.setInsertable(false);
            property.setValue((Value)mapper);
            property.setPropertyAccessorName("embedded");
            persistentClass.addProperty(property);
            entityBinder.setIgnoreIdAnnotations(true);
            Iterator properties = mapper.getPropertyIterator();
            while (properties.hasNext()) {
                idProperties.add(((Property)properties.next()).getName());
            }
        }
        HashSet missingIdProperties = new HashSet(idProperties);
        for (PropertyData propertyAnnotatedElement : elements) {
            String propertyName = propertyAnnotatedElement.getPropertyName();
            if (!idProperties.contains(propertyName)) {
                AnnotationBinder.processElementAnnotations(propertyHolder, subclassAndSingleTableStrategy ? Nullability.FORCED_NULL : Nullability.NO_CONSTRAINT, propertyAnnotatedElement.getProperty(), propertyAnnotatedElement, classGenerators, entityBinder, false, false, entityBinder.getPropertyAccessor(), mappings);
                continue;
            }
            missingIdProperties.remove(propertyName);
        }
        if (missingIdProperties.size() != 0) {
            StringBuilder missings = new StringBuilder();
            for (String property : missingIdProperties) {
                missings.append(property).append(", ");
            }
            throw new AnnotationException("Unable to find properties (" + missings.substring(0, missings.length() - 2) + ") in entity annotated with @IdClass:" + persistentClass.getEntityName());
        }
        if (!inheritanceState.hasParents) {
            persistentClass.createPrimaryKey();
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass((PersistentClass)persistentClass);
        entityBinder.finalSecondaryTableBinding(propertyHolder);
        entityBinder.addIndexes(annotatedClass.getAnnotation(org.hibernate.annotations.Table.class));
        entityBinder.addIndexes(annotatedClass.getAnnotation(Tables.class));
    }

    private static List<PropertyData> getElementsToProcess(XClass clazzToProcess, Map<XClass, InheritanceState> inheritanceStatePerClass, PropertyHolder propertyHolder, EntityBinder entityBinder) {
        boolean currentHasIdentifier;
        InheritanceState state;
        XClass clazz;
        int index;
        InheritanceState inheritanceState = inheritanceStatePerClass.get(clazzToProcess);
        List<XClass> classesToProcess = AnnotationBinder.orderClassesToBeProcessed(clazzToProcess, inheritanceStatePerClass, inheritanceState);
        ArrayList<PropertyData> elements = new ArrayList<PropertyData>();
        int deep = classesToProcess.size();
        boolean hasIdentifier = false;
        assert (!inheritanceState.isEmbeddableSuperclass);
        Boolean isExplicitPropertyAnnotated = null;
        String explicitAccessType = null;
        if (inheritanceState.hasParents) {
            InheritanceState superEntityState = InheritanceState.getSuperEntityInheritanceState(clazzToProcess, inheritanceStatePerClass);
            isExplicitPropertyAnnotated = superEntityState != null ? superEntityState.isPropertyAnnotated : null;
            explicitAccessType = superEntityState != null ? superEntityState.accessType : null;
        } else {
            AccessType access = clazzToProcess.getAnnotation(AccessType.class);
            String string = explicitAccessType = access != null ? access.value() : null;
            if ("property".equals(explicitAccessType)) {
                isExplicitPropertyAnnotated = Boolean.TRUE;
            } else if ("field".equals(explicitAccessType)) {
                isExplicitPropertyAnnotated = Boolean.FALSE;
            }
        }
        Boolean isPropertyAnnotated = isExplicitPropertyAnnotated == null ? Boolean.TRUE : isExplicitPropertyAnnotated;
        String accessType = explicitAccessType != null ? explicitAccessType : "property";
        for (index = 0; index < deep; ++index) {
            clazz = classesToProcess.get(index);
            state = inheritanceStatePerClass.get(clazz);
            currentHasIdentifier = AnnotationBinder.addElementsOfAClass(elements, propertyHolder, isPropertyAnnotated, accessType, clazz);
            hasIdentifier = hasIdentifier || currentHasIdentifier;
        }
        if (!hasIdentifier && !inheritanceState.hasParents) {
            if (isExplicitPropertyAnnotated != null) {
                return null;
            }
            isPropertyAnnotated = isPropertyAnnotated == false;
            accessType = "field";
            elements.clear();
            for (index = 0; index < deep; ++index) {
                clazz = classesToProcess.get(index);
                state = inheritanceStatePerClass.get(clazz);
                currentHasIdentifier = AnnotationBinder.addElementsOfAClass(elements, propertyHolder, isPropertyAnnotated, accessType, clazz);
                hasIdentifier = hasIdentifier || currentHasIdentifier;
            }
        }
        entityBinder.setPropertyAnnotated(isPropertyAnnotated);
        entityBinder.setPropertyAccessor(accessType);
        inheritanceState.isPropertyAnnotated = isPropertyAnnotated;
        inheritanceState.accessType = accessType;
        return hasIdentifier || inheritanceState.hasParents ? elements : null;
    }

    private static List<XClass> orderClassesToBeProcessed(XClass annotatedClass, Map<XClass, InheritanceState> inheritanceStatePerClass, InheritanceState inheritanceState) {
        InheritanceState superclassState;
        ArrayList<XClass> classesToProcess = new ArrayList<XClass>();
        XClass currentClassInHierarchy = annotatedClass;
        do {
            classesToProcess.add(0, currentClassInHierarchy);
            XClass superClass = currentClassInHierarchy;
            do {
                superClass = superClass.getSuperclass();
                superclassState = inheritanceStatePerClass.get(superClass);
            } while (!ReflectionManager.INSTANCE.equals(superClass, Object.class) && superclassState == null);
            currentClassInHierarchy = superClass;
        } while (superclassState != null && superclassState.isEmbeddableSuperclass);
        return classesToProcess;
    }

    private static void bindFilterDefs(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        FilterDef defAnn = annotatedElement.getAnnotation(FilterDef.class);
        FilterDefs defsAnn = annotatedElement.getAnnotation(FilterDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindFilterDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (FilterDef def : defsAnn.value()) {
                AnnotationBinder.bindFilterDef(def, mappings);
            }
        }
    }

    private static void bindFilterDef(FilterDef defAnn, ExtendedMappings mappings) {
        HashMap<String, Type> params = new HashMap<String, Type>();
        for (ParamDef param : defAnn.parameters()) {
            params.put(param.name(), TypeFactory.heuristicType((String)param.type()));
        }
        FilterDefinition def = new FilterDefinition(defAnn.name(), defAnn.defaultCondition(), params);
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding filter definition: " + def.getFilterName()));
        }
        mappings.addFilterDefinition(def);
    }

    private static void bindTypeDefs(XAnnotatedElement annotatedElement, ExtendedMappings mappings) {
        TypeDef defAnn = annotatedElement.getAnnotation(TypeDef.class);
        TypeDefs defsAnn = annotatedElement.getAnnotation(TypeDefs.class);
        if (defAnn != null) {
            AnnotationBinder.bindTypeDef(defAnn, mappings);
        }
        if (defsAnn != null) {
            for (TypeDef def : defsAnn.value()) {
                AnnotationBinder.bindTypeDef(def, mappings);
            }
        }
    }

    private static void bindTypeDef(TypeDef defAnn, ExtendedMappings mappings) {
        Properties params = new Properties();
        for (Parameter param : defAnn.parameters()) {
            params.setProperty(param.name(), param.value());
        }
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding type definition: " + defAnn.name()));
        }
        mappings.addTypeDef(defAnn.name(), defAnn.typeClass().getName(), params);
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                throw new AssertionFailure("discriminator column should have been built");
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(rootClass.getTable());
            rootClass.setDiscriminator((Value)discrim);
            discriminatorColumn.linkWithValue(discrim);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            log.debug((Object)("Setting discriminator for entity " + rootClass.getEntityName()));
        }
    }

    private static boolean addElementsOfAClass(List<PropertyData> elements, PropertyHolder propertyHolder, boolean isPropertyAnnotated, String propertyAccessor, XClass annotatedClass) {
        boolean hasIdentifier = false;
        AccessType access = annotatedClass.getAnnotation(AccessType.class);
        String localPropertyAccessor = access != null ? access.value() : null;
        String accessType = null;
        if ("property".equals(localPropertyAccessor) || "field".equals(localPropertyAccessor)) {
            accessType = localPropertyAccessor;
        } else {
            if (localPropertyAccessor == null) {
                localPropertyAccessor = propertyAccessor;
            }
            accessType = isPropertyAnnotated ? "property" : "field";
        }
        log.debug((Object)("Processing " + propertyHolder.getEntityName() + " " + accessType + " annotation"));
        List<XProperty> properties = annotatedClass.getDeclaredProperties(accessType);
        for (XProperty p : properties) {
            if (!p.isTypeResolved() && !AnnotationBinder.hasExplicitTargetEntity(p)) {
                throw new IllegalStateException("Property " + p + " has an unbound type and no explicit target entity.");
            }
            boolean currentHasIdentifier = AnnotationBinder.addProperty(p, elements, localPropertyAccessor);
            hasIdentifier = hasIdentifier || currentHasIdentifier;
        }
        return hasIdentifier;
    }

    private static boolean hasExplicitTargetEntity(XProperty p) {
        if (p.isAnnotationPresent(OneToOne.class) && !p.getAnnotation(OneToOne.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(OneToMany.class) && !p.getAnnotation(OneToMany.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        if (p.isAnnotationPresent(javax.persistence.ManyToOne.class) && !p.getAnnotation(javax.persistence.ManyToOne.class).targetEntity().equals(Void.TYPE)) {
            return true;
        }
        return p.isAnnotationPresent(ManyToMany.class) && !p.getAnnotation(ManyToMany.class).targetEntity().equals(Void.TYPE);
    }

    private static boolean addProperty(XProperty property, List<PropertyData> annElts, String propertyAccessor) {
        boolean hasIdentifier = false;
        PropertyInferredData propertyAnnotatedElement = new PropertyInferredData(property, propertyAccessor);
        if (!AnnotationBinder.mustBeSkipped(propertyAnnotatedElement.getProperty())) {
            XProperty element = propertyAnnotatedElement.getProperty();
            if (element.isAnnotationPresent(Id.class) || element.isAnnotationPresent(EmbeddedId.class)) {
                annElts.add(0, propertyAnnotatedElement);
                hasIdentifier = true;
            } else {
                annElts.add(propertyAnnotatedElement);
                hasIdentifier = false;
            }
        }
        return hasIdentifier;
    }

    private static boolean mustBeSkipped(XProperty property) {
        return property.isAnnotationPresent(Transient.class) || ReflectionManager.INSTANCE.equals(property.getType(), InterceptFieldCallback.class);
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, Nullability nullability, XProperty property, PropertyData inferredData, HashMap<String, IdGenerator> classGenerators, EntityBinder entityBinder, boolean isIdentifierMapper, boolean isComponentEmbedded, String accessType, ExtendedMappings mappings) throws MappingException {
        Index index;
        String mappedBy;
        JoinColumns ann;
        int length;
        Ejb3Column[] columns = null;
        Ejb3JoinColumn[] joinColumns = null;
        if (log.isDebugEnabled()) {
            log.debug((Object)("Processing annotations of " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName()));
        }
        Object anns = null;
        if (property.isAnnotationPresent(JoinColumn.class)) {
            anns = new JoinColumn[]{property.getAnnotation(JoinColumn.class)};
        } else if (property.isAnnotationPresent(JoinColumns.class) && (length = ((JoinColumn[])(anns = (ann = property.getAnnotation(JoinColumns.class)).value())).length) == 0) {
            throw new AnnotationException("Cannot bind an empty @JoinColumns");
        }
        if (anns != null) {
            joinColumns = Ejb3JoinColumn.buildJoinColumns((JoinColumn[])anns, null, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
        }
        if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Formula.class)) {
            javax.persistence.Column ann2 = property.getAnnotation(javax.persistence.Column.class);
            Formula formulaAnn = property.getAnnotation(Formula.class);
            columns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann2}, formulaAnn, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        } else if (property.isAnnotationPresent(Columns.class)) {
            anns = property.getAnnotation(Columns.class);
            columns = Ejb3Column.buildColumnFromAnnotation(anns.columns(), null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        }
        if (joinColumns == null && (property.isAnnotationPresent(javax.persistence.ManyToOne.class) || property.isAnnotationPresent(OneToOne.class))) {
            if (property.isAnnotationPresent(JoinTable.class)) {
                JoinTable assocTable = property.getAnnotation(JoinTable.class);
                throw new NotYetImplementedException("association table on a single ended association is not yet supported");
            }
            OneToOne oneToOneAnn = property.getAnnotation(OneToOne.class);
            mappedBy = oneToOneAnn != null ? oneToOneAnn.mappedBy() : null;
            joinColumns = Ejb3JoinColumn.buildJoinColumns(null, mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
        } else if (joinColumns == null && (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(CollectionOfElements.class))) {
            OneToMany oneToMany = property.getAnnotation(OneToMany.class);
            mappedBy = oneToMany != null ? oneToMany.mappedBy() : ANNOTATION_STRING_DEFAULT;
            joinColumns = Ejb3JoinColumn.buildJoinColumns(null, mappedBy, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappings);
        }
        if (columns == null && !property.isAnnotationPresent(ManyToMany.class)) {
            columns = Ejb3Column.buildColumnFromAnnotation(null, null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
        }
        if ((index = property.getAnnotation(Index.class)) != null) {
            if (joinColumns != null) {
                for (Ejb3Column ejb3Column : joinColumns) {
                    ejb3Column.addIndex(index);
                }
            } else {
                for (Ejb3Column ejb3Column : columns) {
                    ejb3Column.addIndex(index);
                }
            }
        }
        if (nullability == Nullability.FORCED_NOT_NULL) {
            for (Ejb3Column ejb3Column : columns) {
                ejb3Column.forceNotNull();
            }
        }
        XClass returnedClass = inferredData.getClassOrElement();
        if (!entityBinder.isIgnoreIdAnnotations() && (property.isAnnotationPresent(Id.class) || property.isAnnotationPresent(EmbeddedId.class))) {
            String generator;
            if (isIdentifierMapper) {
                throw new AnnotationException("@IdClass class should not have @Id nor @EmbeddedId proeperties");
            }
            log.debug((Object)(inferredData.getPropertyName() + " is an id"));
            HashMap localGenerators = (HashMap)classGenerators.clone();
            localGenerators.putAll(AnnotationBinder.buildLocalGenerators(property, mappings));
            Embeddable embeddableAnn = returnedClass.getAnnotation(Embeddable.class);
            boolean bl = embeddableAnn != null || property.isAnnotationPresent(EmbeddedId.class);
            boolean propertyAnnotated = entityBinder.isPropertyAnnotated(returnedClass);
            String propertyAccessor = entityBinder.getPropertyAccessor(returnedClass);
            GeneratedValue generatedValue = property.getAnnotation(GeneratedValue.class);
            String generatorType = generatedValue != null ? AnnotationBinder.generatorType(generatedValue.strategy()) : "assigned";
            String string = generator = generatedValue != null ? generatedValue.generator() : ANNOTATION_STRING_DEFAULT;
            if (bl) {
                generatorType = "assigned";
            }
            org.hibernate.annotations.Type typeAnn = property.getAnnotation(org.hibernate.annotations.Type.class);
            AnnotationBinder.bindId(generatorType, generator, inferredData, columns, propertyHolder, localGenerators, bl, propertyAnnotated, propertyAccessor, entityBinder, typeAnn, false, isIdentifierMapper, mappings);
            if (log.isDebugEnabled()) {
                log.debug((Object)("Bind " + (bl ? "@EmbeddedId" : "@Id") + " on " + inferredData.getPropertyName()));
            }
        } else if (property.isAnnotationPresent(Version.class)) {
            if (isIdentifierMapper) {
                throw new AnnotationException("@IdClass class should not have @Version property");
            }
            if (!(propertyHolder.getPersistentClass() instanceof RootClass)) {
                throw new AnnotationException("Unable to define/override @Version on a subclass: " + propertyHolder.getEntityName());
            }
            log.debug((Object)(inferredData.getPropertyName() + " is a version property"));
            RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
            boolean lazy = false;
            PropertyBinder propertyBinder = new PropertyBinder();
            propertyBinder.setName(inferredData.getPropertyName());
            propertyBinder.setReturnedClassName(inferredData.getTypeName());
            propertyBinder.setLazy(lazy);
            propertyBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
            propertyBinder.setColumns(columns);
            propertyBinder.setHolder(propertyHolder);
            propertyBinder.setProperty(property);
            propertyBinder.setReturnedClass(inferredData.getPropertyClass());
            propertyBinder.setMappings(mappings);
            Property prop = propertyBinder.bind();
            rootClass.setVersion(prop);
            SimpleValue simpleValue = (SimpleValue)prop.getValue();
            if (!simpleValue.isTypeSpecified()) {
                simpleValue.setTypeName("integer");
            }
            simpleValue.setNullValue("undefined");
            rootClass.setOptimisticLockMode(0);
            log.debug((Object)("Version name: " + rootClass.getVersion().getName() + ", unsavedValue: " + ((SimpleValue)rootClass.getVersion().getValue()).getNullValue()));
        } else if (property.isAnnotationPresent(javax.persistence.ManyToOne.class)) {
            javax.persistence.ManyToOne ann3 = property.getAnnotation(javax.persistence.ManyToOne.class);
            Cascade hibernateCascade = property.getAnnotation(Cascade.class);
            NotFound notFound = property.getAnnotation(NotFound.class);
            boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
            OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
            boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
            AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann3.cascade(), hibernateCascade), joinColumns, ann3.optional(), AnnotationBinder.getFetchMode(ann3.fetch()), ignoreNotFound, onDeleteCascade, inferredData.getPropertyName(), inferredData.getClassOrElementName(), ReflectionManager.INSTANCE.toXClass(ann3.targetEntity()), inferredData.getDefaultAccess(), propertyHolder, false, isIdentifierMapper, mappings);
        } else if (property.isAnnotationPresent(OneToOne.class)) {
            OneToOne ann4 = property.getAnnotation(OneToOne.class);
            boolean trueOneToOne = property.isAnnotationPresent(PrimaryKeyJoinColumn.class) || property.isAnnotationPresent(PrimaryKeyJoinColumns.class);
            Cascade cascade = property.getAnnotation(Cascade.class);
            NotFound notFound = property.getAnnotation(NotFound.class);
            boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
            OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
            boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
            AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann4.cascade(), cascade), joinColumns, ann4.optional(), AnnotationBinder.getFetchMode(ann4.fetch()), ignoreNotFound, onDeleteCascade, inferredData.getPropertyName(), inferredData.getClassOrElementName(), ReflectionManager.INSTANCE.toXClass(ann4.targetEntity()), inferredData.getDefaultAccess(), propertyHolder, ann4.mappedBy(), trueOneToOne, isIdentifierMapper, mappings);
        } else if (property.isAnnotationPresent(OneToMany.class) || property.isAnnotationPresent(ManyToMany.class) || property.isAnnotationPresent(CollectionOfElements.class)) {
            Filters filtersAnn;
            OneToMany oneToManyAnn = property.getAnnotation(OneToMany.class);
            ManyToMany manyToManyAnn = property.getAnnotation(ManyToMany.class);
            CollectionOfElements collectionOfElements = property.getAnnotation(CollectionOfElements.class);
            org.hibernate.annotations.IndexColumn indexAnn = property.getAnnotation(org.hibernate.annotations.IndexColumn.class);
            JoinTable assocTable = property.getAnnotation(JoinTable.class);
            IndexColumn indexColumn = IndexColumn.buildColumnFromAnnotation(indexAnn, propertyHolder, inferredData, mappings);
            CollectionBinder collectionBinder = CollectionBinder.getCollectionBinder(propertyHolder.getEntityName(), inferredData, !indexColumn.isImplicit());
            collectionBinder.setIndexColumn(indexColumn);
            MapKey mapKeyAnn = property.getAnnotation(MapKey.class);
            collectionBinder.setMapKey(mapKeyAnn);
            collectionBinder.setPropertyName(inferredData.getPropertyName());
            BatchSize batchAnn = property.getAnnotation(BatchSize.class);
            collectionBinder.setBatchSize(batchAnn);
            OrderBy ejb3OrderByAnn = property.getAnnotation(OrderBy.class);
            org.hibernate.annotations.OrderBy orderByAnn = property.getAnnotation(org.hibernate.annotations.OrderBy.class);
            collectionBinder.setEjb3OrderBy(ejb3OrderByAnn);
            collectionBinder.setSqlOrderBy(orderByAnn);
            Sort sortAnn = property.getAnnotation(Sort.class);
            collectionBinder.setSort(sortAnn);
            Cache cachAnn = property.getAnnotation(Cache.class);
            collectionBinder.setCache(cachAnn);
            Filter filterAnn = property.getAnnotation(Filter.class);
            if (filterAnn != null) {
                collectionBinder.addFilter(filterAnn.name(), filterAnn.condition());
            }
            if ((filtersAnn = property.getAnnotation(Filters.class)) != null) {
                for (Filter filter : filtersAnn.value()) {
                    collectionBinder.addFilter(filter.name(), filter.condition());
                }
            }
            collectionBinder.setPropertyHolder(propertyHolder);
            Where whereAnn = property.getAnnotation(Where.class);
            collectionBinder.setWhere(whereAnn);
            Cascade hibernateCascade = property.getAnnotation(Cascade.class);
            NotFound notFound = property.getAnnotation(NotFound.class);
            boolean ignoreNotFound = notFound != null && notFound.action().equals((Object)NotFoundAction.IGNORE);
            collectionBinder.setIgnoreNotFound(ignoreNotFound);
            collectionBinder.setCollectionType(inferredData.getProperty().getElementClass());
            collectionBinder.setMappings(mappings);
            collectionBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
            Ejb3Column[] elementColumns = null;
            if (property.isAnnotationPresent(javax.persistence.Column.class) || property.isAnnotationPresent(Formula.class)) {
                javax.persistence.Column ann5 = property.getAnnotation(javax.persistence.Column.class);
                Formula formulaAnn = property.getAnnotation(Formula.class);
                elementColumns = Ejb3Column.buildColumnFromAnnotation(new javax.persistence.Column[]{ann5}, formulaAnn, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            } else if (property.isAnnotationPresent(Columns.class)) {
                Columns anns2 = property.getAnnotation(Columns.class);
                elementColumns = Ejb3Column.buildColumnFromAnnotation(anns2.columns(), null, nullability, propertyHolder, inferredData, entityBinder.getSecondaryTables(), mappings);
            }
            collectionBinder.setEmbedded(property.isAnnotationPresent(Embedded.class));
            collectionBinder.setElementColumns(elementColumns);
            collectionBinder.setProperty(property);
            if (oneToManyAnn != null && manyToManyAnn != null) {
                throw new AnnotationException("@OneToMany and @ManyToMany on the same property is not allowed: " + propertyHolder.getEntityName() + "." + inferredData.getPropertyName());
            }
            String mappedBy2 = null;
            if (oneToManyAnn != null) {
                for (Ejb3JoinColumn column : joinColumns) {
                    if (!column.isSecondary()) continue;
                    throw new NotYetImplementedException("Collections having FK in secondary table");
                }
                collectionBinder.setFkJoinColumns(joinColumns);
                mappedBy2 = oneToManyAnn.mappedBy();
                collectionBinder.setTargetEntity(ReflectionManager.INSTANCE.toXClass(oneToManyAnn.targetEntity()));
                collectionBinder.setFetchType(oneToManyAnn.fetch());
                collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(oneToManyAnn.cascade(), hibernateCascade));
                collectionBinder.setOneToMany(true);
            } else if (collectionOfElements != null) {
                for (Ejb3JoinColumn column : joinColumns) {
                    if (!column.isSecondary()) continue;
                    throw new NotYetImplementedException("Collections having FK in secondary table");
                }
                collectionBinder.setFkJoinColumns(joinColumns);
                mappedBy2 = ANNOTATION_STRING_DEFAULT;
                collectionBinder.setTargetEntity(ReflectionManager.INSTANCE.toXClass(collectionOfElements.targetElement()));
                collectionBinder.setFetchType(collectionOfElements.fetch());
                collectionBinder.setOneToMany(true);
            } else if (manyToManyAnn != null) {
                mappedBy2 = manyToManyAnn.mappedBy();
                collectionBinder.setTargetEntity(ReflectionManager.INSTANCE.toXClass(manyToManyAnn.targetEntity()));
                collectionBinder.setFetchType(manyToManyAnn.fetch());
                collectionBinder.setCascadeStrategy(AnnotationBinder.getCascadeStrategy(manyToManyAnn.cascade(), hibernateCascade));
                collectionBinder.setOneToMany(false);
            }
            collectionBinder.setMappedBy(mappedBy2);
            AnnotationBinder.bindJoinedTableAssociation(assocTable, mappings, entityBinder, collectionBinder, propertyHolder, inferredData, mappedBy2);
            OnDelete onDeleteAnn = property.getAnnotation(OnDelete.class);
            boolean onDeleteCascade = onDeleteAnn != null && OnDeleteAction.CASCADE.equals((Object)onDeleteAnn.action());
            collectionBinder.setCascadeDeleteEnabled(onDeleteCascade);
            if (isIdentifierMapper) {
                collectionBinder.setInsertable(false);
                collectionBinder.setUpdatable(false);
            }
            collectionBinder.bind();
        } else {
            boolean isComponent = false;
            Embeddable embeddableAnn = returnedClass.getAnnotation(Embeddable.class);
            Embedded embedded = property.getAnnotation(Embedded.class);
            boolean bl = isComponent = embedded != null || embeddableAnn != null;
            if (isComponent) {
                boolean propertyAnnotated = entityBinder.isPropertyAnnotated(property);
                String propertyAccessor = entityBinder.getPropertyAccessor(property);
                AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAnnotated, propertyAccessor, entityBinder, isIdentifierMapper, mappings, isComponentEmbedded);
            } else {
                boolean optional = true;
                boolean lazy = false;
                if (property.isAnnotationPresent(Basic.class)) {
                    Basic ann6 = property.getAnnotation(Basic.class);
                    optional = ann6.optional();
                    boolean bl2 = lazy = ann6.fetch() == FetchType.LAZY;
                }
                if (!optional && nullability != Nullability.FORCED_NULL) {
                    for (Ejb3Column col : columns) {
                        col.forceNotNull();
                    }
                }
                PropertyBinder propBinder = new PropertyBinder();
                propBinder.setName(inferredData.getPropertyName());
                propBinder.setReturnedClassName(inferredData.getTypeName());
                propBinder.setLazy(lazy);
                propBinder.setPropertyAccessorName(inferredData.getDefaultAccess());
                propBinder.setColumns(columns);
                propBinder.setHolder(propertyHolder);
                propBinder.setProperty(property);
                propBinder.setReturnedClass(inferredData.getPropertyClass());
                propBinder.setMappings(mappings);
                if (isIdentifierMapper) {
                    propBinder.setInsertable(false);
                    propBinder.setUpdatable(false);
                }
                propBinder.bind();
            }
        }
    }

    private static void bindJoinedTableAssociation(JoinTable joinTableAnn, ExtendedMappings mappings, EntityBinder entityBinder, CollectionBinder collectionBinder, PropertyHolder propertyHolder, PropertyData inferredData, String mappedBy) {
        JoinColumn[] annInverseJoins;
        JoinColumn[] annJoins;
        TableBinder associationTableBinder = new TableBinder();
        if (joinTableAnn != null) {
            collectionBinder.setExplicitAssociationTable(true);
            if (!AnnotationBinder.isDefault(joinTableAnn.schema())) {
                associationTableBinder.setSchema(joinTableAnn.schema());
            }
            if (!AnnotationBinder.isDefault(joinTableAnn.catalog())) {
                associationTableBinder.setCatalog(joinTableAnn.catalog());
            }
            if (!AnnotationBinder.isDefault(joinTableAnn.name())) {
                associationTableBinder.setName(joinTableAnn.name());
            }
            associationTableBinder.setUniqueConstraints(joinTableAnn.uniqueConstraints());
            JoinColumn[] joins = joinTableAnn.joinColumns();
            annJoins = joins.length == 0 ? null : joins;
            JoinColumn[] inverseJoins = joinTableAnn.inverseJoinColumns();
            annInverseJoins = inverseJoins.length == 0 ? null : inverseJoins;
        } else {
            annJoins = null;
            annInverseJoins = null;
        }
        Ejb3JoinColumn[] joinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        Ejb3JoinColumn[] inverseJoinColumns = Ejb3JoinColumn.buildJoinTableJoinColumns(annInverseJoins, entityBinder.getSecondaryTables(), propertyHolder, inferredData.getPropertyName(), mappedBy, mappings);
        associationTableBinder.setMappings(mappings);
        collectionBinder.setTableBinder(associationTableBinder);
        collectionBinder.setJoinColumns(joinColumns);
        collectionBinder.setInverseJoinColumns(inverseJoinColumns);
    }

    private static void bindComponent(PropertyData inferredData, PropertyHolder propertyHolder, boolean propertyAnnotated, String propertyAccessor, EntityBinder entityBinder, boolean isIdentifierMapper, ExtendedMappings mappings, boolean isComponentEmbedded) {
        Component comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAnnotated, propertyAccessor, true, entityBinder, isComponentEmbedded, isIdentifierMapper, mappings);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(inferredData.getPropertyName());
        binder.setValue((Value)comp);
        binder.setPropertyAccessorName(inferredData.getDefaultAccess());
        Property prop = binder.make();
        propertyHolder.addProperty(prop);
    }

    public static Component fillComponent(PropertyHolder propertyHolder, PropertyData inferredData, boolean propertyAnnotated, String propertyAccessor, boolean isNullable, EntityBinder entityBinder, boolean isComponentEmbedded, boolean isIdentifierMapper, ExtendedMappings mappings) {
        Component comp = new Component(propertyHolder.getPersistentClass());
        comp.setEmbedded(isComponentEmbedded);
        comp.setTable(propertyHolder.getTable());
        if (!isIdentifierMapper) {
            comp.setComponentClassName(inferredData.getClassOrElementName());
        } else {
            comp.setComponentClassName(comp.getOwner().getClassName());
        }
        String subpath = StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName());
        log.debug((Object)("Binding component with path: " + subpath));
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, inferredData, propertyHolder);
        ArrayList<PropertyData> classElements = new ArrayList<PropertyData>();
        XClass returnedClassOrElement = inferredData.getClassOrElement();
        AnnotationBinder.addElementsOfAClass(classElements, subHolder, propertyAnnotated, propertyAccessor, returnedClassOrElement);
        for (XClass superClass = inferredData.getPropertyClass().getSuperclass(); superClass != null && superClass.isAnnotationPresent(MappedSuperclass.class); superClass = superClass.getSuperclass()) {
            AnnotationBinder.addElementsOfAClass(classElements, subHolder, entityBinder.isPropertyAnnotated(superClass), propertyAccessor, superClass);
        }
        for (PropertyData propertyAnnotatedElement : classElements) {
            AnnotationBinder.processElementAnnotations(subHolder, isNullable ? Nullability.NO_CONSTRAINT : Nullability.FORCED_NOT_NULL, propertyAnnotatedElement.getProperty(), propertyAnnotatedElement, new HashMap<String, IdGenerator>(), entityBinder, isIdentifierMapper, isComponentEmbedded, propertyAccessor, mappings);
        }
        return comp;
    }

    private static void bindId(String generatorType, String generatorName, PropertyData inferredData, Ejb3Column[] columns, PropertyHolder propertyHolder, Map<String, IdGenerator> localGenerators, boolean isComposite, boolean isPropertyAnnotated, String propertyAccessor, EntityBinder entityBinder, org.hibernate.annotations.Type typeAnn, boolean isEmbedded, boolean isIdentifierMapper, ExtendedMappings mappings) {
        Component id;
        String persistentClassName;
        PersistentClass persistentClass = propertyHolder.getPersistentClass();
        if (!(persistentClass instanceof RootClass)) {
            throw new AnnotationException("Unable to define/override @Id(s) on a subclass: " + propertyHolder.getEntityName());
        }
        RootClass rootClass = (RootClass)persistentClass;
        String string = persistentClassName = rootClass == null ? null : rootClass.getClassName();
        if (isComposite) {
            id = AnnotationBinder.fillComponent(propertyHolder, inferredData, isPropertyAnnotated, propertyAccessor, false, entityBinder, isEmbedded, isIdentifierMapper, mappings);
            id.setKey(true);
            if (!id.getColumnIterator().hasNext()) {
                throw new AnnotationException(id.getComponentClassName() + " has not persistent id property");
            }
        } else {
            for (Ejb3Column column : columns) {
                column.forceNotNull();
            }
            SimpleValueBinder value = new SimpleValueBinder();
            value.setPropertyName(inferredData.getPropertyName());
            value.setReturnedClassName(inferredData.getTypeName());
            value.setColumns(columns);
            value.setPersistentClassName(persistentClassName);
            value.setMappings(mappings);
            value.setExplicitType(typeAnn);
            id = value.make();
        }
        rootClass.setIdentifier((KeyValue)id);
        org.hibernate.mapping.Table table = id.getTable();
        table.setIdentifierValue((KeyValue)id);
        id.setIdentifierGeneratorStrategy(generatorType);
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        Iterator idColumnIterator = id.getColumnIterator();
        params.setProperty("target_column", ((Column)idColumnIterator.next()).getName());
        if (!AnnotationBinder.isDefault(generatorName)) {
            boolean avoidOverriding;
            IdGenerator gen = mappings.getGenerator(generatorName, localGenerators);
            if (gen == null) {
                throw new AnnotationException("Unknown Id.generator: " + generatorName);
            }
            String identifierGeneratorStrategy = gen.getIdentifierGeneratorStrategy();
            boolean bl = avoidOverriding = identifierGeneratorStrategy.equals("identity") || identifierGeneratorStrategy.equals("sequence") || identifierGeneratorStrategy.equals(MultipleHiLoPerTableGenerator.class.getName());
            if (!avoidOverriding) {
                id.setIdentifierGeneratorStrategy(identifierGeneratorStrategy);
            }
            for (Map.Entry<Object, Object> elt : gen.getParams().entrySet()) {
                params.setProperty((String)elt.getKey(), (String)elt.getValue());
            }
        }
        if (generatorType == "assigned") {
            id.setNullValue("undefined");
        }
        id.setIdentifierGeneratorProperties(params);
        if (isEmbedded) {
            rootClass.setEmbeddedIdentifier(inferredData.getPropertyClass() == null);
        } else {
            PropertyBinder binder = new PropertyBinder();
            binder.setName(inferredData.getPropertyName());
            binder.setValue((Value)id);
            binder.setPropertyAccessorName(inferredData.getDefaultAccess());
            Property prop = binder.make();
            rootClass.setIdentifierProperty(prop);
        }
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, boolean ignoreNotFound, boolean cascadeOnDelete, String propertyName, String returnedClassName, XClass targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, boolean unique, boolean isIdentifierMapper, ExtendedMappings mappings) {
        ManyToOne value = new ManyToOne(columns[0].getTable());
        if (AnnotationBinder.isDefault(targetEntity)) {
            value.setReferencedEntityName(returnedClassName);
        } else {
            value.setReferencedEntityName(targetEntity.getName());
        }
        value.setFetchMode(fetchMode);
        value.setIgnoreNotFound(ignoreNotFound);
        value.setCascadeDeleteEnabled(cascadeOnDelete);
        value.setLazy(fetchMode != FetchMode.JOIN);
        if (!optional) {
            for (Ejb3JoinColumn column : columns) {
                column.setNullable(false);
            }
        }
        value.setTypeName(returnedClassName);
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String path = propertyHolder.getPath() + "." + propertyName;
        mappings.addSecondPass(new FkSecondPass((Value)value, columns, !optional && unique, path, mappings));
        Ejb3Column.checkPropertyConsistency(columns, propertyHolder.getEntityName() + propertyName);
        PropertyBinder binder = new PropertyBinder();
        binder.setName(propertyName);
        binder.setValue((Value)value);
        if (isIdentifierMapper) {
            binder.setInsertable(false);
            binder.setInsertable(false);
        } else {
            binder.setInsertable(columns[0].isInsertable());
            binder.setUpdatable(columns[0].isUpdatable());
        }
        binder.setPropertyAccessorName(propertyAccessorName);
        binder.setCascade(cascadeStrategy);
        Property prop = binder.make();
        propertyHolder.addProperty(prop, columns);
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, boolean ignoreNotFound, boolean cascadeOnDelete, String propertyName, String returnedClassName, XClass targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, String mappedBy, boolean trueOneToOne, boolean isIdentifierMapper, ExtendedMappings mappings) {
        log.debug((Object)("Fetching " + propertyName + " with " + fetchMode));
        boolean mapToPK = true;
        if (!trueOneToOne) {
            Iterator idColumns = propertyHolder.getIdentifier().getColumnIterator();
            ArrayList<String> idColumnNames = new ArrayList<String>();
            while (idColumns.hasNext()) {
                Column currentColumn = (Column)idColumns.next();
                idColumnNames.add(currentColumn.getName());
            }
            for (Ejb3JoinColumn col : columns) {
                if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
                mapToPK = false;
                break;
            }
        }
        if (trueOneToOne || mapToPK || !AnnotationBinder.isDefault(mappedBy)) {
            org.hibernate.mapping.OneToOne value = new org.hibernate.mapping.OneToOne(propertyHolder.getTable(), propertyHolder.getPersistentClass());
            value.setPropertyName(propertyName);
            if (AnnotationBinder.isDefault(targetEntity)) {
                value.setReferencedEntityName(returnedClassName);
            } else {
                value.setReferencedEntityName(targetEntity.getName());
            }
            value.setFetchMode(fetchMode);
            value.setCascadeDeleteEnabled(cascadeOnDelete);
            value.setLazy(fetchMode != FetchMode.JOIN);
            if (!optional) {
                value.setConstrained(true);
            }
            value.setForeignKeyType(value.isConstrained() ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
            if (!AnnotationBinder.isDefault(mappedBy)) {
                mappings.addSecondPass(new ToOneMappedBySecondPass(mappedBy, (ToOne)value, propertyHolder.getEntityName(), propertyName, mappings));
            }
            PropertyBinder binder = new PropertyBinder();
            binder.setName(propertyName);
            binder.setValue((Value)value);
            binder.setCascade(cascadeStrategy);
            binder.setPropertyAccessorName(propertyAccessorName);
            Property prop = binder.make();
            prop.setCascade(cascadeStrategy);
            propertyHolder.addProperty(prop);
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, columns, optional, fetchMode, ignoreNotFound, cascadeOnDelete, propertyName, returnedClassName, targetEntity, propertyAccessorName, propertyHolder, true, isIdentifierMapper, mappings);
        }
    }

    private static String generatorType(GenerationType generatorEnum) {
        switch (generatorEnum) {
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return "native";
            }
            case TABLE: {
                return MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return "sequence";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }

    private static EnumSet<org.hibernate.annotations.CascadeType> convertToHibernateCascadeType(CascadeType[] ejbCascades) {
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = EnumSet.noneOf(org.hibernate.annotations.CascadeType.class);
        if (ejbCascades != null && ejbCascades.length > 0) {
            block7: for (CascadeType cascade : ejbCascades) {
                switch (cascade) {
                    case ALL: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.ALL);
                        continue block7;
                    }
                    case PERSIST: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.PERSIST);
                        continue block7;
                    }
                    case MERGE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.MERGE);
                        continue block7;
                    }
                    case REMOVE: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REMOVE);
                        continue block7;
                    }
                    case REFRESH: {
                        hibernateCascadeSet.add(org.hibernate.annotations.CascadeType.REFRESH);
                    }
                }
            }
        }
        return hibernateCascadeSet;
    }

    private static String getCascadeStrategy(CascadeType[] ejbCascades, Cascade hibernateCascadeAnnotation) {
        org.hibernate.annotations.CascadeType[] hibernateCascades;
        EnumSet<org.hibernate.annotations.CascadeType> hibernateCascadeSet = AnnotationBinder.convertToHibernateCascadeType(ejbCascades);
        org.hibernate.annotations.CascadeType[] cascadeTypeArray = hibernateCascades = hibernateCascadeAnnotation == null ? null : hibernateCascadeAnnotation.value();
        if (hibernateCascades != null && hibernateCascades.length > 0) {
            for (org.hibernate.annotations.CascadeType cascadeType : hibernateCascades) {
                hibernateCascadeSet.add(cascadeType);
            }
        }
        StringBuilder cascade = new StringBuilder();
        Iterator cascadeType = hibernateCascadeSet.iterator();
        while (cascadeType.hasNext()) {
            switch ((org.hibernate.annotations.CascadeType)((Object)cascadeType.next())) {
                case ALL: {
                    cascade.append(",").append("all");
                    break;
                }
                case SAVE_UPDATE: {
                    cascade.append(",").append("save-update");
                    break;
                }
                case PERSIST: {
                    cascade.append(",").append("persist");
                    break;
                }
                case MERGE: {
                    cascade.append(",").append("merge");
                    break;
                }
                case LOCK: {
                    cascade.append(",").append("lock");
                    break;
                }
                case REFRESH: {
                    cascade.append(",").append("refresh");
                    break;
                }
                case REPLICATE: {
                    cascade.append(",").append("replicate");
                    break;
                }
                case EVICT: {
                    cascade.append(",").append("evict");
                    break;
                }
                case DELETE: {
                    cascade.append(",").append("delete");
                    break;
                }
                case DELETE_ORPHAN: {
                    cascade.append(",").append("delete-orphan");
                    break;
                }
                case REMOVE: {
                    cascade.append(",").append("delete");
                }
            }
        }
        return cascade.length() > 0 ? cascade.substring(1) : "none";
    }

    private static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(XAnnotatedElement annElt, Mappings mappings) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        TableGenerator tabGen = annElt.getAnnotation(TableGenerator.class);
        SequenceGenerator seqGen = annElt.getAnnotation(SequenceGenerator.class);
        GenericGenerator genGen = annElt.getAnnotation(GenericGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)tabGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)seqGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        if (genGen != null) {
            idGen = AnnotationBinder.buildIdGenerator(genGen, mappings);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    public static boolean isDefault(String annotationString) {
        return ANNOTATION_STRING_DEFAULT.equals(annotationString);
    }

    public static boolean isDefault(XClass clazz) {
        return ReflectionManager.INSTANCE.equals(clazz, (Class)Void.TYPE);
    }

    public static Map<XClass, InheritanceState> buildInheritanceStates(List<XClass> orderedClasses) {
        HashMap<XClass, InheritanceState> inheritanceStatePerClass = new HashMap<XClass, InheritanceState>(orderedClasses.size());
        for (XClass clazz : orderedClasses) {
            InheritanceState superclassState = InheritanceState.getSuperclassInheritanceState(clazz, inheritanceStatePerClass);
            InheritanceState state = new InheritanceState(clazz);
            if (superclassState != null) {
                boolean nonDefault;
                superclassState.hasSons = true;
                InheritanceState superEntityState = InheritanceState.getSuperEntityInheritanceState(clazz, inheritanceStatePerClass);
                state.hasParents = superEntityState != null;
                boolean bl = nonDefault = state.type != null && !InheritanceType.SINGLE_TABLE.equals((Object)state.type);
                if (superclassState.type != null) {
                    boolean mixingStrategy;
                    boolean bl2 = mixingStrategy = state.type != null && !state.type.equals((Object)superclassState.type);
                    if (nonDefault && mixingStrategy) {
                        log.warn((Object)("Mixing inheritance strategy in a entity hierarchy is not allowed, ignoring sub strategy in: " + clazz.getName()));
                    }
                    state.type = superclassState.type;
                }
            }
            inheritanceStatePerClass.put(clazz, state);
        }
        return inheritanceStatePerClass;
    }
}

