/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.util.HashMap;
import javax.persistence.ColumnResult;
import javax.persistence.EntityResult;
import javax.persistence.FieldResult;
import javax.persistence.SqlResultSetMapping;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.CacheMode;
import org.hibernate.FlushMode;
import org.hibernate.LockMode;
import org.hibernate.annotations.CacheModeType;
import org.hibernate.annotations.FlushModeType;
import org.hibernate.annotations.NamedNativeQueries;
import org.hibernate.annotations.NamedNativeQuery;
import org.hibernate.annotations.NamedQueries;
import org.hibernate.annotations.NamedQuery;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.engine.NamedQueryDefinition;
import org.hibernate.engine.NamedSQLQueryDefinition;
import org.hibernate.engine.ResultSetMappingDefinition;
import org.hibernate.loader.custom.SQLQueryReturn;
import org.hibernate.loader.custom.SQLQueryRootReturn;
import org.hibernate.loader.custom.SQLQueryScalarReturn;

public abstract class QueryBinder {
    private static Log log = LogFactory.getLog(QueryBinder.class);

    public static void bindQuery(javax.persistence.NamedQuery queryAnn, ExtendedMappings mappings) {
        if (queryAnn == null) {
            return;
        }
        if (AnnotationBinder.isDefault(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        NamedQueryDefinition query = new NamedQueryDefinition(queryAnn.queryString(), false, null, null, null, null, null, false, null, null);
        mappings.addQuery(queryAnn.name(), query);
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding Named query: " + queryAnn.name() + " => " + queryAnn.queryString()));
        }
    }

    public static void bindNativeQuery(javax.persistence.NamedNativeQuery queryAnn, ExtendedMappings mappings) {
        NamedSQLQueryDefinition query;
        if (queryAnn == null) {
            return;
        }
        if (AnnotationBinder.isDefault(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String resultSetMapping = queryAnn.resultSetMapping();
        if (!AnnotationBinder.isDefault(resultSetMapping)) {
            query = new NamedSQLQueryDefinition(queryAnn.queryString(), resultSetMapping, null, false, null, null, null, null, null, false, null, null, false);
        } else if (!Void.TYPE.equals(queryAnn.resultClass())) {
            SQLQueryRootReturn entityQueryReturn = new SQLQueryRootReturn("alias1", queryAnn.resultClass().getName(), new HashMap(), LockMode.READ);
            query = new NamedSQLQueryDefinition(queryAnn.queryString(), new SQLQueryReturn[]{entityQueryReturn}, new SQLQueryScalarReturn[0], null, false, null, null, null, null, null, false, null, null, false);
        } else {
            throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
        }
        mappings.addSQLQuery(queryAnn.name(), query);
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding named native query: " + queryAnn.name() + " => " + queryAnn.queryString()));
        }
    }

    public static void bindNativeQuery(NamedNativeQuery queryAnn, ExtendedMappings mappings) {
        NamedSQLQueryDefinition query;
        if (queryAnn == null) {
            return;
        }
        if (AnnotationBinder.isDefault(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        String resultSetMapping = queryAnn.resultSetMapping();
        if (!AnnotationBinder.isDefault(resultSetMapping)) {
            query = new NamedSQLQueryDefinition(queryAnn.queryString(), resultSetMapping, null, queryAnn.cacheable(), AnnotationBinder.isDefault(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion(), queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()), queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()), QueryBinder.getFlushMode(queryAnn.flushMode()), QueryBinder.getCacheMode(queryAnn.cacheMode()), queryAnn.readOnly(), AnnotationBinder.isDefault(queryAnn.comment()) ? null : queryAnn.comment(), null, queryAnn.callable());
        } else if (!Void.TYPE.equals(queryAnn.resultClass())) {
            SQLQueryRootReturn entityQueryReturn = new SQLQueryRootReturn("alias1", queryAnn.resultClass().getName(), new HashMap(), LockMode.READ);
            query = new NamedSQLQueryDefinition(queryAnn.queryString(), new SQLQueryReturn[]{entityQueryReturn}, new SQLQueryScalarReturn[]{}, null, queryAnn.cacheable(), AnnotationBinder.isDefault(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion(), queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()), queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()), QueryBinder.getFlushMode(queryAnn.flushMode()), QueryBinder.getCacheMode(queryAnn.cacheMode()), queryAnn.readOnly(), AnnotationBinder.isDefault(queryAnn.comment()) ? null : queryAnn.comment(), null, queryAnn.callable());
        } else {
            throw new NotYetImplementedException("Pure native scalar queries are not yet supported");
        }
        mappings.addSQLQuery(queryAnn.name(), query);
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding named native query: " + queryAnn.name() + " => " + queryAnn.queryString()));
        }
    }

    public static void bindQueries(javax.persistence.NamedQueries queriesAnn, ExtendedMappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (javax.persistence.NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, mappings);
        }
    }

    public static void bindNativeQueries(javax.persistence.NamedNativeQueries queriesAnn, ExtendedMappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (javax.persistence.NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, mappings);
        }
    }

    public static void bindNativeQueries(NamedNativeQueries queriesAnn, ExtendedMappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedNativeQuery q : queriesAnn.value()) {
            QueryBinder.bindNativeQuery(q, mappings);
        }
    }

    public static void bindQuery(NamedQuery queryAnn, ExtendedMappings mappings) {
        if (queryAnn == null) {
            return;
        }
        if (AnnotationBinder.isDefault(queryAnn.name())) {
            throw new AnnotationException("A named query must have a name when used in class or package level");
        }
        FlushMode flushMode = QueryBinder.getFlushMode(queryAnn.flushMode());
        NamedQueryDefinition query = new NamedQueryDefinition(queryAnn.queryString(), queryAnn.cacheable(), AnnotationBinder.isDefault(queryAnn.cacheRegion()) ? null : queryAnn.cacheRegion(), queryAnn.timeout() < 0 ? null : Integer.valueOf(queryAnn.timeout()), queryAnn.fetchSize() < 0 ? null : Integer.valueOf(queryAnn.fetchSize()), flushMode, QueryBinder.getCacheMode(queryAnn.cacheMode()), queryAnn.readOnly(), AnnotationBinder.isDefault(queryAnn.comment()) ? null : queryAnn.comment(), null);
        mappings.addQuery(queryAnn.name(), query);
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding named query: " + queryAnn.name() + " => " + queryAnn.queryString()));
        }
    }

    private static FlushMode getFlushMode(FlushModeType flushModeType) {
        FlushMode flushMode;
        switch (flushModeType) {
            case ALWAYS: {
                flushMode = FlushMode.ALWAYS;
                break;
            }
            case AUTO: {
                flushMode = FlushMode.AUTO;
                break;
            }
            case COMMIT: {
                flushMode = FlushMode.COMMIT;
                break;
            }
            case NEVER: {
                flushMode = FlushMode.NEVER;
                break;
            }
            default: {
                throw new AssertionFailure("Unknown flushModeType: " + (Object)((Object)flushModeType));
            }
        }
        return flushMode;
    }

    private static CacheMode getCacheMode(CacheModeType cacheModeType) {
        switch (cacheModeType) {
            case GET: {
                return CacheMode.GET;
            }
            case IGNORE: {
                return CacheMode.IGNORE;
            }
            case NORMAL: {
                return CacheMode.NORMAL;
            }
            case PUT: {
                return CacheMode.PUT;
            }
            case REFRESH: {
                return CacheMode.REFRESH;
            }
        }
        throw new AssertionFailure("Unknown cacheModeType: " + (Object)((Object)cacheModeType));
    }

    public static void bindQueries(NamedQueries queriesAnn, ExtendedMappings mappings) {
        if (queriesAnn == null) {
            return;
        }
        for (NamedQuery q : queriesAnn.value()) {
            QueryBinder.bindQuery(q, mappings);
        }
    }

    public static void bindSqlResultsetMapping(SqlResultSetMapping ann, ExtendedMappings mappings) {
        ColumnResult[] arr$;
        int len$;
        int i$;
        if (ann == null) {
            return;
        }
        ResultSetMappingDefinition definition = new ResultSetMappingDefinition(ann.name());
        if (log.isInfoEnabled()) {
            log.info((Object)("Binding resultset mapping: " + definition.getName()));
        }
        if ((i$ = 0) < (len$ = (arr$ = ann.columns()).length)) {
            ColumnResult column = arr$[i$];
            throw new NotYetImplementedException("Scalar returns are not supported");
        }
        int aliasIndex = 0;
        for (EntityResult entity : ann.entities()) {
            HashMap<String, String[]> propertyresults = new HashMap<String, String[]>();
            for (FieldResult field : entity.fields()) {
                propertyresults.put(field.name(), new String[]{field.column()});
            }
            if (!AnnotationBinder.isDefault(entity.discriminatorColumn())) {
                propertyresults.put("class", new String[]{entity.discriminatorColumn()});
            }
            SQLQueryRootReturn result = new SQLQueryRootReturn("alias" + aliasIndex++, entity.name(), propertyresults, LockMode.READ);
            definition.addEntityQueryReturn((SQLQueryReturn)result);
        }
        mappings.addResultSetMapping(definition);
    }
}

