/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import javax.persistence.JoinColumn;
import javax.persistence.PrimaryKeyJoinColumn;
import org.hibernate.AnnotationException;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.BinderHelper;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.PropertyInferredData;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3JoinColumn
extends Ejb3Column {
    private String referencedColumn;
    private String mappedBy;
    private String mappedByPropertyName;
    private String mappedByTableName;
    private String manyToManyOwnerSideEntityName;
    public static final int NO_REFERENCE = 0;
    public static final int PK_REFERENCE = 1;
    public static final int NON_PK_REFERENCE = 2;

    public String getManyToManyOwnerSideEntityName() {
        return this.manyToManyOwnerSideEntityName;
    }

    public void setManyToManyOwnerSideEntityName(String manyToManyOwnerSideEntityName) {
        this.manyToManyOwnerSideEntityName = manyToManyOwnerSideEntityName;
    }

    public void setReferencedColumn(String referencedColumn) {
        this.referencedColumn = referencedColumn;
    }

    public String getMappedBy() {
        return this.mappedBy;
    }

    public void setMappedBy(String mappedBy) {
        this.mappedBy = mappedBy;
    }

    public Ejb3JoinColumn() {
        this.setMappedBy("");
    }

    public Ejb3JoinColumn(String sqlType, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String referencedColumn, String secondaryTable, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, String mappedBy, boolean isImplicit, ExtendedMappings mappings) {
        this.setImplicit(isImplicit);
        this.setSqlType(sqlType);
        this.setLogicalColumnName(name);
        this.setNullable(nullable);
        this.setUnique(unique);
        this.setInsertable(insertable);
        this.setUpdatable(updatable);
        this.setSecondaryTableName(secondaryTable);
        this.setPropertyHolder(propertyHolder);
        this.setJoins(joins);
        this.setMappings(mappings);
        this.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        this.bind();
        this.referencedColumn = referencedColumn;
        this.mappedBy = mappedBy;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, ExtendedMappings mappings) {
        if (ann != null) {
            Ejb3JoinColumn joinColumn = new Ejb3JoinColumn();
            joinColumn.setJoinAnnotation(ann, null);
            joinColumn.setJoins(joins);
            joinColumn.setPropertyHolder(propertyHolder);
            joinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
            joinColumn.setImplicit(false);
            joinColumn.setMappings(mappings);
            joinColumn.bind();
            return joinColumn;
        }
        Ejb3JoinColumn joinColumn = new Ejb3JoinColumn();
        joinColumn.setJoins(joins);
        joinColumn.setPropertyHolder(propertyHolder);
        joinColumn.setPropertyName(BinderHelper.getRelativePath(propertyHolder, propertyName));
        joinColumn.setImplicit(true);
        joinColumn.setMappings(mappings);
        joinColumn.bind();
        return joinColumn;
    }

    public void setJoinAnnotation(JoinColumn annJoin, String defaultName) {
        if (annJoin == null) {
            this.setImplicit(true);
        } else {
            this.setImplicit(false);
            if (!AnnotationBinder.isDefault(annJoin.columnDefinition())) {
                this.setSqlType(annJoin.columnDefinition());
            }
            if (!AnnotationBinder.isDefault(annJoin.name())) {
                this.setLogicalColumnName(annJoin.name());
            }
            this.setNullable(annJoin.nullable());
            this.setUnique(annJoin.unique());
            this.setInsertable(annJoin.insertable());
            this.setUpdatable(annJoin.updatable());
            this.setReferencedColumn(annJoin.referencedColumnName());
            this.setSecondaryTableName(annJoin.secondaryTable());
        }
    }

    public static Ejb3JoinColumn buildImplicitJoinColumn(String mappedBy, Map<String, Join> joins, PropertyHolder propertyHolder, String propertyName, ExtendedMappings mappings) {
        return new Ejb3JoinColumn(null, null, true, false, true, true, null, null, joins, propertyHolder, propertyName, mappedBy, true, mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = mappings.getLogicalColumnName(col.getName(), identifier.getTable());
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), ann.referencedColumnName(), ann.secondaryTable(), joins, propertyHolder, null, null, false, mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, true, false, true, true, null, null, joins, propertyHolder, null, null, false, mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(PrimaryKeyJoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = mappings.getLogicalColumnName(col.getName(), identifier.getTable());
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, false, false, true, true, ann.referencedColumnName(), null, joins, propertyHolder, null, null, false, mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, false, false, true, true, null, null, joins, propertyHolder, null, null, true, mappings);
    }

    public void setPersistentClass(PersistentClass persistentClass, Map<String, Join> joins) {
        this.propertyHolder = PropertyHolderBuilder.buildPropertyHolder(persistentClass, joins);
    }

    public static void checkIfJoinColumn(Object columns, PropertyHolder holder, PropertyInferredData property) {
        if (!(columns instanceof Ejb3JoinColumn[])) {
            throw new AnnotationException("@Column cannot be used on an association property: " + holder.getEntityName() + "." + property.getPropertyName());
        }
    }

    public void linkValueUsingDefaultColumnNaming(Column referencedColumn, Table referencedTable, SimpleValue value) {
        boolean ownerSide;
        String logicalReferencedColumn = this.getMappings().getLogicalColumnName(referencedColumn.getName(), referencedTable);
        boolean mappedBySide = this.mappedByTableName != null || this.mappedByPropertyName != null;
        boolean bl = ownerSide = this.getPropertyName() != null;
        String columnName = mappedBySide ? this.getMappings().getNamingStrategy().foreignKeyColumnName(this.mappedByPropertyName, this.mappedByTableName, logicalReferencedColumn) : (ownerSide ? this.getMappings().getNamingStrategy().foreignKeyColumnName(this.getPropertyName(), this.getMappings().getLogicalTableName(referencedTable), logicalReferencedColumn) : this.getMappings().getNamingStrategy().joinKeyColumnName(logicalReferencedColumn, this.getMappings().getLogicalTableName(referencedTable)));
        this.setLogicalColumnName(columnName);
        this.setReferencedColumn(logicalReferencedColumn);
        this.initMappingColumn(columnName, null, referencedColumn.getLength(), referencedColumn.getPrecision(), referencedColumn.getScale(), this.getMappingColumn().isNullable(), referencedColumn.getSqlType(), this.getMappingColumn().isUnique(), false);
        this.linkWithValue(value);
    }

    public void linkValueUsingAColumnCopy(Column column, SimpleValue value) {
        this.initMappingColumn(column.getName(), null, column.getLength(), column.getPrecision(), column.getScale(), this.getMappingColumn().isNullable(), column.getSqlType(), this.getMappingColumn().isUnique(), false);
        this.linkWithValue(value);
    }

    @Override
    protected void addColumnBinding(SimpleValue value) {
        if (StringHelper.isEmpty((String)this.mappedBy)) {
            String logicalColumnName = this.getMappings().getNamingStrategy().logicalCollectionColumnName(this.getLogicalColumnName(), this.getPropertyName(), this.getReferencedColumn());
            this.getMappings().addColumnBinding(logicalColumnName, this.getMappingColumn(), value.getTable());
        }
    }

    public static int checkReferencedColumnsType(Ejb3JoinColumn[] columns, PersistentClass referencedEntity, ExtendedMappings mappings) {
        HashSet<Column> idColumns = new HashSet<Column>();
        Iterator idColumnsIt = referencedEntity.getIdentifier().getColumnIterator();
        while (idColumnsIt.hasNext()) {
            idColumns.add((Column)idColumnsIt.next());
        }
        boolean isFkReferencedColumnName = false;
        boolean noReferencedColumn = true;
        Table table = referencedEntity.getTable();
        for (Ejb3JoinColumn ejb3Column : columns) {
            String referencedColumnName = ejb3Column.getReferencedColumn();
            if (!StringHelper.isNotEmpty((String)referencedColumnName)) continue;
            referencedColumnName = mappings.getPhysicalColumnName(referencedColumnName, table);
            noReferencedColumn = false;
            Column refCol = new Column(referencedColumnName);
            boolean contains = idColumns.contains(refCol);
            if (contains) continue;
            isFkReferencedColumnName = true;
        }
        if (isFkReferencedColumnName) {
            return 2;
        }
        if (noReferencedColumn) {
            return 0;
        }
        return 1;
    }

    public void overrideSqlTypeIfNecessary(Column column) {
        if (StringHelper.isEmpty((String)this.sqlType)) {
            this.sqlType = column.getSqlType();
            if (this.getMappingColumn() != null) {
                this.getMappingColumn().setSqlType(this.sqlType);
            }
        }
    }

    @Override
    public void redefineColumnName(String columnName, String propertyName, boolean applyNamingStrategy) {
        if (StringHelper.isNotEmpty((String)columnName)) {
            this.getMappingColumn().setName(applyNamingStrategy ? this.getMappings().getNamingStrategy().columnName(columnName) : columnName);
        }
    }

    public void setDefaultColumnName() {
        boolean ownerSide;
        String columnName = null;
        boolean mappedBySide = this.mappedByTableName != null || this.mappedByPropertyName != null;
        boolean bl = ownerSide = this.getPropertyName() != null;
        if (mappedBySide) {
            columnName = this.getMappings().getNamingStrategy().foreignKeyColumnName(this.mappedByPropertyName, this.mappedByTableName, this.referencedColumn);
        } else if (ownerSide) {
            columnName = this.getMappings().getNamingStrategy().foreignKeyColumnName(this.getPropertyName(), null, this.referencedColumn);
        }
        this.getMappingColumn().setName(columnName);
    }

    public void setMappedByPropertyName(String mappedByPropertyName) {
        this.mappedByPropertyName = mappedByPropertyName;
    }

    public void setMappedByTableName(String mappedByTableName) {
        this.mappedByTableName = mappedByTableName;
    }
}

