/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.io.Serializable;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Range;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RangeValidator
implements Validator<Range>,
PropertyConstraint,
Serializable {
    private long max;
    private long min;

    @Override
    public void initialize(Range parameters) {
        this.max = parameters.max();
        this.min = parameters.min();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            try {
                double dv = Double.parseDouble((String)value);
                return dv >= (double)this.min && dv <= (double)this.max;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (value instanceof Double || value instanceof Float) {
            double dv = ((Number)value).doubleValue();
            return dv >= (double)this.min && dv <= (double)this.max;
        }
        if (value instanceof Number) {
            long lv = ((Number)value).longValue();
            return lv >= this.min && lv <= this.max;
        }
        return false;
    }

    @Override
    public void apply(Property property) {
        Column col = (Column)property.getColumnIterator().next();
        String check = "";
        if (this.min != Long.MIN_VALUE) {
            check = check + col.getName() + ">" + this.min;
        }
        if (this.max != Long.MAX_VALUE && this.min != Long.MIN_VALUE) {
            check = check + " and ";
        }
        if (this.max != Long.MAX_VALUE) {
            check = check + col.getName() + "<" + this.max;
        }
        col.setCheckConstraint(check);
    }
}

