/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator;

import java.io.Serializable;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Property;
import org.hibernate.validator.Length;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LengthValidator
implements Validator<Length>,
PropertyConstraint,
Serializable {
    private int max;
    private int min;

    @Override
    public void initialize(Length parameters) {
        this.max = parameters.max();
        this.min = parameters.min();
    }

    @Override
    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (!(value instanceof String)) {
            return false;
        }
        String string = (String)value;
        int length = string.length();
        return length >= this.min && length <= this.max;
    }

    @Override
    public void apply(Property property) {
        Column col = (Column)property.getColumnIterator().next();
        col.setLength(this.max);
    }
}

