/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.hibernate.AnnotationException;
import org.hibernate.MappingException;
import org.hibernate.cfg.SecondPass;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Table;

public class IndexSecondPass
implements SecondPass {
    private final Table table;
    private final String indexName;
    private final String[] columns;

    public IndexSecondPass(Table table, String indexName, String[] columns) {
        this.table = table;
        this.indexName = indexName;
        this.columns = columns;
    }

    public void doSecondPass(Map persistentClasses, Map inheritedMetas) throws MappingException {
        for (String columnName : this.columns) {
            Column column = this.table.getColumn(new Column(columnName));
            if (column == null) {
                throw new AnnotationException("@Index references a unknown column: " + columnName);
            }
            this.table.getOrCreateIndex(this.indexName).addColumn(column);
        }
    }
}

