/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.persistence.AccessType;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.SecondaryTable;
import javax.persistence.SecondaryTables;
import javax.persistence.UniqueConstraint;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.annotations.TableBinder;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.Value;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityBinder {
    private String name;
    private Class annotatedClass;
    private PersistentClass persistentClass;
    private ExtendedMappings mappings;
    private static Log log = LogFactory.getLog(EntityBinder.class);
    private String discriminatorValue = "";
    private boolean propertyAccess = false;
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private boolean mutable;
    private OptimisticLockType optimisticLockType;
    private String persister;
    private PolymorphismType polymorphismType;
    private boolean selectBeforeUpdate;
    private int batchSize;
    private boolean lazy;
    private String proxyClassName;
    private String where;
    private Map<String, Join> secondaryTables = new HashMap<String, Join>();
    private Map<String, Object> secondaryTableJoins = new HashMap<String, Object>();
    private String cacheConcurrentStrategy;
    private String cacheRegion;
    private Map<String, String> filters = new HashMap<String, String>();

    public boolean isPropertyAccess() {
        return this.propertyAccess;
    }

    public EntityBinder(Entity ejb3Ann, org.hibernate.annotations.Entity hibAnn, Class annotatedClass, PersistentClass persistentClass, ExtendedMappings mappings) {
        this.mappings = mappings;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
        this.bindEjb3Annotation(ejb3Ann);
        this.bindHibernateAnnotation(hibAnn);
    }

    private void bindHibernateAnnotation(org.hibernate.annotations.Entity hibAnn) {
        if (hibAnn != null) {
            this.dynamicInsert = hibAnn.dynamicInsert();
            this.dynamicUpdate = hibAnn.dynamicUpdate();
            this.mutable = hibAnn.mutable();
            this.optimisticLockType = hibAnn.optimisticLock();
            this.persister = hibAnn.persister();
            this.selectBeforeUpdate = hibAnn.selectBeforeUpdate();
            this.polymorphismType = hibAnn.polymorphism();
        } else {
            this.dynamicInsert = false;
            this.dynamicUpdate = false;
            this.mutable = true;
            this.optimisticLockType = OptimisticLockType.VERSION;
            this.persister = "";
            this.polymorphismType = PolymorphismType.IMPLICIT;
            this.selectBeforeUpdate = false;
        }
    }

    private void bindEjb3Annotation(Entity ejb3Ann) {
        if (ejb3Ann == null) {
            throw new AssertionFailure("@Entity should always be not null");
        }
        this.name = AnnotationBinder.isDefault(ejb3Ann.name()) ? StringHelper.unqualify((String)this.annotatedClass.getName()) : ejb3Ann.name();
        this.propertyAccess = ejb3Ann.access() == AccessType.PROPERTY;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void bindEntity() {
        this.persistentClass.setAbstract(Modifier.isAbstract(this.annotatedClass.getModifiers()));
        this.persistentClass.setClassName(this.annotatedClass.getName());
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        if (StringHelper.isEmpty((String)this.discriminatorValue)) {
            this.persistentClass.setDiscriminatorValue(this.persistentClass.getEntityName());
        } else {
            this.persistentClass.setDiscriminatorValue(this.discriminatorValue);
        }
        this.persistentClass.setLazy(this.lazy);
        if (!StringHelper.isEmpty((String)this.proxyClassName)) {
            this.persistentClass.setProxyInterfaceName(this.proxyClassName);
        }
        this.persistentClass.setDynamicInsert(this.dynamicInsert);
        this.persistentClass.setDynamicUpdate(this.dynamicUpdate);
        if (this.persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)this.persistentClass;
            rootClass.setMutable(this.mutable);
            rootClass.setExplicitPolymorphism(this.isExplicitPolymorphism(this.polymorphismType));
            if (StringHelper.isNotEmpty((String)this.where)) {
                rootClass.setWhere(this.where);
            }
            if (this.cacheConcurrentStrategy != null) {
                rootClass.setCacheConcurrencyStrategy(this.cacheConcurrentStrategy);
                rootClass.setCacheRegionName(this.cacheRegion);
            }
        }
        this.persistentClass.setOptimisticLockMode(this.getVersioning(this.optimisticLockType));
        this.persistentClass.setSelectBeforeUpdate(this.selectBeforeUpdate);
        if (!AnnotationBinder.isDefault(this.persister)) {
            try {
                this.persistentClass.setEntityPersisterClass(ReflectHelper.classForName((String)this.persister));
            }
            catch (ClassNotFoundException cnfe) {
                throw new AnnotationException("Could not find persister class: " + this.persister);
            }
        }
        this.persistentClass.setBatchSize(this.batchSize);
        for (Map.Entry<String, String> filter : this.filters.entrySet()) {
            this.persistentClass.addFilter(filter.getKey(), filter.getValue());
        }
        log.debug((Object)("Import with entity name=" + this.name));
        try {
            this.mappings.addImport(this.persistentClass.getEntityName(), this.name);
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name);
        }
    }

    int getVersioning(OptimisticLockType type) {
        switch (type) {
            case VERSION: {
                return 0;
            }
            case NONE: {
                return -1;
            }
            case DIRTY: {
                return 1;
            }
            case ALL: {
                return 2;
            }
        }
        throw new AssertionFailure("optimistic locking not supported: " + (Object)((Object)type));
    }

    private boolean isExplicitPolymorphism(PolymorphismType type) {
        switch (type) {
            case IMPLICIT: {
                return false;
            }
            case EXPLICIT: {
                return true;
            }
        }
        throw new AssertionFailure("Unknown polymorphism type: " + (Object)((Object)type));
    }

    public void setBatchSize(BatchSize sizeAnn) {
        this.batchSize = sizeAnn != null ? sizeAnn.size() : -1;
    }

    public void setProxy(Proxy proxy) {
        if (proxy != null) {
            this.lazy = proxy.lazy();
            this.proxyClassName = !this.lazy ? null : (AnnotationBinder.isDefault(proxy.proxyClassName()) ? this.annotatedClass.getName() : proxy.proxyClassName());
        } else {
            this.lazy = true;
            this.proxyClassName = this.annotatedClass.getName();
        }
    }

    public void setWhere(Where whereAnn) {
        if (whereAnn != null) {
            this.where = whereAnn.clause();
        }
    }

    private String getClassTableName(String tableName) {
        if (StringHelper.isEmpty((String)tableName)) {
            return this.mappings.getNamingStrategy().classToTableName(this.persistentClass.getEntityName());
        }
        return this.mappings.getNamingStrategy().tableName(tableName);
    }

    public void bindTable(String schema, String catalog, String tableName, List uniqueConstraints, String constraints, Table denormalizedSuperclassTable) {
        Table table = TableBinder.fillTable(schema, catalog, this.getClassTableName(tableName), this.persistentClass.isAbstract(), uniqueConstraints, constraints, denormalizedSuperclassTable, this.mappings);
        if (!(this.persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("binding a table for a subclass");
        }
        ((TableOwner)this.persistentClass).setTable(table);
    }

    public void finalSecondaryTableBinding(PropertyHolder propertyHolder) {
        Iterator<Join> joins = this.secondaryTables.values().iterator();
        Iterator<Object> joinColumns = this.secondaryTableJoins.values().iterator();
        while (joins.hasNext()) {
            Ejb3JoinColumn[] ejb3JoinColumns;
            Object uncastedColumn = joinColumns.next();
            JoinColumn[] columns = null;
            if (uncastedColumn instanceof JoinColumn[]) {
                columns = (JoinColumn[])uncastedColumn;
            }
            if (columns == null) {
                ejb3JoinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)uncastedColumn, (Value)this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings)};
            } else {
                int nbrOfJoinColumns = columns.length;
                if (nbrOfJoinColumns == 0) {
                    ejb3JoinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)null, (Value)this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings)};
                } else {
                    ejb3JoinColumns = new Ejb3JoinColumn[nbrOfJoinColumns];
                    for (int colIndex = 0; colIndex < nbrOfJoinColumns; ++colIndex) {
                        ejb3JoinColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(columns[colIndex], (Value)this.persistentClass.getIdentifier(), this.secondaryTables, propertyHolder, this.mappings);
                    }
                }
            }
            for (Ejb3JoinColumn joinColumn : ejb3JoinColumns) {
                joinColumn.forceNotNull();
            }
            Join join = joins.next();
            EntityBinder.bindJoinToPersistentClass(join, ejb3JoinColumns, this.persistentClass);
        }
        this.mappings.addJoins(this.persistentClass, this.secondaryTables);
    }

    public static void bindJoinToPersistentClass(Join join, Ejb3JoinColumn[] ejb3JoinColumns, PersistentClass persistentClass) {
        DependantValue key = new DependantValue(join.getTable(), persistentClass.getIdentifier());
        join.setKey((KeyValue)key);
        join.setSequentialSelect(false);
        join.setInverse(false);
        join.setOptional(false);
        key.setCascadeDeleteEnabled(false);
        TableBinder.bindFk(persistentClass, null, ejb3JoinColumns, (SimpleValue)key, false);
        join.createPrimaryKey();
        join.createForeignKey();
        persistentClass.addJoin(join);
    }

    public void firstLevelSecondaryTablesBinding(SecondaryTable secTable, SecondaryTables secTables, JoinColumn joinCol, JoinColumns joinCols) {
        if (secTables != null) {
            for (SecondaryTable tab : secTables.value()) {
                this.bindFirstLevelSecondaryTable(tab, null, null);
            }
        } else if (secTable != null) {
            this.bindFirstLevelSecondaryTable(secTable, joinCol, joinCols);
        }
    }

    private void bindFirstLevelSecondaryTable(SecondaryTable tabAnn, JoinColumn joinColAnn, JoinColumns joinColsAnn) {
        ArrayList<String[]> uniqueConstraints = new ArrayList<String[]>();
        if (tabAnn.uniqueConstraints().length != 0) {
            for (UniqueConstraint uc : tabAnn.uniqueConstraints()) {
                if (!uc.primary()) {
                    uniqueConstraints.add(uc.columnNames());
                    continue;
                }
                log.warn((Object)"@UniqueConstraint(primaryKey=true) not yet supported");
            }
        }
        this.addSecondaryTable(tabAnn.schema(), tabAnn.catalog(), tabAnn.name(), uniqueConstraints, joinColAnn, joinColsAnn == null ? tabAnn.join() : joinColsAnn.value());
    }

    public void addSecondaryTable(String schema, String catalog, String table, List uniqueConstraints, JoinColumn joinColAnn, JoinColumn[] joinColArray) {
        Join join = EntityBinder.buildJoin(schema, catalog, table, uniqueConstraints, this.persistentClass, this.mappings);
        if (joinColAnn != null) {
            this.secondaryTableJoins.put(table, joinColAnn);
        } else {
            this.secondaryTableJoins.put(table, joinColArray);
        }
        log.info((Object)("Mapping class join: " + this.persistentClass.getEntityName() + " -> " + join.getTable().getName()));
        this.secondaryTables.put(table, join);
    }

    public static Join buildJoin(String schema, String catalog, String table, List uniqueConstraints, PersistentClass persistentClass, ExtendedMappings mappings) {
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        Table tableMapping = TableBinder.fillTable(schema, catalog, table, false, uniqueConstraints, null, null, mappings);
        join.setTable(tableMapping);
        return join;
    }

    public Map<String, Join> getSecondaryTables() {
        return this.secondaryTables;
    }

    public void setCache(Cache cacheAnn) {
        if (cacheAnn != null) {
            this.cacheRegion = AnnotationBinder.isDefault(cacheAnn.region()) ? null : cacheAnn.region();
            this.cacheConcurrentStrategy = EntityBinder.getCacheConcurrencyStrategy(cacheAnn.usage());
        } else {
            this.cacheConcurrentStrategy = null;
            this.cacheRegion = null;
        }
    }

    public static String getCacheConcurrencyStrategy(CacheConcurrencyStrategy strategy) {
        switch (strategy) {
            case NONE: {
                return null;
            }
            case READ_ONLY: {
                return "read-only";
            }
            case READ_WRITE: {
                return "read-write";
            }
            case NONSTRICT_READ_WRITE: {
                return "nonstrict-read-write";
            }
            case TRANSACTIONAL: {
                return "transactional";
            }
        }
        throw new AssertionFailure("CacheConcurrencyStrategy unknown: " + (Object)((Object)strategy));
    }

    public void addFilter(String name, String condition) {
        this.filters.put(name, condition);
    }
}

