/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.AnnotedElementInferredData;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Column {
    private static final Log log = LogFactory.getLog(Ejb3Column.class);
    private Column mappingColumn;
    private boolean insertable;
    private boolean updatable;
    private String secondaryTableName;
    protected Map<String, Join> joins;
    protected PropertyHolder propertyHolder;
    private Mappings mappings;
    private boolean isImplicit;
    public static final int DEFAULT_COLUMN_LENGTH = 255;

    public boolean isImplicit() {
        return this.isImplicit;
    }

    public boolean isNullable() {
        return this.mappingColumn.isNullable();
    }

    public Ejb3Column(boolean isImplicit, String sqlType, int length, int precision, int scale, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String secondaryTableName, Map<String, Join> joins, PropertyHolder propertyHolder, Mappings mappings) {
        log.debug((Object)("Binding column " + name + " unique " + unique));
        this.mappings = mappings;
        this.initMappingColumn(name, length, precision, scale, nullable, sqlType, unique);
        this.insertable = insertable;
        this.updatable = updatable;
        this.secondaryTableName = secondaryTableName;
        this.joins = joins;
        this.propertyHolder = propertyHolder;
        this.isImplicit = isImplicit;
    }

    protected void initMappingColumn(String name, int length, int precision, int scale, boolean nullable, String sqlType, boolean unique) {
        this.mappingColumn = new Column();
        this.setName(name);
        this.mappingColumn.setLength(length);
        if (precision > 0) {
            this.mappingColumn.setPrecision(precision);
            this.mappingColumn.setScale(scale);
        }
        this.mappingColumn.setNullable(nullable);
        this.mappingColumn.setSqlType(sqlType);
        this.mappingColumn.setUnique(unique);
    }

    public Ejb3Column(PropertyHolder propertyHolder, Mappings mappings) {
        log.debug((Object)"Deferred column definition");
        this.mappings = mappings;
        this.propertyHolder = propertyHolder;
    }

    public boolean isNameDeferred() {
        return this.mappingColumn == null || StringHelper.isEmpty((String)this.mappingColumn.getName());
    }

    public void setName(String name) {
        if (name != null) {
            this.mappingColumn.setName(this.mappings.getNamingStrategy().columnName(name));
        }
    }

    public String getName() {
        return this.mappingColumn.getName();
    }

    public Column getMappingColumn() {
        return this.mappingColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setNullable(boolean nullable) {
        this.mappingColumn.setNullable(nullable);
    }

    public void setJoins(Map<String, Join> joins) {
        this.joins = joins;
    }

    public PropertyHolder getPropertyHolder() {
        return this.propertyHolder;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    protected void setMappingColumn(Column mappingColumn) {
        this.mappingColumn = mappingColumn;
    }

    public void linkWithValue(SimpleValue value) {
        this.getMappingColumn().setValue((Value)value);
        value.addColumn(this.getMappingColumn());
        value.getTable().addColumn(this.getMappingColumn());
    }

    public Table getTable() {
        if (this.isSecondary()) {
            return this.getJoin().getTable();
        }
        return this.propertyHolder.getTable();
    }

    public boolean isSecondary() {
        if (this.propertyHolder == null) {
            throw new AssertionFailure("Should not call getTable() on column wo persistent class defined");
        }
        return StringHelper.isNotEmpty((String)this.secondaryTableName);
    }

    private Join getJoin() {
        Join join = this.joins.get(this.secondaryTableName);
        if (join == null) {
            throw new AnnotationException("Cannot find the expected secondary table: no " + this.secondaryTableName + " in " + this.propertyHolder.getClassName());
        }
        return join;
    }

    public void addPropertyToMappingContainer(Property prop) {
        if (this.isSecondary()) {
            this.getJoin().addProperty(prop);
        } else {
            this.propertyHolder.addProperty(prop);
        }
    }

    public void forceNotNull() {
        this.mappingColumn.setNullable(false);
    }

    public void setSecondaryTableName(String secondaryTableName) {
        this.secondaryTableName = secondaryTableName;
    }

    public static Ejb3Column[] buildColumnFromAnnotation(javax.persistence.Column[] anns, PropertyHolder propertyHolder, AnnotedElementInferredData inferredData, Map<String, Join> secondaryTables, ExtendedMappings mappings) {
        Ejb3Column[] columns;
        javax.persistence.Column[] actualCols = anns;
        javax.persistence.Column[] overriddenCols = propertyHolder.getOverriddenColumn(inferredData.getPropertyName());
        if (overriddenCols != null) {
            if (anns != null && overriddenCols.length != anns.length) {
                throw new AnnotationException("AttributeOverride.column() should override all columns for now");
            }
            actualCols = overriddenCols.length == 0 ? null : overriddenCols;
            log.debug((Object)("Column(s) overridden for property " + inferredData.getPropertyName()));
        }
        if (actualCols == null) {
            columns = Ejb3Column.buildImplicitColumn(inferredData, secondaryTables, propertyHolder, mappings);
        } else {
            int length = actualCols.length;
            columns = new Ejb3Column[length];
            for (int index = 0; index < length; ++index) {
                javax.persistence.Column col = actualCols[index];
                String sqlType = col.columnDefinition().equals("") ? null : col.columnDefinition();
                String name = col.name().equals("") ? inferredData.getPropertyName() : col.name();
                columns[index] = new Ejb3Column(false, sqlType, col.length(), col.precision(), col.scale(), name, col.nullable(), col.unique(), col.insertable(), col.updatable(), col.secondaryTable(), secondaryTables, propertyHolder, mappings);
            }
        }
        return columns;
    }

    private static Ejb3Column[] buildImplicitColumn(AnnotedElementInferredData inferredData, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Ejb3Column[] columns = new Ejb3Column[]{new Ejb3Column(true, null, 255, 0, 0, inferredData.getPropertyName(), true, false, true, true, null, secondaryTables, propertyHolder, mappings)};
        return columns;
    }

    public static void checkPropertyConsistency(Ejb3Column[] columns, String propertyName) {
        int nbrOfColumns = columns.length;
        if (nbrOfColumns > 1) {
            for (int currentIndex = 1; currentIndex < nbrOfColumns; ++currentIndex) {
                if (columns[currentIndex].isInsertable() != columns[currentIndex - 1].isInsertable()) {
                    throw new AnnotationException("Mixing insertable and non insertable columns in a property is not allowed: " + propertyName);
                }
                if (columns[currentIndex].isNullable() != columns[currentIndex - 1].isNullable()) {
                    throw new AnnotationException("Mixing nullable and non nullable columns in a property is not allowed: " + propertyName);
                }
                if (columns[currentIndex].isUpdatable() != columns[currentIndex - 1].isUpdatable()) {
                    throw new AnnotationException("Mixing updatable and non updatable columns in a property is not allowed: " + propertyName);
                }
                if (columns[currentIndex].getTable().equals(columns[currentIndex - 1].getTable())) continue;
                throw new AnnotationException("Mixing different tables in a property is not allowed: " + propertyName);
            }
        }
    }
}

