/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.type;

import java.io.Serializable;
import java.sql.Blob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.hibernate.Hibernate;
import org.hibernate.HibernateException;
import org.hibernate.type.ArrayUtil;
import org.hibernate.usertype.UserType;

public class ByteArrayBlobType
implements UserType {
    public static final int BUFFER_SIZE = 4096;

    public int[] sqlTypes() {
        return new int[]{2004};
    }

    public Class returnedClass() {
        return Byte[].class;
    }

    public boolean equals(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x instanceof Byte[]) {
            Object[] o1 = (Object[])x;
            Object[] o2 = (Object[])y;
            return ArrayUtil.isEquals(o1, o2);
        }
        byte[] c1 = (byte[])x;
        byte[] c2 = (byte[])y;
        return ArrayUtil.isEquals(c1, c2);
    }

    public int hashCode(Object x) throws HibernateException {
        if (x instanceof Character[]) {
            Object[] o = (Object[])x;
            return ArrayUtil.hash(o);
        }
        byte[] c = (byte[])x;
        return ArrayUtil.hash(c);
    }

    public Object nullSafeGet(ResultSet rs, String[] names, Object owner) throws HibernateException, SQLException {
        Blob blob = rs.getBlob(names[0]);
        if (rs.wasNull()) {
            return null;
        }
        int length = (int)blob.length();
        byte[] primaryResult = blob.getBytes(1L, length);
        if (this.returnedClass().equals(Byte[].class)) {
            Byte[] result = new Byte[length];
            for (int index = 0; index < length; ++index) {
                result[index] = new Byte(primaryResult[index]);
            }
            return result;
        }
        return primaryResult;
    }

    public void nullSafeSet(PreparedStatement st, Object value, int index) throws HibernateException, SQLException {
        if (value == null) {
            st.setNull(index, this.sqlTypes()[0]);
        } else {
            byte[] toSet;
            if (this.returnedClass().equals(Byte[].class)) {
                Byte[] bytes = (Byte[])value;
                int length = bytes.length;
                toSet = new byte[length];
                for (int i = 0; i < length; ++i) {
                    toSet[i] = bytes[i];
                }
            } else {
                toSet = (byte[])value;
            }
            st.setBlob(index, Hibernate.createBlob((byte[])toSet));
        }
    }

    public Object deepCopy(Object value) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (value instanceof Byte[]) {
            Byte[] array = (Byte[])value;
            int length = array.length;
            Byte[] copy = new Byte[length];
            for (int index = 0; index < length; ++index) {
                copy[index] = new Byte(array[index]);
            }
            return copy;
        }
        byte[] array = (byte[])value;
        int length = array.length;
        byte[] copy = new byte[length];
        System.arraycopy(array, 0, copy, 0, length);
        return copy;
    }

    public boolean isMutable() {
        return true;
    }

    public Serializable disassemble(Object value) throws HibernateException {
        return (Serializable)this.deepCopy(value);
    }

    public Object assemble(Serializable cached, Object owner) throws HibernateException {
        return this.deepCopy(cached);
    }

    public Object replace(Object original, Object target, Object owner) throws HibernateException {
        return this.deepCopy(original);
    }
}

