/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg.annotations;

import java.lang.reflect.Modifier;
import javax.ejb.AccessType;
import javax.ejb.Entity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.OptimisticLockType;
import org.hibernate.annotations.PolymorphismType;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotationBinder;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.RootClass;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

public class EntityBinder {
    private String name;
    private Class annotatedClass;
    private PersistentClass persistentClass;
    private ExtendedMappings mappings;
    private static Log log = LogFactory.getLog(EntityBinder.class);
    private String discriminatorValue = "";
    private boolean propertyAccess = false;
    private boolean dynamicInsert;
    private boolean dynamicUpdate;
    private boolean mutable;
    private OptimisticLockType optimisticLockType;
    private String persister;
    private PolymorphismType polymorphismType;
    private boolean selectBeforeUpdate;
    private int batchSize;
    private boolean lazy;
    private String proxyClassName;
    private String where;

    public boolean isPropertyAccess() {
        return this.propertyAccess;
    }

    public EntityBinder(Entity ejb3Ann, org.hibernate.annotations.Entity hibAnn, Class annotatedClass, PersistentClass persistentClass, ExtendedMappings mappings) {
        this.mappings = mappings;
        this.persistentClass = persistentClass;
        this.annotatedClass = annotatedClass;
        this.bindEjb3Annotation(ejb3Ann);
        this.bindHibernateAnnotation(hibAnn);
    }

    private void bindHibernateAnnotation(org.hibernate.annotations.Entity hibAnn) {
        if (hibAnn != null) {
            this.dynamicInsert = hibAnn.dynamicInsert();
            this.dynamicUpdate = hibAnn.dynamicUpdate();
            this.mutable = hibAnn.mutable();
            this.optimisticLockType = hibAnn.optimisticLock();
            this.persister = hibAnn.persister();
            this.selectBeforeUpdate = hibAnn.selectBeforeUpdate();
            this.polymorphismType = hibAnn.polymorphism();
        } else {
            this.dynamicInsert = false;
            this.dynamicUpdate = false;
            this.mutable = true;
            this.optimisticLockType = OptimisticLockType.VERSION;
            this.persister = "";
            this.polymorphismType = PolymorphismType.IMPLICIT;
            this.selectBeforeUpdate = false;
        }
    }

    private void bindEjb3Annotation(Entity ejb3Ann) {
        if (ejb3Ann == null) {
            throw new AssertionFailure("@Entity should always be not null");
        }
        this.name = AnnotationBinder.isDefault(ejb3Ann.name()) ? StringHelper.unqualify((String)this.annotatedClass.getName()) : ejb3Ann.name();
        this.propertyAccess = ejb3Ann.access() == AccessType.PROPERTY;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        this.discriminatorValue = discriminatorValue;
    }

    public void bindEntity() {
        this.persistentClass.setAbstract(Modifier.isAbstract(this.annotatedClass.getModifiers()));
        this.persistentClass.setClassName(this.annotatedClass.getName());
        this.persistentClass.setEntityName(this.annotatedClass.getName());
        if (StringHelper.isEmpty((String)this.discriminatorValue)) {
            this.persistentClass.setDiscriminatorValue(this.persistentClass.getEntityName());
        } else {
            this.persistentClass.setDiscriminatorValue(this.discriminatorValue);
        }
        this.persistentClass.setLazy(this.lazy);
        if (!StringHelper.isEmpty((String)this.proxyClassName)) {
            this.persistentClass.setProxyInterfaceName(this.proxyClassName);
        }
        this.persistentClass.setDynamicInsert(this.dynamicInsert);
        this.persistentClass.setDynamicUpdate(this.dynamicUpdate);
        if (this.persistentClass instanceof RootClass) {
            RootClass rootClass = (RootClass)this.persistentClass;
            rootClass.setMutable(this.mutable);
            rootClass.setExplicitPolymorphism(this.isExplicitPolymorphism(this.polymorphismType));
            if (StringHelper.isNotEmpty((String)this.where)) {
                rootClass.setWhere(this.where);
            }
        }
        this.persistentClass.setOptimisticLockMode(this.getVersioning(this.optimisticLockType));
        this.persistentClass.setSelectBeforeUpdate(this.selectBeforeUpdate);
        if (!AnnotationBinder.isDefault(this.persister)) {
            try {
                this.persistentClass.setEntityPersisterClass(ReflectHelper.classForName((String)this.persister));
            }
            catch (ClassNotFoundException cnfe) {
                throw new AnnotationException("Could not find persister class: " + this.persister);
            }
        }
        this.persistentClass.setBatchSize(this.batchSize);
        log.debug((Object)("Import with entity name=" + this.name));
        try {
            this.mappings.addImport(this.persistentClass.getEntityName(), this.name);
        }
        catch (MappingException me) {
            throw new AnnotationException("Use of the same entity name twice: " + this.name);
        }
    }

    int getVersioning(OptimisticLockType type) {
        switch (type) {
            case VERSION: {
                return 0;
            }
            case NONE: {
                return -1;
            }
            case DIRTY: {
                return 1;
            }
            case ALL: {
                return 2;
            }
        }
        throw new AssertionFailure("optimistic locking not supported: " + (Object)((Object)type));
    }

    private boolean isExplicitPolymorphism(PolymorphismType type) {
        switch (type) {
            case IMPLICIT: {
                return false;
            }
            case EXPLICIT: {
                return true;
            }
        }
        throw new AssertionFailure("Unknown polymorphism type: " + (Object)((Object)type));
    }

    public void setBatchSize(BatchSize sizeAnn) {
        this.batchSize = sizeAnn != null ? sizeAnn.size() : -1;
    }

    public void setProxy(Proxy proxy) {
        if (proxy != null) {
            this.lazy = proxy.lazy();
            this.proxyClassName = !this.lazy ? null : (AnnotationBinder.isDefault(proxy.proxyClassName()) ? this.annotatedClass.getName() : proxy.proxyClassName());
        } else {
            this.lazy = true;
            this.proxyClassName = this.annotatedClass.getName();
        }
    }

    public void setWhere(Where whereAnn) {
        if (whereAnn != null) {
            this.where = whereAnn.clause();
        }
    }
}

