/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import javax.ejb.InheritanceJoinColumn;
import javax.ejb.JoinColumn;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Value;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3JoinColumn
extends Ejb3Column {
    private static final int DEFAULT_COLUMN_LENGTH = 255;
    private String referencedColumn;

    public Ejb3JoinColumn(String sqlType, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String referencedColumn, String secondaryTable, Map<String, Join> joins, PropertyHolder propertyHolder, Mappings mappings) {
        super(sqlType, 255, 0, 0, name, nullable, unique, insertable, updatable, secondaryTable, joins, propertyHolder, mappings);
        this.referencedColumn = referencedColumn;
    }

    public String getReferencedColumn() {
        return this.referencedColumn;
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, String defaultName, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), ann.referencedColumnName(), ann.secondaryTable(), joins, propertyHolder, mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, true, false, true, true, null, null, joins, propertyHolder, mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(JoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = col.getName();
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, ann.nullable(), ann.unique(), ann.insertable(), ann.updatable(), ann.referencedColumnName(), ann.secondaryTable(), joins, propertyHolder, mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, true, false, true, true, null, null, joins, propertyHolder, mappings);
    }

    public static Ejb3JoinColumn buildJoinColumn(InheritanceJoinColumn ann, Value identifier, Map<String, Join> joins, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Column col = (Column)identifier.getColumnIterator().next();
        String defaultName = col.getName();
        if (ann != null) {
            String sqlType = ann.columnDefinition().equals("") ? null : ann.columnDefinition();
            String name = ann.name().equals("") ? defaultName : ann.name();
            return new Ejb3JoinColumn(sqlType, name, false, false, true, true, ann.referencedColumnName(), null, joins, propertyHolder, mappings);
        }
        return new Ejb3JoinColumn(null, defaultName, false, false, true, true, null, null, joins, propertyHolder, mappings);
    }

    public void setPersistentClass(PersistentClass persistentClass) {
        this.propertyHolder = PropertyHolderBuilder.buildPropertyHolder(persistentClass);
    }
}

