/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.cfg.AnnotedElementInferredData;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.Mappings;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Table;
import org.hibernate.mapping.Value;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb3Column {
    private static final Log log = LogFactory.getLog(Ejb3Column.class);
    private final Column mappingColumn;
    private final boolean insertable;
    private final boolean updatable;
    private final String secondaryTableName;
    protected Map<String, Join> joins;
    protected PropertyHolder propertyHolder;

    public Ejb3Column(String sqlType, int length, int precision, int scale, String name, boolean nullable, boolean unique, boolean insertable, boolean updatable, String secondaryTableName, Map<String, Join> joins, PropertyHolder propertyHolder, Mappings mappings) {
        log.debug((Object)("Binding column " + name + " unique " + unique));
        Column hibColumn = new Column();
        hibColumn.setName(mappings.getNamingStrategy().columnName(name));
        hibColumn.setLength(length);
        if (precision > 0) {
            hibColumn.setPrecision(precision);
            hibColumn.setLength(scale);
        }
        hibColumn.setNullable(nullable);
        hibColumn.setSqlType(sqlType);
        hibColumn.setUnique(unique);
        this.mappingColumn = hibColumn;
        this.insertable = insertable;
        this.updatable = updatable;
        this.secondaryTableName = secondaryTableName;
        this.joins = joins;
        this.propertyHolder = propertyHolder;
    }

    public Column getMappingColumn() {
        return this.mappingColumn;
    }

    public boolean isInsertable() {
        return this.insertable;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setJoins(Map<String, Join> joins) {
        this.joins = joins;
    }

    public void setPropertyHolder(PropertyHolder propertyHolder) {
        this.propertyHolder = propertyHolder;
    }

    public void linkWithValue(SimpleValue value) {
        this.getMappingColumn().setValue((Value)value);
        value.addColumn(this.getMappingColumn());
        value.getTable().addColumn(this.getMappingColumn());
    }

    public Table getTable() {
        if (this.isSecondary()) {
            return this.getJoin().getTable();
        }
        return this.propertyHolder.getTable();
    }

    public boolean isSecondary() {
        if (this.propertyHolder == null) {
            throw new AssertionFailure("Should not call getTable() on column wo persistent class defined");
        }
        return StringHelper.isNotEmpty((String)this.secondaryTableName);
    }

    private Join getJoin() {
        Join join = this.joins.get(this.secondaryTableName);
        if (join == null) {
            throw new AnnotationException("Cannot find the expected secondary table: no " + this.secondaryTableName + " in " + this.propertyHolder.getClassName());
        }
        return join;
    }

    public void addPropertyToMappingContainer(Property prop) {
        if (this.isSecondary()) {
            this.getJoin().addProperty(prop);
        } else {
            this.propertyHolder.addProperty(prop);
        }
    }

    public void forceNotNull() {
        this.mappingColumn.setNullable(false);
    }

    public static Ejb3Column[] buildColumnFromAnnotation(javax.ejb.Column ann, PropertyHolder propertyHolder, AnnotedElementInferredData inferredData, Map<String, Join> secondaryTables, ExtendedMappings mappings) {
        Ejb3Column[] columns;
        javax.ejb.Column actualCol = ann;
        javax.ejb.Column[] overriddenCols = propertyHolder.getOverriddenColumn(inferredData.getPropertyName());
        if (overriddenCols != null) {
            if (overriddenCols.length > 1) {
                throw new AnnotationException("DependentAttribute.column().length > 1 is a non sense to me. Please report your use case to JIRA");
            }
            actualCol = overriddenCols.length == 0 ? null : overriddenCols[0];
            log.debug((Object)("Column overridden for property " + inferredData.getPropertyName()));
        }
        if (actualCol == null) {
            columns = new Ejb3Column[]{new Ejb3Column(null, 255, 0, 0, inferredData.getPropertyName(), true, false, true, true, null, secondaryTables, propertyHolder, mappings)};
        } else {
            String sqlType = actualCol.columnDefinition().equals("") ? null : actualCol.columnDefinition();
            String name = actualCol.name().equals("") ? inferredData.getPropertyName() : actualCol.name();
            columns = new Ejb3Column[]{new Ejb3Column(sqlType, actualCol.length(), actualCol.precision(), actualCol.scale(), name, actualCol.nullable(), actualCol.unique(), actualCol.insertable(), actualCol.updatable(), actualCol.secondaryTable(), secondaryTables, propertyHolder, mappings)};
        }
        return columns;
    }
}

