/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cfg;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ejb.AccessType;
import javax.ejb.AssociationTable;
import javax.ejb.Basic;
import javax.ejb.CascadeType;
import javax.ejb.Dependent;
import javax.ejb.DependentAttribute;
import javax.ejb.DependentObject;
import javax.ejb.DiscriminatorColumn;
import javax.ejb.DiscriminatorType;
import javax.ejb.Entity;
import javax.ejb.FetchType;
import javax.ejb.GeneratorTable;
import javax.ejb.GeneratorType;
import javax.ejb.Id;
import javax.ejb.Inheritance;
import javax.ejb.InheritanceJoinColumn;
import javax.ejb.InheritanceJoinColumns;
import javax.ejb.InheritanceType;
import javax.ejb.JoinColumn;
import javax.ejb.JoinColumns;
import javax.ejb.ManyToMany;
import javax.ejb.OneToOne;
import javax.ejb.SecondaryTable;
import javax.ejb.SecondaryTables;
import javax.ejb.SequenceGenerator;
import javax.ejb.Table;
import javax.ejb.TableGenerator;
import javax.ejb.Transient;
import javax.ejb.UniqueConstraint;
import javax.ejb.Version;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.AnnotationException;
import org.hibernate.AssertionFailure;
import org.hibernate.FetchMode;
import org.hibernate.MappingException;
import org.hibernate.annotations.BatchSize;
import org.hibernate.annotations.Check;
import org.hibernate.annotations.Proxy;
import org.hibernate.annotations.Type;
import org.hibernate.annotations.Where;
import org.hibernate.cfg.AnnotatedClassType;
import org.hibernate.cfg.AnnotedElementInferredData;
import org.hibernate.cfg.CollectionSecondPass;
import org.hibernate.cfg.Ejb3Column;
import org.hibernate.cfg.Ejb3DiscriminatorColumn;
import org.hibernate.cfg.Ejb3JoinColumn;
import org.hibernate.cfg.ExtendedMappings;
import org.hibernate.cfg.FkSecondPass;
import org.hibernate.cfg.NotYetImplementedException;
import org.hibernate.cfg.PropertyHolder;
import org.hibernate.cfg.PropertyHolderBuilder;
import org.hibernate.cfg.annotations.EntityBinder;
import org.hibernate.id.MultipleHiLoPerTableGenerator;
import org.hibernate.mapping.Bag;
import org.hibernate.mapping.Column;
import org.hibernate.mapping.Component;
import org.hibernate.mapping.DependantValue;
import org.hibernate.mapping.IdGenerator;
import org.hibernate.mapping.Join;
import org.hibernate.mapping.JoinedSubclass;
import org.hibernate.mapping.KeyValue;
import org.hibernate.mapping.ManyToOne;
import org.hibernate.mapping.OneToMany;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Property;
import org.hibernate.mapping.RootClass;
import org.hibernate.mapping.Set;
import org.hibernate.mapping.SimpleValue;
import org.hibernate.mapping.Subclass;
import org.hibernate.mapping.TableOwner;
import org.hibernate.mapping.Value;
import org.hibernate.persister.entity.JoinedSubclassEntityPersister;
import org.hibernate.persister.entity.SingleTableEntityPersister;
import org.hibernate.type.ForeignKeyDirection;
import org.hibernate.util.ReflectHelper;
import org.hibernate.util.StringHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationBinder {
    private static final String GENERATOR_TABLE_NAME_PARAM = "generatorTableName";
    public static final String ANNOTATION_STRING_DEFAULT = "";
    private static final Log log = LogFactory.getLog(AnnotationBinder.class);

    private AnnotationBinder() {
    }

    public static void bindPackage(String packageName, ExtendedMappings mappings) {
        IdGenerator idGen;
        SequenceGenerator ann;
        Package pckg = null;
        try {
            pckg = ReflectHelper.classForName((String)(packageName + ".package-info")).getPackage();
        }
        catch (ClassNotFoundException cnf) {
            log.warn((Object)("Package not found or wo package-info.java: " + packageName));
            return;
        }
        if (pckg.isAnnotationPresent(SequenceGenerator.class)) {
            ann = pckg.getAnnotation(SequenceGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add sequence generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(TableGenerator.class)) {
            ann = pckg.getAnnotation(TableGenerator.class);
            idGen = AnnotationBinder.buildIdGenerator((Annotation)ann);
            mappings.addGenerator(idGen);
            log.debug((Object)("Add table generator with name: " + idGen.getName()));
        }
        if (pckg.isAnnotationPresent(GeneratorTable.class)) {
            ann = pckg.getAnnotation(GeneratorTable.class);
            Properties params = AnnotationBinder.buildPropertiesFromGeneratorTable((GeneratorTable)ann);
            mappings.addGeneratorTable(ann.name(), params);
        }
    }

    private static Properties buildPropertiesFromGeneratorTable(GeneratorTable ann) {
        Properties params = new Properties();
        if (!AnnotationBinder.isDefault(ann.pkColumnName())) {
            params.setProperty("primary_key_column", ann.pkColumnName());
        }
        if (!AnnotationBinder.isDefault(ann.valueColumnName())) {
            params.setProperty("value_column", ann.valueColumnName());
        }
        if (ann.table().specified()) {
            Table table = ann.table();
            if (!AnnotationBinder.isDefault(table.name())) {
                params.setProperty("table", table.name());
            }
            if (!AnnotationBinder.isDefault(table.catalog())) {
                params.setProperty("catalog", table.catalog());
            }
            if (!AnnotationBinder.isDefault(table.schema())) {
                params.setProperty("schema", table.schema());
            }
        } else {
            params.setProperty("table", ann.name());
        }
        return params;
    }

    private static IdGenerator buildIdGenerator(Annotation ann) {
        IdGenerator idGen = new IdGenerator();
        if (ann == null) {
            idGen = null;
        } else if (ann instanceof TableGenerator) {
            TableGenerator tabGen = (TableGenerator)ann;
            idGen.setName(tabGen.name());
            idGen.setIdentifierGeneratorStrategy(MultipleHiLoPerTableGenerator.class.getName());
            if (!AnnotationBinder.isDefault(tabGen.tableName())) {
                idGen.addParam(GENERATOR_TABLE_NAME_PARAM, tabGen.tableName());
            }
            if (!AnnotationBinder.isDefault(tabGen.pkColumnValue())) {
                idGen.addParam("primary_key_value", tabGen.pkColumnValue());
            }
            idGen.addParam("max_lo", String.valueOf(tabGen.allocationSize()));
        } else if (ann instanceof SequenceGenerator) {
            SequenceGenerator seqGen = (SequenceGenerator)ann;
            idGen.setName(seqGen.name());
            idGen.setIdentifierGeneratorStrategy("sequence");
            idGen.addParam("sequence", seqGen.sequenceName());
            if (seqGen.initialValue() != 0 || seqGen.allocationSize() != 50) {
                log.warn((Object)"Hibernate does not support SequenceGenerator.initialValue() nor SequenceGenerator.allocationSize()");
            }
        } else {
            throw new AssertionFailure("Unknown Generator annotation: " + ann);
        }
        return idGen;
    }

    public static void bindClass(Class annotatedClass, ExtendedMappings mappings) throws MappingException {
        if (!mappings.getClassType(annotatedClass).equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Annotated class should have an @Entity annotation: " + annotatedClass.getName());
        }
        Class superClass = annotatedClass.getSuperclass();
        PersistentClass superEntity = mappings.getClass(superClass.getName());
        if (superEntity == null && mappings.getClassType(superClass).equals((Object)AnnotatedClassType.ENTITY)) {
            throw new AnnotationException("Subclass has to be binded after it's mother class: " + superClass.getName());
        }
        boolean isRootClass = superEntity == null;
        boolean isSubClass = false;
        boolean isJoinedSubclass = false;
        String schema = ANNOTATION_STRING_DEFAULT;
        String table = ANNOTATION_STRING_DEFAULT;
        String catalog = ANNOTATION_STRING_DEFAULT;
        String discrimValue = null;
        ArrayList<String[]> uniqueConstraints = new ArrayList<String[]>();
        if (annotatedClass.isAnnotationPresent(Table.class)) {
            Table tabAnn = annotatedClass.getAnnotation(Table.class);
            table = tabAnn.name();
            schema = tabAnn.schema();
            catalog = tabAnn.catalog();
            if (tabAnn.uniqueConstraints().length != 0) {
                for (UniqueConstraint uc : tabAnn.uniqueConstraints()) {
                    if (!uc.primary()) {
                        uniqueConstraints.add(uc.columnNames());
                        continue;
                    }
                    log.warn((Object)"@UniqueConstraint(primaryKey=true) not yet supported");
                }
            }
        }
        Ejb3DiscriminatorColumn discriminatorColumn = null;
        boolean singleTableStrategy = true;
        Ejb3JoinColumn[] joinedColumns = null;
        if (annotatedClass.isAnnotationPresent(Inheritance.class)) {
            Inheritance inhAnn = annotatedClass.getAnnotation(Inheritance.class);
            if (inhAnn.strategy().equals((Object)InheritanceType.TABLE_PER_CLASS)) {
                singleTableStrategy = false;
                if (!isRootClass) {
                    throw new AnnotationException("TABLE_PER_CLASS only allows hierarchy leaf mapping");
                }
            }
            if (inhAnn.strategy().equals((Object)InheritanceType.JOINED)) {
                singleTableStrategy = false;
                boolean bl = isJoinedSubclass = !isRootClass;
                if (isJoinedSubclass) {
                    boolean explicitInheritanceJoinedColumns;
                    InheritanceJoinColumns jcsAnn = annotatedClass.getAnnotation(InheritanceJoinColumns.class);
                    boolean bl2 = explicitInheritanceJoinedColumns = jcsAnn != null && jcsAnn.value().length != 0;
                    if (explicitInheritanceJoinedColumns) {
                        int nbrOfInhJoinedColumns = jcsAnn.value().length;
                        joinedColumns = new Ejb3JoinColumn[nbrOfInhJoinedColumns];
                        for (int colIndex = 0; colIndex < nbrOfInhJoinedColumns; ++colIndex) {
                            InheritanceJoinColumn jcAnn = jcsAnn.value()[colIndex];
                            joinedColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings);
                        }
                    } else {
                        InheritanceJoinColumn jcAnn = annotatedClass.getAnnotation(InheritanceJoinColumn.class);
                        joinedColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn(jcAnn, (Value)superEntity.getIdentifier(), (Map<String, Join>)null, (PropertyHolder)null, mappings)};
                    }
                    log.debug((Object)"Joined column(s) created");
                }
            }
            if (inhAnn.strategy().equals((Object)InheritanceType.SINGLE_TABLE)) {
                singleTableStrategy = true;
                if (annotatedClass.isAnnotationPresent(DiscriminatorColumn.class)) {
                    DiscriminatorColumn discAnn = annotatedClass.getAnnotation(DiscriminatorColumn.class);
                    if (isRootClass) {
                        discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(inhAnn.discriminatorType(), discAnn, mappings);
                    } else {
                        log.warn((Object)"Discriminator should not be defined in a subclass, annotation ignored");
                    }
                }
                discrimValue = inhAnn.discriminatorValue();
            }
        }
        boolean bl = isSubClass = !isRootClass && singleTableStrategy;
        Object persistentClass = isRootClass ? new RootClass() : (isSubClass ? new Subclass(superEntity) : new JoinedSubclass(superEntity));
        Proxy proxyAnn = annotatedClass.getAnnotation(Proxy.class);
        BatchSize sizeAnn = annotatedClass.getAnnotation(BatchSize.class);
        Where whereAnn = annotatedClass.getAnnotation(Where.class);
        Entity entityAnn = annotatedClass.getAnnotation(Entity.class);
        org.hibernate.annotations.Entity hibEntityAnn = annotatedClass.getAnnotation(org.hibernate.annotations.Entity.class);
        EntityBinder entityBinder = new EntityBinder(entityAnn, hibEntityAnn, annotatedClass, (PersistentClass)persistentClass, mappings);
        entityBinder.setDiscriminatorValue(discrimValue);
        entityBinder.setBatchSize(sizeAnn);
        entityBinder.setProxy(proxyAnn);
        entityBinder.setWhere(whereAnn);
        entityBinder.bindEntity();
        if (!isSubClass) {
            Check checkAnn = annotatedClass.getAnnotation(Check.class);
            String constraints = checkAnn == null ? null : checkAnn.constraints();
            AnnotationBinder.bindTable((PersistentClass)persistentClass, schema, catalog, table, uniqueConstraints, constraints, mappings);
        }
        PropertyHolder propertyHolder = PropertyHolderBuilder.buildPropertyHolder((PersistentClass)persistentClass);
        HashMap<String, Join> secondaryTables = new HashMap<String, Join>();
        HashMap<String, Object> secondaryTableJoins = new HashMap<String, Object>();
        if (annotatedClass.isAnnotationPresent(SecondaryTable.class)) {
            SecondaryTable tabAnn = annotatedClass.getAnnotation(SecondaryTable.class);
            AnnotationBinder.prepareForSecondaryTable(tabAnn, (PersistentClass)persistentClass, secondaryTables, secondaryTableJoins, mappings);
        }
        if (annotatedClass.isAnnotationPresent(SecondaryTables.class)) {
            SecondaryTables tabsAnn = annotatedClass.getAnnotation(SecondaryTables.class);
            for (SecondaryTable tab : tabsAnn.value()) {
                AnnotationBinder.prepareForSecondaryTable(tab, (PersistentClass)persistentClass, secondaryTables, secondaryTableJoins, mappings);
            }
        }
        if (isJoinedSubclass) {
            JoinedSubclass jsc = (JoinedSubclass)persistentClass;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(JoinedSubclassEntityPersister.class);
            }
            DependantValue key = new DependantValue(jsc.getTable(), jsc.getIdentifier());
            jsc.setKey((KeyValue)key);
            key.setCascadeDeleteEnabled(false);
            AnnotationBinder.bindFk((PersistentClass)jsc, joinedColumns, (SimpleValue)key);
            jsc.createPrimaryKey();
            jsc.createForeignKey();
        } else if (isSubClass) {
            boolean uninilializedDiscrim;
            if (persistentClass.getEntityPersisterClass() == null) {
                persistentClass.getRootClass().setEntityPersisterClass(SingleTableEntityPersister.class);
            }
            boolean bl3 = uninilializedDiscrim = persistentClass.getRootClass().getDiscriminator() == null;
            if (uninilializedDiscrim) {
                AnnotationBinder.bindDiscriminatorToPersistentClass(persistentClass.getRootClass(), null, secondaryTables, propertyHolder, mappings);
            }
        } else if (singleTableStrategy && isRootClass && discriminatorColumn != null) {
            AnnotationBinder.bindDiscriminatorToPersistentClass(persistentClass, discriminatorColumn, secondaryTables, propertyHolder, mappings);
        }
        HashMap<String, IdGenerator> classGenerators = AnnotationBinder.buildLocalGenerators(annotatedClass);
        HashMap<String, Properties> classGeneratorTables = AnnotationBinder.buildLocalGeneratorTable(annotatedClass);
        Class currentClassInHierarchy = annotatedClass;
        do {
            AnnotationBinder.processElementsOfAClass(propertyHolder, entityBinder.isPropertyAccess(), true, currentClassInHierarchy, classGenerators, classGeneratorTables, secondaryTables, mappings);
            currentClassInHierarchy = currentClassInHierarchy.getSuperclass();
        } while (isRootClass && !Object.class.equals(currentClassInHierarchy));
        if (isRootClass) {
            persistentClass.createPrimaryKey();
        } else {
            superEntity.addSubclass((Subclass)persistentClass);
        }
        mappings.addClass((PersistentClass)persistentClass);
        AnnotationBinder.mapSecondaryTables(secondaryTables, secondaryTableJoins, (PersistentClass)persistentClass, propertyHolder, mappings);
    }

    private static HashMap<String, Properties> buildLocalGeneratorTable(AnnotatedElement annotatedClass) {
        HashMap<String, Properties> result = new HashMap<String, Properties>();
        GeneratorTable ann = annotatedClass.getAnnotation(GeneratorTable.class);
        if (ann != null) {
            result.put(ann.name(), AnnotationBinder.buildPropertiesFromGeneratorTable(ann));
        }
        return result;
    }

    private static void mapSecondaryTables(Map<String, Join> secondaryTables, Map<String, Object> secondaryTableJoins, PersistentClass persistentClass, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Iterator<Join> joins = secondaryTables.values().iterator();
        Iterator<Object> joinColumns = secondaryTableJoins.values().iterator();
        while (joins.hasNext()) {
            Ejb3JoinColumn[] ejb3JoinColumns;
            JoinColumn[] columns = (JoinColumn[])joinColumns.next();
            Join join = joins.next();
            DependantValue key = new DependantValue(join.getTable(), persistentClass.getIdentifier());
            join.setKey((KeyValue)key);
            join.setSequentialSelect(false);
            join.setInverse(false);
            join.setOptional(false);
            key.setCascadeDeleteEnabled(false);
            int nbrOfJoinColumns = columns.length;
            if (nbrOfJoinColumns == 0) {
                ejb3JoinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)null, (Value)persistentClass.getIdentifier(), secondaryTables, propertyHolder, mappings)};
            } else {
                ejb3JoinColumns = new Ejb3JoinColumn[nbrOfJoinColumns];
                for (int colIndex = 0; colIndex < nbrOfJoinColumns; ++colIndex) {
                    ejb3JoinColumns[colIndex] = Ejb3JoinColumn.buildJoinColumn(columns[colIndex], (Value)persistentClass.getIdentifier(), secondaryTables, propertyHolder, mappings);
                }
            }
            for (Ejb3JoinColumn joinColumn : ejb3JoinColumns) {
                joinColumn.forceNotNull();
            }
            AnnotationBinder.bindFk(persistentClass, ejb3JoinColumns, (SimpleValue)key);
            join.createPrimaryKey();
            join.createForeignKey();
            persistentClass.addJoin(join);
        }
        mappings.addJoins(persistentClass, secondaryTables);
    }

    private static void bindDiscriminatorToPersistentClass(RootClass rootClass, Ejb3DiscriminatorColumn discriminatorColumn, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        if (rootClass.getDiscriminator() == null) {
            if (discriminatorColumn == null) {
                Class clazz;
                try {
                    clazz = ReflectHelper.classForName((String)rootClass.getClassName());
                }
                catch (ClassNotFoundException e) {
                    throw new AnnotationException("Root Class not found in classpath: " + rootClass.getClassName());
                }
                Inheritance inhAnn = clazz.getAnnotation(Inheritance.class);
                DiscriminatorType type = inhAnn == null ? null : inhAnn.discriminatorType();
                discriminatorColumn = Ejb3DiscriminatorColumn.buildDiscriminatorColumn(type, null, mappings);
            }
            discriminatorColumn.setJoins(secondaryTables);
            discriminatorColumn.setPropertyHolder(propertyHolder);
            SimpleValue discrim = new SimpleValue(rootClass.getTable());
            rootClass.setDiscriminator((Value)discrim);
            Column col = discriminatorColumn.getMappingColumn();
            col.setValue((Value)discrim);
            discrim.getTable().addColumn(col);
            discrim.addColumn(col);
            discrim.setTypeName(discriminatorColumn.getDiscriminatorTypeName());
            rootClass.setPolymorphic(true);
            log.debug((Object)("Setting discriminator for entity " + rootClass.getEntityName()));
        }
    }

    private static void processElementsOfAClass(PropertyHolder propertyHolder, boolean propertyAccess, boolean isNullable, Class annotatedClass, HashMap<String, IdGenerator> classGenerators, HashMap<String, Properties> classGeneratorTables, Map<String, Join> secondaryTables, ExtendedMappings mappings) {
        AccessibleObject currentElt;
        int index;
        ArrayList<AnnotatedElement> annElts = new ArrayList<AnnotatedElement>();
        ArrayList<AnnotedElementInferredData> inferredDatas = new ArrayList<AnnotedElementInferredData>();
        if (propertyAccess) {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per property access"));
            Method[] methods = annotatedClass.getDeclaredMethods();
            for (index = 0; index < methods.length; ++index) {
                currentElt = methods[index];
                AnnotationBinder.addAnnotatedElement(currentElt, annElts, inferredDatas);
            }
        } else {
            log.debug((Object)("Processing " + propertyHolder.getEntityName() + " per field access"));
            Field[] fields = annotatedClass.getDeclaredFields();
            for (index = 0; index < fields.length; ++index) {
                currentElt = fields[index];
                AnnotationBinder.addAnnotatedElement(currentElt, annElts, inferredDatas);
            }
        }
        int size = annElts.size();
        for (int index2 = 0; index2 < size; ++index2) {
            AnnotationBinder.processElementAnnotations(propertyHolder, isNullable, annElts.get(index2), mappings, inferredDatas.get(index2), classGenerators, classGeneratorTables, secondaryTables);
        }
    }

    private static void addAnnotatedElement(AnnotatedElement elt, ArrayList<AnnotatedElement> annElts, ArrayList<AnnotedElementInferredData> inferredDatas) {
        AnnotedElementInferredData inferredData = new AnnotedElementInferredData(elt);
        if (inferredData.isAnnotable()) {
            if (elt.isAnnotationPresent(Id.class)) {
                annElts.add(0, elt);
                inferredDatas.add(0, inferredData);
            } else {
                annElts.add(elt);
                inferredDatas.add(inferredData);
            }
        }
    }

    public static void bindTable(PersistentClass persistentClass, String schema, String catalog, String tableName, List uniqueConstraints, String constraints, ExtendedMappings mappings) {
        org.hibernate.mapping.Table table = AnnotationBinder.fillTable(schema, catalog, AnnotationBinder.getClassTableName(persistentClass, tableName, mappings), persistentClass.isAbstract(), uniqueConstraints, constraints, mappings);
        if (!(persistentClass instanceof TableOwner)) {
            throw new AssertionFailure("call of AnnBinder.bindTable for a SubClass");
        }
        ((TableOwner)persistentClass).setTable(table);
    }

    public static org.hibernate.mapping.Table fillTable(String schema, String catalog, String realTableName, boolean isAbstract, List uniqueConstraints, String constraints, ExtendedMappings mappings) {
        schema = AnnotationBinder.isDefault(schema) ? (schema = mappings.getSchemaName()) : schema;
        catalog = AnnotationBinder.isDefault(catalog) ? (catalog = mappings.getCatalogName()) : catalog;
        org.hibernate.mapping.Table table = mappings.addTable(schema, catalog, realTableName, null, isAbstract);
        if (uniqueConstraints.size() > 0) {
            mappings.addUniqueConstraints(table, uniqueConstraints);
        }
        if (constraints != null) {
            table.addCheckConstraint(constraints);
        }
        return table;
    }

    private static void processElementAnnotations(PropertyHolder propertyHolder, boolean isNullable, AnnotatedElement annotedElt, ExtendedMappings mappings, AnnotedElementInferredData inferredData, HashMap<String, IdGenerator> classGenerators, HashMap<String, Properties> classGeneratorTables, Map<String, Join> secondaryTables) throws MappingException {
        javax.ejb.Column ann;
        Object columns = null;
        if (annotedElt.isAnnotationPresent(Transient.class)) {
            return;
        }
        log.debug((Object)("Processing " + inferredData.getPropertyName()));
        if (annotedElt.isAnnotationPresent(javax.ejb.Column.class)) {
            ann = annotedElt.getAnnotation(javax.ejb.Column.class);
            columns = Ejb3Column.buildColumnFromAnnotation(ann, propertyHolder, inferredData, secondaryTables, mappings);
        } else if (annotedElt.isAnnotationPresent(JoinColumn.class)) {
            ann = annotedElt.getAnnotation(JoinColumn.class);
            columns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)ann, inferredData.getPropertyName(), secondaryTables, propertyHolder, mappings)};
        } else if (annotedElt.isAnnotationPresent(JoinColumns.class)) {
            ann = annotedElt.getAnnotation(JoinColumns.class);
            JoinColumn[] annColumns = ann.value();
            int length = annColumns.length;
            if (length == 0) {
                throw new AnnotationException("Cannot bind an empty @JoinColumns");
            }
            columns = new Ejb3JoinColumn[length];
            for (int index = 0; index < length; ++index) {
                columns[index] = Ejb3JoinColumn.buildJoinColumn(annColumns[index], inferredData.getPropertyName(), secondaryTables, propertyHolder, mappings);
            }
        } else {
            columns = annotedElt.isAnnotationPresent(javax.ejb.ManyToOne.class) ? new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)null, inferredData.getPropertyName(), secondaryTables, propertyHolder, mappings)} : (annotedElt.isAnnotationPresent(javax.ejb.OneToMany.class) ? new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)null, inferredData.getPropertyName(), secondaryTables, propertyHolder, mappings)} : (annotedElt.isAnnotationPresent(OneToOne.class) ? null : Ejb3Column.buildColumnFromAnnotation(null, propertyHolder, inferredData, secondaryTables, mappings)));
        }
        if (!isNullable) {
            for (Ejb3Column col : columns) {
                col.forceNotNull();
            }
        }
        if (annotedElt.isAnnotationPresent(Id.class)) {
            boolean isComponent;
            log.debug((Object)(inferredData.getPropertyName() + " is an id"));
            ann = annotedElt.getAnnotation(Id.class);
            HashMap localGenerators = (HashMap)classGenerators.clone();
            HashMap localGeneratorTables = (HashMap)classGeneratorTables.clone();
            localGenerators.putAll(AnnotationBinder.buildLocalGenerators(annotedElt));
            localGeneratorTables.putAll(AnnotationBinder.buildLocalGeneratorTable(annotedElt));
            DependentObject depAnn = inferredData.getReturnedClass().getAnnotation(DependentObject.class);
            Dependent overrideAnn = annotedElt.getAnnotation(Dependent.class);
            HashMap<String, javax.ejb.Column[]> columnOverride = new HashMap<String, javax.ejb.Column[]>();
            if (overrideAnn != null) {
                for (DependentAttribute depAttr : overrideAnn.value()) {
                    columnOverride.put(depAttr.name(), depAttr.column());
                }
            }
            boolean bl = isComponent = depAnn != null;
            boolean propertyAccess = isComponent ? depAnn.access() == AccessType.PROPERTY : false;
            AnnotationBinder.bindId(AnnotationBinder.generatorType(ann.generate()), ann.generator(), inferredData, columns[0], (RootClass)propertyHolder.getPersistentClass(), localGenerators, localGeneratorTables, isComponent, columnOverride, propertyAccess, secondaryTables, mappings);
            log.debug((Object)("Bind @Id on " + inferredData.getPropertyName()));
        } else if (annotedElt.isAnnotationPresent(Version.class)) {
            log.debug((Object)(inferredData.getPropertyName() + " is a version property"));
            RootClass rootClass = (RootClass)propertyHolder.getPersistentClass();
            boolean lazy = false;
            Property prop = AnnotationBinder.bindProperty(inferredData.getPropertyName(), inferredData.getReturnedClassName(), lazy, inferredData.getDefaultAccess(), columns[0], PropertyHolderBuilder.buildPropertyHolder((PersistentClass)rootClass), ANNOTATION_STRING_DEFAULT);
            rootClass.setVersion(prop);
            SimpleValue simpleValue = (SimpleValue)prop.getValue();
            if (!simpleValue.isTypeSpecified()) {
                simpleValue.setTypeName("integer");
            }
            simpleValue.setNullValue("undefined");
            rootClass.setOptimisticLockMode(0);
            log.debug((Object)("Version name: " + rootClass.getVersion().getName() + ", unsavedValue: " + ((SimpleValue)rootClass.getVersion().getValue()).getNullValue()));
        } else if (annotedElt.isAnnotationPresent(javax.ejb.ManyToOne.class)) {
            ann = annotedElt.getAnnotation(javax.ejb.ManyToOne.class);
            AnnotationBinder.bindManyToOne(AnnotationBinder.getCascadeStrategy(ann.cascade()), (Ejb3JoinColumn[])columns, ann.optional(), AnnotationBinder.getFetchMode(ann.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, mappings);
        } else if (annotedElt.isAnnotationPresent(OneToOne.class)) {
            ann = annotedElt.getAnnotation(OneToOne.class);
            if (columns == null) {
                columns = new Ejb3JoinColumn[]{};
            }
            AnnotationBinder.bindOneToOne(AnnotationBinder.getCascadeStrategy(ann.cascade()), (Ejb3JoinColumn[])columns, ann.optional(), AnnotationBinder.getFetchMode(ann.fetch()), inferredData.getPropertyName(), inferredData.getReturnedClassName(), ann.targetEntity(), inferredData.getDefaultAccess(), propertyHolder, mappings);
        } else if (annotedElt.isAnnotationPresent(javax.ejb.OneToMany.class)) {
            ann = annotedElt.getAnnotation(javax.ejb.OneToMany.class);
            AnnotationBinder.bindOneToMany(inferredData.getCollectionType(), ann.targetEntity(), inferredData.getPropertyName(), inferredData.getReturnedClass(), AnnotationBinder.getFetchMode(ann.fetch()), (Ejb3JoinColumn[])columns, AnnotationBinder.getCascadeStrategy(ann.cascade()), inferredData.getDefaultAccess(), propertyHolder, AnnotationBinder.bindBatchSize(annotedElt), mappings, AnnotationBinder.bindWhere(annotedElt));
        } else if (annotedElt.isAnnotationPresent(ManyToMany.class)) {
            org.hibernate.mapping.Table assocTable;
            ann = annotedElt.getAnnotation(ManyToMany.class);
            JoinColumn[] annJoins = null;
            JoinColumn[] annInverseJoins = null;
            if (annotedElt.isAnnotationPresent(AssociationTable.class)) {
                AssociationTable atAnn = annotedElt.getAnnotation(AssociationTable.class);
                if (!atAnn.table().specified()) {
                    throw new NotYetImplementedException("Implicit Table in AssociationTable");
                }
                assocTable = AnnotationBinder.fillTable(atAnn.table().schema(), atAnn.table().catalog(), mappings.getNamingStrategy().tableName(atAnn.table().name()), false, new ArrayList(), null, mappings);
                JoinColumn[] joins = atAnn.joinColumns();
                annJoins = joins.length == 0 ? null : joins;
                JoinColumn[] inverseJoins = atAnn.inverseJoinColumns();
                annInverseJoins = inverseJoins.length == 0 ? null : inverseJoins;
            } else {
                throw new NotYetImplementedException("Implicit AssociationTable");
            }
            Ejb3JoinColumn[] joinColumns = AnnotationBinder.buildArrayOfEjb3JoinColumn(annJoins, secondaryTables, propertyHolder, mappings);
            Ejb3JoinColumn[] inverseJoinColumns = AnnotationBinder.buildArrayOfEjb3JoinColumn(annInverseJoins, secondaryTables, propertyHolder, mappings);
            AnnotationBinder.bindManyToMany(inferredData.getCollectionType(), ann.targetEntity(), inferredData.getPropertyName(), inferredData.getReturnedClass(), AnnotationBinder.getFetchMode(ann.fetch()), assocTable, AnnotationBinder.getCascadeStrategy(ann.cascade()), inferredData.getDefaultAccess(), propertyHolder, ann.isInverse(), joinColumns, inverseJoinColumns, AnnotationBinder.bindBatchSize(annotedElt), AnnotationBinder.bindWhere(annotedElt), mappings);
        } else if (mappings.getClassType(inferredData.getReturnedClass()).equals((Object)AnnotatedClassType.DEPENDENT)) {
            ann = inferredData.getReturnedClass().getAnnotation(DependentObject.class);
            boolean propertyAccess = ann.access() == AccessType.PROPERTY;
            Dependent depAnn = annotedElt.getAnnotation(Dependent.class);
            HashMap<String, javax.ejb.Column[]> columnOverride = new HashMap<String, javax.ejb.Column[]>();
            if (depAnn != null) {
                for (DependentAttribute depAttr : depAnn.value()) {
                    columnOverride.put(depAttr.name(), depAttr.column());
                }
            }
            AnnotationBinder.bindComponent(inferredData, propertyHolder, propertyAccess, secondaryTables, columnOverride, mappings);
        } else {
            Basic ann2;
            log.debug((Object)(inferredData.getPropertyName() + " is a property"));
            boolean lazy = false;
            if (annotedElt.isAnnotationPresent(Basic.class) && (ann2 = annotedElt.getAnnotation(Basic.class)).fetch() == FetchType.LAZY) {
                lazy = true;
                log.debug((Object)(inferredData.getPropertyName() + " is lazy"));
            }
            String type = ANNOTATION_STRING_DEFAULT;
            Type annType = annotedElt.getAnnotation(Type.class);
            if (annType != null) {
                type = annType.type();
            }
            AnnotationBinder.bindProperty(inferredData.getPropertyName(), inferredData.getReturnedClassName(), lazy, inferredData.getDefaultAccess(), columns[0], propertyHolder, type);
        }
    }

    private static String bindWhere(AnnotatedElement annotedElt) {
        Where ann = annotedElt.getAnnotation(Where.class);
        return ann == null ? null : ann.clause();
    }

    private static int bindBatchSize(AnnotatedElement annotedElt) {
        BatchSize batchAnn = annotedElt.getAnnotation(BatchSize.class);
        return batchAnn == null ? -1 : batchAnn.size();
    }

    private static Ejb3JoinColumn[] buildArrayOfEjb3JoinColumn(JoinColumn[] annJoins, Map<String, Join> secondaryTables, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        Ejb3JoinColumn[] joinColumns;
        if (annJoins == null) {
            joinColumns = new Ejb3JoinColumn[]{Ejb3JoinColumn.buildJoinColumn((JoinColumn)null, (String)null, secondaryTables, propertyHolder, mappings)};
        } else {
            joinColumns = new Ejb3JoinColumn[annJoins.length];
            for (JoinColumn annJoin : annJoins) {
                joinColumns[index] = Ejb3JoinColumn.buildJoinColumn(annJoin, (String)null, secondaryTables, propertyHolder, mappings);
            }
        }
        return joinColumns;
    }

    private static void bindComponent(AnnotedElementInferredData inferredData, PropertyHolder propertyHolder, boolean propertyAccess, Map<String, Join> secondaryTables, Map<String, javax.ejb.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = AnnotationBinder.fillComponent(propertyHolder, inferredData, propertyAccess, true, secondaryTables, columnOverride, mappings);
        Property prop = AnnotationBinder.makeProperty(inferredData.getPropertyName(), (Value)comp, true, true, false, null, inferredData.getDefaultAccess());
        propertyHolder.addProperty(prop);
    }

    private static Component fillComponent(PropertyHolder propertyHolder, AnnotedElementInferredData inferredData, boolean propertyAccess, boolean isNullable, Map<String, Join> secondaryTables, Map<String, javax.ejb.Column[]> columnOverride, ExtendedMappings mappings) {
        Component comp = new Component(propertyHolder.getPersistentClass());
        comp.setComponentClassName(inferredData.getReturnedClassName());
        String subpath = StringHelper.qualify((String)propertyHolder.getPath(), (String)inferredData.getPropertyName());
        log.debug((Object)("Binding component with path: " + subpath));
        PropertyHolder subHolder = PropertyHolderBuilder.buildPropertyHolder(comp, subpath, columnOverride);
        AnnotationBinder.processElementsOfAClass(subHolder, propertyAccess, isNullable, inferredData.getReturnedClass(), new HashMap<String, IdGenerator>(), new HashMap<String, Properties>(), secondaryTables, mappings);
        return comp;
    }

    private static void bindId(String generatorType, String generatorName, AnnotedElementInferredData inferredData, Ejb3Column column, RootClass rootClass, Map<String, IdGenerator> localGenerators, HashMap<String, Properties> localGeneratorTables, boolean isComposite, Map<String, javax.ejb.Column[]> columnOverride, boolean isPropertyAccess, Map<String, Join> secondaryTables, ExtendedMappings mappings) {
        Component id;
        String persistentClassName;
        String string = persistentClassName = rootClass == null ? null : rootClass.getClassName();
        if (isComposite) {
            id = AnnotationBinder.fillComponent(PropertyHolderBuilder.buildPropertyHolder((PersistentClass)rootClass), inferredData, isPropertyAccess, false, secondaryTables, columnOverride, mappings);
        } else {
            column.forceNotNull();
            id = AnnotationBinder.makeSimpleValue(inferredData.getPropertyName(), inferredData.getReturnedClassName(), column, persistentClassName, ANNOTATION_STRING_DEFAULT);
        }
        rootClass.setIdentifier((KeyValue)id);
        org.hibernate.mapping.Table table = id.getTable();
        table.setIdentifierValue((KeyValue)id);
        id.setIdentifierGeneratorStrategy(generatorType);
        if (generatorType == "assigned") {
            id.setNullValue("undefined");
        }
        Properties params = new Properties();
        params.setProperty("target_table", table.getName());
        params.setProperty("target_column", ((Column)id.getColumnIterator().next()).getName());
        if (!AnnotationBinder.isDefault(generatorName)) {
            IdGenerator gen = mappings.getGenerator(generatorName, localGenerators);
            if (gen == null) {
                throw new AnnotationException("Unknown Id.generator: " + generatorName);
            }
            if (!gen.getIdentifierGeneratorStrategy().equals(generatorType)) {
                throw new AnnotationException("Incompatible generator between Id.generate and its named generator: " + generatorType + "!=" + generatorName);
            }
            for (Map.Entry<Object, Object> elt : gen.getParams().entrySet()) {
                params.setProperty((String)elt.getKey(), (String)elt.getValue());
            }
            if (MultipleHiLoPerTableGenerator.class.getName().equals(generatorType)) {
                AnnotationBinder.fillGeneratorWithGeneratorTableParams(params, localGeneratorTables, generatorName, mappings);
            }
        }
        id.setIdentifierGeneratorProperties(params);
        Property prop = AnnotationBinder.makeProperty(inferredData.getPropertyName(), (Value)id, true, true, false, null, inferredData.getDefaultAccess());
        rootClass.setIdentifierProperty(prop);
    }

    private static void fillGeneratorWithGeneratorTableParams(Properties params, HashMap<String, Properties> localGeneratorTables, String generatorName, ExtendedMappings mappings) {
        String generatorTableName = params.getProperty(GENERATOR_TABLE_NAME_PARAM);
        Properties props = mappings.getGeneratorTableProperties(generatorTableName, localGeneratorTables);
        if (props == null) {
            if ("hibernate_sequences".equals(generatorTableName)) {
                return;
            }
            throw new AnnotationException("Unable to find a @GeneratorTable for table name in " + generatorName + ": " + generatorTableName);
        }
        for (Map.Entry<Object, Object> property : props.entrySet()) {
            params.setProperty((String)property.getKey(), (String)property.getValue());
        }
    }

    private static SimpleValue makeSimpleValue(String propertyName, String returnedClassName, Ejb3Column column, String persistentClassName, String explicitType) {
        log.debug((Object)("making simplevalue for " + propertyName));
        org.hibernate.mapping.Table table = column.getTable();
        SimpleValue simpleValue = new SimpleValue(table);
        return AnnotationBinder.fillSimpleValue(simpleValue, propertyName, returnedClassName, column, persistentClassName, explicitType);
    }

    private static SimpleValue fillSimpleValue(SimpleValue simpleValue, String propertyName, String returnedClassName, Ejb3Column column, String persistentClassName, String explicitType) {
        String type = AnnotationBinder.isDefault(explicitType) ? returnedClassName : explicitType;
        simpleValue.setTypeName(type);
        if (persistentClassName != null) {
            simpleValue.setTypeUsingReflection(persistentClassName, propertyName);
        }
        column.linkWithValue(simpleValue);
        return simpleValue;
    }

    private static Property bindProperty(String name, String returnedClassName, boolean lazy, String propertyAccessorName, Ejb3Column column, PropertyHolder propertyHolder, String explicitType) {
        log.debug((Object)("binding property " + name));
        String containerClassName = propertyHolder == null ? null : propertyHolder.getClassName();
        SimpleValue propertyValue = AnnotationBinder.makeSimpleValue(name, returnedClassName, column, containerClassName, explicitType);
        Property prop = AnnotationBinder.makeProperty(name, (Value)propertyValue, column.isInsertable(), column.isUpdatable(), lazy, null, propertyAccessorName);
        column.addPropertyToMappingContainer(prop);
        return prop;
    }

    private static Property makeProperty(String propertyName, Value value, boolean insertable, boolean updatable, boolean lazy, String cascade, String propertyAccessorName) {
        log.debug((Object)("Building property " + propertyName));
        Property prop = new Property();
        prop.setName(propertyName);
        prop.setValue(value);
        prop.setInsertable(insertable);
        prop.setUpdateable(updatable);
        prop.setLazy(lazy);
        prop.setCascade(cascade);
        prop.setPropertyAccessorName(propertyAccessorName);
        log.debug((Object)("Cascading " + propertyName + " with " + cascade));
        return prop;
    }

    private static void bindManyToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, String targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        ManyToOne value = new ManyToOne(columns[0].getTable());
        if (AnnotationBinder.isDefault(targetEntity)) {
            value.setReferencedEntityName(returnedClassName);
        } else {
            value.setReferencedEntityName(targetEntity);
        }
        value.setFetchMode(fetchMode);
        if (!optional) {
            log.warn((Object)new NotYetImplementedException("ManyToOne.optional() == false"));
        }
        value.setTypeName(returnedClassName);
        value.setTypeUsingReflection(propertyHolder.getClassName(), propertyName);
        String propertyRef = value.getReferencedPropertyName();
        if (propertyRef != null) {
            mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
        }
        mappings.addSecondPass(new FkSecondPass((Value)value, columns, mappings));
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)value, true, true, false, cascadeStrategy, propertyAccessorName);
        prop.setCascade(cascadeStrategy);
        columns[0].addPropertyToMappingContainer(prop);
    }

    public static void bindFkSecondPass(ManyToOne manyToOne, Ejb3JoinColumn[] columns, Map persistentClasses) {
        PersistentClass ref = (PersistentClass)persistentClasses.get(manyToOne.getReferencedEntityName());
        if (ref == null) {
            throw new AnnotationException("Unable to find entity " + manyToOne.getReferencedEntityName());
        }
        AnnotationBinder.bindFk(ref, columns, (SimpleValue)manyToOne);
    }

    private static void bindFk(PersistentClass referencedEntity, Ejb3JoinColumn[] columns, SimpleValue value) {
        if (referencedEntity.getIdentifier().getColumnSpan() == 1) {
            if (columns.length != 1) {
                throw new AnnotationException("@JoinColumns with " + columns.length + " columns" + " refers to " + referencedEntity.getEntityName() + " which has a " + referencedEntity.getIdentifier().getColumnSpan() + " sized PK");
            }
            columns[0].linkWithValue(value);
        } else {
            boolean noReferencedColumn = true;
            for (Ejb3JoinColumn joinCol : columns) {
                if (!StringHelper.isNotEmpty((String)joinCol.getReferencedColumn())) continue;
                noReferencedColumn = false;
                break;
            }
            if (noReferencedColumn) {
                if (columns.length != referencedEntity.getIdentifier().getColumnSpan()) {
                    throw new AnnotationException("A Foreign key refering " + referencedEntity.getEntityName() + " has the wrong number of column. should be " + referencedEntity.getIdentifier().getColumnSpan());
                }
                for (Ejb3JoinColumn joinCol : columns) {
                    joinCol.linkWithValue(value);
                }
            } else {
                Iterator idColItr = referencedEntity.getIdentifier().getColumnIterator();
                if (!idColItr.hasNext()) {
                    log.debug((Object)"No column in the identifier!");
                }
                while (idColItr.hasNext()) {
                    boolean match = false;
                    Column col = (Column)idColItr.next();
                    for (Ejb3JoinColumn joinCol : columns) {
                        if (!joinCol.getReferencedColumn().equals(col.getName())) continue;
                        joinCol.linkWithValue(value);
                        match = true;
                        break;
                    }
                    if (match) continue;
                    throw new AnnotationException("Column name " + col.getName() + " of " + referencedEntity.getEntityName() + " not found in JoinColumns.referencedColumnName");
                }
            }
        }
        value.createForeignKey();
    }

    private static void bindOneToOne(String cascadeStrategy, Ejb3JoinColumn[] columns, boolean optional, FetchMode fetchMode, String propertyName, String returnedClassName, String targetEntity, String propertyAccessorName, PropertyHolder propertyHolder, ExtendedMappings mappings) {
        log.debug((Object)("Fetching " + propertyName + " with " + fetchMode));
        Iterator idColumns = propertyHolder.getIdentifier().getColumnIterator();
        ArrayList<String> idColumnNames = new ArrayList<String>();
        while (idColumns.hasNext()) {
            Column currentColumn = (Column)idColumns.next();
            idColumnNames.add(currentColumn.getName());
        }
        boolean trueOneToOne = true;
        for (Ejb3JoinColumn col : columns) {
            if (idColumnNames.contains(col.getMappingColumn().getName())) continue;
            trueOneToOne = false;
            break;
        }
        if (trueOneToOne) {
            boolean constrained;
            org.hibernate.mapping.OneToOne value = new org.hibernate.mapping.OneToOne(propertyHolder.getTable(), propertyHolder.getIdentifier());
            if (AnnotationBinder.isDefault(targetEntity)) {
                value.setReferencedEntityName(returnedClassName);
            } else {
                value.setReferencedEntityName(targetEntity);
            }
            value.setFetchMode(fetchMode);
            if (!optional) {
                log.warn((Object)new NotYetImplementedException("OneToOne.optional()"));
            }
            value.setForeignKeyType((constrained = false) ? ForeignKeyDirection.FOREIGN_KEY_FROM_PARENT : ForeignKeyDirection.FOREIGN_KEY_TO_PARENT);
            String propertyRef = value.getReferencedPropertyName();
            if (propertyRef != null) {
                mappings.addUniquePropertyReference(value.getReferencedEntityName(), propertyRef);
            }
            Property prop = AnnotationBinder.makeProperty(propertyName, (Value)value, true, true, false, cascadeStrategy, propertyAccessorName);
            prop.setCascade(cascadeStrategy);
            propertyHolder.addProperty(prop);
        } else {
            AnnotationBinder.bindManyToOne(cascadeStrategy, columns, optional, fetchMode, propertyName, returnedClassName, targetEntity, propertyAccessorName, propertyHolder, mappings);
        }
    }

    private static void bindOneToMany(Class collectionType, String targetEntity, String propertyName, Class returnedClass, FetchMode fetchMode, Ejb3JoinColumn[] columns, String cascadeStrategy, String propertyAccessorName, PropertyHolder propertyHolder, int batchSize, ExtendedMappings mappings, String where) {
        for (Ejb3JoinColumn column : columns) {
            if (!column.isSecondary()) continue;
            throw new NotYetImplementedException("Collections having FK in secondary table");
        }
        org.hibernate.mapping.Collection collection = AnnotationBinder.fillCollection(propertyName, returnedClass, fetchMode, propertyHolder, batchSize, where);
        collection.setInverse(true);
        OneToMany oneToMany = new OneToMany(collection.getOwner());
        collection.setElement((Value)oneToMany);
        oneToMany.setReferencedEntityName(AnnotationBinder.getCollectionType(collectionType, targetEntity));
        mappings.addSecondPass(new CollectionSecondPass(mappings, collection, columns));
        mappings.addCollection(collection);
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)collection, true, true, false, cascadeStrategy, propertyAccessorName);
        propertyHolder.addProperty(prop);
    }

    private static void bindManyToMany(Class collectionType, String targetEntity, String propertyName, Class returnedClass, FetchMode fetchMode, org.hibernate.mapping.Table table, String cascadeStrategy, String propertyAccessorName, PropertyHolder propertyHolder, boolean isInverse, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, int batchSize, String where, ExtendedMappings mappings) {
        log.debug((Object)("Binding ManyToMany: " + propertyName));
        org.hibernate.mapping.Collection collection = AnnotationBinder.fillCollection(propertyName, returnedClass, fetchMode, propertyHolder, batchSize, where);
        collection.setInverse(isInverse);
        collection.setCollectionTable(table);
        String collType = AnnotationBinder.getCollectionType(collectionType, targetEntity);
        mappings.addSecondPass(new CollectionSecondPass(mappings, collection, joinColumns, inverseJoinColumns, collType, fetchMode));
        mappings.addCollection(collection);
        Property prop = AnnotationBinder.makeProperty(propertyName, (Value)collection, true, true, false, cascadeStrategy, propertyAccessorName);
        propertyHolder.addProperty(prop);
    }

    private static org.hibernate.mapping.Collection fillCollection(String propertyName, Class returnedClass, FetchMode fetchMode, PropertyHolder propertyHolder, int batchSize, String where) {
        Set collection;
        if (returnedClass.equals(java.util.Set.class)) {
            collection = new Set(propertyHolder.getPersistentClass());
        } else if (returnedClass.equals(Collection.class)) {
            collection = new Bag(propertyHolder.getPersistentClass());
        } else {
            throw new AnnotationException(returnedClass.getName() + " collection not yet supported");
        }
        log.debug((Object)("Collection role: " + StringHelper.qualify((String)propertyHolder.getPath(), (String)propertyName)));
        collection.setRole(StringHelper.qualify((String)propertyHolder.getPath(), (String)propertyName));
        collection.setFetchMode(fetchMode);
        collection.setLazy(fetchMode == FetchMode.SELECT);
        collection.setBatchSize(batchSize);
        if (StringHelper.isNotEmpty((String)where)) {
            collection.setWhere(where);
        }
        return collection;
    }

    private static String getCollectionType(Class collectionType, String targetEntity) {
        if (AnnotationBinder.isDefault(targetEntity)) {
            if (collectionType != null) {
                return collectionType.getName();
            }
            throw new AnnotationException("Collection has neither generic type or OneToMany.targetEntity() defined");
        }
        return targetEntity;
    }

    public static void bindCollectionSecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] columns, ExtendedMappings mappings) throws MappingException {
        String propRef;
        if (collValue.isOneToMany()) {
            OneToMany oneToMany = (OneToMany)collValue.getElement();
            String assocClass = oneToMany.getReferencedEntityName();
            PersistentClass persistentClass = (PersistentClass)persistentClasses.get(assocClass);
            if (mappings == null) {
                throw new AssertionFailure("CollectionSecondPass for oneToMany should not be called with null mappings");
            }
            Map<String, Join> joins = mappings.getJoins(assocClass);
            if (persistentClass == null) {
                throw new MappingException("Association references unmapped class: " + assocClass);
            }
            oneToMany.setAssociatedClass(persistentClass);
            for (Ejb3JoinColumn column : columns) {
                column.setPersistentClass(persistentClass);
                column.setJoins(joins);
                collValue.setCollectionTable(column.getTable());
            }
            log.info((Object)("Mapping collection: " + collValue.getRole() + " -> " + collValue.getCollectionTable().getName()));
        }
        KeyValue keyVal = (propRef = collValue.getReferencedPropertyName()) == null ? collValue.getOwner().getIdentifier() : (KeyValue)collValue.getOwner().getProperty(propRef).getValue();
        DependantValue key = new DependantValue(collValue.getCollectionTable(), keyVal);
        key.setTypeName(null);
        AnnotationBinder.bindFk(collValue.getOwner(), columns, (SimpleValue)key);
        collValue.setKey((KeyValue)key);
    }

    public static void bindManyToManySecondPass(org.hibernate.mapping.Collection collValue, Map persistentClasses, Ejb3JoinColumn[] joinColumns, Ejb3JoinColumn[] inverseJoinColumns, String collType, FetchMode fetchMode) throws MappingException {
        AnnotationBinder.bindCollectionSecondPass(collValue, persistentClasses, joinColumns, null);
        ManyToOne element = new ManyToOne(collValue.getCollectionTable());
        collValue.setElement((Value)element);
        element.setReferencedEntityName(collType);
        element.setFetchMode(fetchMode);
        PersistentClass persistentClass = (PersistentClass)persistentClasses.get(collType);
        if (persistentClass == null) {
            throw new MappingException("Association references unmapped class: " + collType);
        }
        AnnotationBinder.bindFk(persistentClass, inverseJoinColumns, (SimpleValue)element);
    }

    private static String generatorType(GeneratorType generatorEnum) {
        switch (generatorEnum) {
            case NONE: {
                return "assigned";
            }
            case IDENTITY: {
                return "identity";
            }
            case AUTO: {
                return "native";
            }
            case TABLE: {
                return MultipleHiLoPerTableGenerator.class.getName();
            }
            case SEQUENCE: {
                return "sequence";
            }
        }
        throw new AssertionFailure("Unknown GeneratorType: " + generatorEnum);
    }

    private static String getClassTableName(PersistentClass model, String tableName, ExtendedMappings mappings) {
        if (StringHelper.isEmpty((String)tableName)) {
            return mappings.getNamingStrategy().classToTableName(model.getEntityName());
        }
        return mappings.getNamingStrategy().tableName(tableName);
    }

    private static String getCascadeStrategy(CascadeType[] cascades) {
        if (cascades.length == 0) {
            return "none";
        }
        boolean all = false;
        boolean create = false;
        boolean merge = false;
        boolean remove = false;
        block6: for (CascadeType cascade : cascades) {
            switch (cascade) {
                case ALL: {
                    all = true;
                    continue block6;
                }
                case CREATE: {
                    create = true;
                    continue block6;
                }
                case MERGE: {
                    merge = true;
                    continue block6;
                }
                case REMOVE: {
                    remove = true;
                }
            }
        }
        if (!all) {
            boolean bl = all = create && merge && remove;
        }
        if (all) {
            return "all";
        }
        if (create && merge) {
            return "persist,merge,save-update";
        }
        if (create && remove) {
            return "persist,delete,save-update";
        }
        if (merge && remove) {
            return "merge,delete,save-update";
        }
        if (remove) {
            return "delete";
        }
        if (create) {
            return "persist,save-update";
        }
        if (merge) {
            return "merge,save-update";
        }
        throw new AssertionFailure("Error in cascade strategies mapper");
    }

    private static FetchMode getFetchMode(FetchType fetch) {
        if (fetch == FetchType.EAGER) {
            return FetchMode.JOIN;
        }
        return FetchMode.SELECT;
    }

    private static HashMap<String, IdGenerator> buildLocalGenerators(AnnotatedElement annElt) {
        IdGenerator idGen;
        HashMap<String, IdGenerator> generators = new HashMap<String, IdGenerator>();
        TableGenerator tabGen = annElt.getAnnotation(TableGenerator.class);
        SequenceGenerator seqGen = annElt.getAnnotation(SequenceGenerator.class);
        if (tabGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)tabGen);
            generators.put(idGen.getName(), idGen);
        }
        if (seqGen != null) {
            idGen = AnnotationBinder.buildIdGenerator((Annotation)seqGen);
            generators.put(idGen.getName(), idGen);
        }
        return generators;
    }

    private static void prepareForSecondaryTable(SecondaryTable tabAnn, PersistentClass persistentClass, Map<String, Join> secondaryTables, Map<String, Object> secondaryTableJoins, ExtendedMappings mappings) {
        Join join = new Join();
        join.setPersistentClass(persistentClass);
        ArrayList<String[]> uniqueConstraints = new ArrayList<String[]>();
        if (tabAnn.uniqueConstraints().length != 0) {
            for (UniqueConstraint uc : tabAnn.uniqueConstraints()) {
                if (!uc.primary()) {
                    uniqueConstraints.add(uc.columnNames());
                    continue;
                }
                log.warn((Object)"@UniqueConstraint(primaryKey=true) not yet supported");
            }
        }
        org.hibernate.mapping.Table tableMapping = AnnotationBinder.fillTable(tabAnn.schema(), tabAnn.catalog(), tabAnn.name(), false, uniqueConstraints, null, mappings);
        join.setTable(tableMapping);
        secondaryTableJoins.put(tabAnn.name(), tabAnn.join());
        log.info((Object)("Mapping class join: " + persistentClass.getEntityName() + " -> " + join.getTable().getName()));
        secondaryTables.put(tabAnn.name(), join);
    }

    public static boolean isDefault(String annotationString) {
        return ANNOTATION_STRING_DEFAULT.equals(annotationString);
    }
}

