/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.Clause;
import org.helenus.driver.CreateType;
import org.helenus.driver.StatementBridge;
import org.helenus.driver.VoidFuture;
import org.helenus.driver.impl.ClassInfoImpl;
import org.helenus.driver.impl.ClauseImpl;
import org.helenus.driver.impl.FieldInfoImpl;
import org.helenus.driver.impl.ForwardingStatementImpl;
import org.helenus.driver.impl.GroupStatementImpl;
import org.helenus.driver.impl.SimpleStatementImpl;
import org.helenus.driver.impl.StatementImpl;
import org.helenus.driver.impl.StatementManagerImpl;
import org.helenus.driver.impl.TableInfoImpl;
import org.helenus.driver.impl.UDTClassInfoImpl;
import org.helenus.driver.impl.UDTTypeClassInfoImpl;
import org.helenus.driver.impl.Utils;

public class CreateTypeImpl<T>
extends GroupStatementImpl<Void, VoidFuture, T>
implements CreateType<T> {
    private final WhereImpl<T> where = new WhereImpl(this);
    private volatile boolean ifNotExists;

    public CreateTypeImpl(ClassInfoImpl.Context context, StatementManagerImpl mgr, StatementBridge bridge) {
        super(Void.class, context, mgr, bridge);
    }

    protected StringBuilder[] buildQueryStrings(UDTClassInfoImpl<T> ucinfo) {
        TableInfoImpl<T> table = ucinfo.getTableImpl();
        ArrayList<String> columns = new ArrayList<String>(table.getColumns().size());
        for (FieldInfoImpl<T> field : table.getColumnsImpl()) {
            if (field.isTypeKey() && ucinfo instanceof UDTTypeClassInfoImpl) continue;
            columns.add(field.getColumnName() + " " + field.getDataType().toCQL());
        }
        StringBuilder builder = new StringBuilder();
        builder.append("CREATE TYPE ");
        if (this.ifNotExists) {
            builder.append("IF NOT EXISTS ");
        }
        if (this.getKeyspace() != null) {
            Utils.appendName(builder, this.getKeyspace()).append(".");
        }
        Utils.appendName(builder, ucinfo.getName());
        builder.append(" (").append(StringUtils.join(columns, (String)",")).append(')');
        builder.append(';');
        return new StringBuilder[]{builder};
    }

    @Override
    protected final List<StatementImpl<?, ?, ?>> buildGroupedStatements() {
        StringBuilder[] bs;
        ClassInfoImpl cinfo = (ClassInfoImpl)this.getClassInfo();
        if (cinfo instanceof UDTClassInfoImpl && (bs = this.buildQueryStrings((UDTClassInfoImpl)cinfo)) != null) {
            return Arrays.stream(bs).filter(b -> b != null && b.length() != 0).map(b -> this.init(new SimpleStatementImpl(b.toString(), this.mgr, this.bridge))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    @Override
    protected void appendGroupSubType(StringBuilder builder) {
        builder.append(" CREATE TYPE");
    }

    public CreateType<T> ifNotExists() {
        this.ifNotExists = true;
        this.setDirty();
        return this;
    }

    public CreateType.Where<T> where(Clause clause) {
        return this.where.and(clause);
    }

    public CreateType.Where<T> where() {
        return this.where;
    }

    public static class WhereImpl<T>
    extends ForwardingStatementImpl<Void, VoidFuture, T, CreateTypeImpl<T>>
    implements CreateType.Where<T> {
        WhereImpl(CreateTypeImpl<T> statement) {
            super(statement);
        }

        public CreateType.Where<T> and(Clause clause) {
            Validate.notNull((Object)clause, (String)"invalid null clause", (Object[])new Object[0]);
            Validate.isTrue((boolean)(clause instanceof ClauseImpl), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
            Validate.isTrue((!(clause instanceof ClauseImpl.DelayedWithObject) ? 1 : 0) != 0, (String)"unsupported clause '%s' for a CREATE TYPE statement", (Object[])new Object[]{clause});
            ClassInfoImpl.Context context = this.getContext();
            ClassInfoImpl cinfo = context.getClassInfo();
            if (clause instanceof ClauseImpl.Delayed) {
                for (Clause clause2 : ((ClauseImpl.Delayed)clause).processWith(cinfo)) {
                    this.and(clause2);
                }
            } else {
                Validate.isTrue((boolean)(clause instanceof Clause.Equality), (String)"unsupported class of clauses: %s", (Object[])new Object[]{clause.getClass().getName()});
                ClauseImpl c = (ClauseImpl)clause;
                if (c instanceof ClauseImpl.CompoundEqClauseImpl) {
                    ClauseImpl.Compound compound = (ClauseImpl.Compound)((Object)c);
                    List<String> names = compound.getColumnNames();
                    List<?> values = compound.getColumnValues();
                    for (int i = 0; i < names.size(); ++i) {
                        context.addKeyspaceKey(names.get(i), values.get(i));
                    }
                } else {
                    context.addKeyspaceKey(c.getColumnName().toString(), c.firstValue());
                }
                this.setDirty();
            }
            return this;
        }
    }
}

