/*
 * Decompiled with CFR 0.152.
 */
package org.helenus.driver.impl;

import com.datastax.driver.core.ColumnDefinitions;
import com.datastax.driver.core.ExecutionInfo;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.ExecutionList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Spliterators;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.Validate;
import org.helenus.driver.ObjectNotFoundException;
import org.helenus.driver.ObjectSet;
import org.helenus.driver.ObjectSetFuture;
import org.helenus.driver.StatementManager;
import org.helenus.driver.TooManyMatchesFoundException;
import org.helenus.driver.impl.StatementManagerImpl;

public class CompoundObjectSetFuture<T>
extends AbstractFuture<ObjectSet<T>>
implements ObjectSetFuture<T> {
    private final ExecutionList executionList = new ExecutionList();
    private final StatementManager.Context<T> context;
    private final List<ObjectSetFuture<T>> futures;
    private final BitSet called;

    public CompoundObjectSetFuture(StatementManager.Context<T> context, List<ObjectSetFuture<T>> futures, StatementManagerImpl mgr) {
        ObjectSetFuture oset;
        int i;
        Validate.notNull(context, (String)"invalid null context", (Object[])new Object[0]);
        Validate.notNull(futures, (String)"invalid null result set futures", (Object[])new Object[0]);
        Validate.notNull((Object)((Object)mgr), (String)"invalid null mgr", (Object[])new Object[0]);
        this.context = context;
        ArrayList<ObjectSetFuture<T>> osets = new ArrayList<ObjectSetFuture<T>>(futures.size());
        this.called = new BitSet(futures.size());
        for (i = 0; i < futures.size(); ++i) {
            oset = futures.get(i);
            Validate.notNull(oset, (String)"invalid null object set future", (Object[])new Object[0]);
            osets.add(oset);
            this.called.set(i);
        }
        this.futures = osets;
        i = 0;
        while (i < osets.size()) {
            oset = (ObjectSetFuture)osets.get(i);
            final int index = i++;
            oset.addListener(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    boolean execute = false;
                    try {
                        BitSet bitSet = CompoundObjectSetFuture.this.called;
                        synchronized (bitSet) {
                            CompoundObjectSetFuture.this.called.clear(index);
                            if (CompoundObjectSetFuture.this.called.isEmpty()) {
                                execute = true;
                            }
                        }
                    }
                    finally {
                        if (execute) {
                            CompoundObjectSetFuture.this.executionList.execute();
                        }
                    }
                }
            }, (Executor)mgr.getDirectExecutor());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        List<ObjectSetFuture<T>> list = this.futures;
        synchronized (list) {
            for (ObjectSetFuture<T> future : this.futures) {
                if (future.isDone()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isCancelled() {
        List<ObjectSetFuture<T>> list = this.futures;
        synchronized (list) {
            for (ObjectSetFuture<T> future : this.futures) {
                if (future.isCancelled()) continue;
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = true;
        List<ObjectSetFuture<T>> list = this.futures;
        synchronized (list) {
            for (ObjectSetFuture<T> future : this.futures) {
                if (future.cancel(mayInterruptIfRunning)) continue;
                cancelled = false;
            }
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet<T> get(long timeout, TimeUnit unit) throws InterruptedException, TimeoutException, ExecutionException {
        long end = System.nanoTime() + unit.toNanos(timeout);
        ArrayList results = new ArrayList(this.futures.size());
        List<ObjectSetFuture<T>> list = this.futures;
        synchronized (list) {
            for (ObjectSetFuture<T> future : this.futures) {
                ObjectSet result = future.get(end - System.nanoTime(), TimeUnit.NANOSECONDS);
                results.add(result);
            }
        }
        return new CompoundObjectSet<T>(this.context, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet<T> get() throws InterruptedException, ExecutionException {
        ArrayList results = new ArrayList(this.futures.size());
        List<ObjectSetFuture<T>> list = this.futures;
        synchronized (list) {
            for (ObjectSetFuture<T> future : this.futures) {
                results.add(future.get());
            }
        }
        return new CompoundObjectSet<T>(this.context, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet<T> getUninterruptibly() {
        ArrayList results = new ArrayList(this.futures.size());
        List<ObjectSetFuture<T>> list = this.futures;
        synchronized (list) {
            for (ObjectSetFuture<T> future : this.futures) {
                results.add(future.getUninterruptibly());
            }
        }
        return new CompoundObjectSet<T>(this.context, results);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ObjectSet<T> getUninterruptibly(long timeout, TimeUnit unit) throws TimeoutException {
        long end = System.nanoTime() + unit.toNanos(timeout);
        ArrayList results = new ArrayList(this.futures.size());
        List<ObjectSetFuture<T>> list = this.futures;
        synchronized (list) {
            for (ObjectSetFuture<T> future : this.futures) {
                ObjectSet result = future.getUninterruptibly(end - System.nanoTime(), TimeUnit.NANOSECONDS);
                results.add(result);
            }
        }
        return new CompoundObjectSet<T>(this.context, results);
    }

    public void addListener(Runnable listener, Executor exec) {
        this.executionList.add(listener, exec);
    }

    private static class CompoundObjectSet<T>
    implements ObjectSet<T> {
        private final StatementManager.Context<T> context;
        private final List<ObjectSet<T>> objects;
        private volatile Predicate<? super T> filter = t -> true;
        private int i = 0;

        CompoundObjectSet(StatementManager.Context<T> context, List<ObjectSet<T>> objects) {
            this.context = context;
            this.objects = objects;
        }

        public ColumnDefinitions getColumnDefinitions() {
            return this.objects.get(0).getColumnDefinitions();
        }

        public boolean wasApplied() {
            return this.objects.stream().allMatch(os -> os.wasApplied());
        }

        public boolean isExhausted() {
            if (this.i >= this.objects.size()) {
                return true;
            }
            ObjectSet<T> current = this.objects.get(this.i);
            while (current.isExhausted()) {
                if (++this.i >= this.objects.size()) {
                    return true;
                }
                current = this.objects.get(this.i);
            }
            return false;
        }

        public T one() {
            while (!this.isExhausted()) {
                Object n = this.objects.get(this.i).one();
                if (!this.filter.test(n)) continue;
                return (T)n;
            }
            return null;
        }

        public T oneRequired() {
            while (!this.isExhausted()) {
                Object n = this.objects.get(this.i).oneRequired();
                if (!this.filter.test(n)) continue;
                return (T)n;
            }
            throw new ObjectNotFoundException(this.context.getObjectClass(), "one object was required; none found");
        }

        public T onlyOneRequired() {
            T next = this.oneRequired();
            if (this.one() != null) {
                throw new TooManyMatchesFoundException(this.context.getObjectClass(), "only one object was required, more than one found");
            }
            return next;
        }

        public ObjectSet<T> filter(Predicate<? super T> filter) {
            Validate.notNull(filter, (String)"invalid null filter", (Object[])new Object[0]);
            this.filter = filter;
            return this;
        }

        public Stream<T> stream() {
            if (this.isExhausted()) {
                return Stream.empty();
            }
            return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 1296), false);
        }

        public List<T> all() {
            if (this.isExhausted()) {
                return Collections.emptyList();
            }
            ArrayList objs = new ArrayList(this.objects.get(this.i).all());
            while (!this.isExhausted()) {
                this.objects.get(this.i).all().stream().filter(this.filter).forEach(t -> objs.add(t));
            }
            return objs;
        }

        public Iterator<T> iterator() {
            return new Iterator<T>(){
                private T next = null;

                @Override
                public boolean hasNext() {
                    if (this.next != null) {
                        return true;
                    }
                    while (!this.isExhausted()) {
                        Object n = ((ObjectSet)objects.get(i)).one();
                        if (!filter.test(n)) continue;
                        this.next = n;
                        return true;
                    }
                    return false;
                }

                @Override
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    Object next = this.next;
                    this.next = null;
                    return next;
                }
            };
        }

        public int getAvailableWithoutFetching() {
            ObjectSet<T> current;
            if (this.isExhausted()) {
                return 0;
            }
            int num = 0;
            int j = this.i;
            do {
                current = this.objects.get(j);
                num += current.getAvailableWithoutFetching();
            } while (current.isFullyFetched() && ++j < this.objects.size());
            return num;
        }

        public boolean isFullyFetched() {
            if (!this.isExhausted()) {
                int j = this.i;
                do {
                    if (this.objects.get(j).isFullyFetched()) continue;
                    return false;
                } while (++j < this.objects.size());
            }
            return true;
        }

        public ListenableFuture<ObjectSet<T>> fetchMoreObjects() {
            if (!this.isExhausted()) {
                int j = this.i;
                do {
                    ObjectSet<T> current;
                    if ((current = this.objects.get(j)).isFullyFetched()) continue;
                    return current.fetchMoreObjects();
                } while (++j < this.objects.size());
            }
            return this.objects.get(0).fetchMoreObjects();
        }

        public ExecutionInfo getExecutionInfo() {
            if (this.isExhausted()) {
                return this.objects.get(this.objects.size() - 1).getExecutionInfo();
            }
            return this.objects.get(this.i).getExecutionInfo();
        }

        public List<ExecutionInfo> getAllExecutionInfo() {
            return this.objects.stream().flatMap(r -> r.getAllExecutionInfo().stream()).collect(Collectors.toList());
        }
    }
}

